# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

import os
import sys

sys.path.insert(0, os.path.abspath('../biapol_utilities'))


# -- Project information -----------------------------------------------------

project = 'BiAPoL utilities'
copyright = '2021, Robert Haase, Johannes Müller, Marcelo Zoccoler'
author = 'Robert Haase, Johannes Müller, Marcelo Zoccoler'

# The full version, including alpha/beta/rc tags
release = '0.0.1'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'alabaster',  # use alabaster theme (e.g. read the docs)
    'sphinx.ext.autodoc',  # Converts docstrings to html
    'sphinx.ext.coverage',
    'sphinx.ext.napoleon',
    'sphinx.ext.mathjax',  # Print mmathematical expressions
    'nbsphinx',  # link notebooks
    'sphinx.ext.autosummary',  # Make module lists in table
    'sphinx.ext.autosectionlabel',
    'sphinx.ext.extlinks',  # Link external pages
    'sphinx-prompt'
]

# Autosummary uses a customized module template that was taken from here:
# https://stackoverflow.com/questions/48074094/use-sphinx-autosummary-recursively-to-generate-api-documentation

autosummary_generate = True  # Turn on sphinx.ext.autosummary

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = [
    '_build',
    'Thumbs.db',
    '.DS_Store',
    '**/.ipynb_checkpoints'
    ]

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

html_theme = 'alabaster'

html_sidebars = {
    '**': [
        'about.html',
        'navigation.html',
        'relations.html',
        'searchbox.html',
    ]
}

html_theme_options = {
    'logo': 'logos/biapol_logo.png',
}
# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']
