#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['ninja_jwt',
 'ninja_jwt.token_blacklist',
 'ninja_jwt.token_blacklist.management',
 'ninja_jwt.token_blacklist.management.commands',
 'ninja_jwt.token_blacklist.migrations']

package_data = \
{'': ['*'],
 'ninja_jwt': ['locale/*',
               'locale/cs/*',
               'locale/cs/LC_MESSAGES/*',
               'locale/de_CH/*',
               'locale/de_CH/LC_MESSAGES/*',
               'locale/es/*',
               'locale/es/LC_MESSAGES/*',
               'locale/es_AR/*',
               'locale/es_AR/LC_MESSAGES/*',
               'locale/es_CL/*',
               'locale/es_CL/LC_MESSAGES/*',
               'locale/fa_IR/*',
               'locale/fa_IR/LC_MESSAGES/*',
               'locale/fr/*',
               'locale/fr/LC_MESSAGES/*',
               'locale/id_ID/*',
               'locale/id_ID/LC_MESSAGES/*',
               'locale/it_IT/*',
               'locale/it_IT/LC_MESSAGES/*',
               'locale/nl_NL/*',
               'locale/nl_NL/LC_MESSAGES/*',
               'locale/pl_PL/*',
               'locale/pl_PL/LC_MESSAGES/*',
               'locale/pt_BR/*',
               'locale/pt_BR/LC_MESSAGES/*',
               'locale/ru_RU/*',
               'locale/ru_RU/LC_MESSAGES/*',
               'locale/uk_UA/*',
               'locale/uk_UA/LC_MESSAGES/*',
               'locale/zh_Hans/*',
               'locale/zh_Hans/LC_MESSAGES/*']}

install_requires = \
['Django >= 2.1',
 'pyjwt>=2,<3',
 'pyjwt[crypto]',
 'ninja-schema',
 'django-ninja-extra']

extras_require = \
{'test': ['pytest',
          'pytest-cov',
          'pytest-django',
          'black',
          'isort',
          'flake8',
          'mypy',
          'django-stubs',
          'python-jose==3.0.0']}

setup(name='django-ninja-jwt',
      version='5.1.0',
      description='Django Ninja JWT - JSON Web Token for Django-Ninja',
      author='Ezeudoh Tochukwu',
      author_email='tochukwu.ezeudoh@gmail.com',
      url='https://github.com/eadwinCode/django-ninja-jwt',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
