"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Accelerator = exports.AcceleratorProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "AcceleratorProperty", { enumerable: true, get: function () { return ga_generated_1.RosAccelerator; } });
/**
 * A ROS resource type:  `ALIYUN::GA::Accelerator`
 */
class Accelerator extends ros.Resource {
    /**
     * Create a new `ALIYUN::GA::Accelerator`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccelerator = new ga_generated_1.RosAccelerator(this, id, {
            acceleratorName: props.acceleratorName,
            autoUseCoupon: props.autoUseCoupon,
            pricingCycle: props.pricingCycle,
            duration: props.duration,
            autoPay: props.autoPay,
            spec: props.spec,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccelerator;
        this.attrAcceleratorId = rosAccelerator.attrAcceleratorId;
        this.attrAcceleratorName = rosAccelerator.attrAcceleratorName;
        this.attrAutoPay = rosAccelerator.attrAutoPay;
        this.attrAutoUseCoupon = rosAccelerator.attrAutoUseCoupon;
        this.attrDuration = rosAccelerator.attrDuration;
        this.attrOrderId = rosAccelerator.attrOrderId;
        this.attrPaymentType = rosAccelerator.attrPaymentType;
        this.attrPricingCycle = rosAccelerator.attrPricingCycle;
        this.attrSpec = rosAccelerator.attrSpec;
    }
}
exports.Accelerator = Accelerator;
//# sourceMappingURL=data:application/json;base64,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