"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.EndpointGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "EndpointGroupProperty", { enumerable: true, get: function () { return ga_generated_1.RosEndpointGroup; } });
/**
 * A ROS resource type:  `ALIYUN::GA::EndpointGroup`
 */
class EndpointGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::GA::EndpointGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosEndpointGroup = new ga_generated_1.RosEndpointGroup(this, id, {
            healthCheckIntervalSeconds: props.healthCheckIntervalSeconds,
            trafficPercentage: props.trafficPercentage,
            description: props.description,
            healthCheckPath: props.healthCheckPath,
            thresholdCount: props.thresholdCount,
            healthCheckEnabled: props.healthCheckEnabled,
            endpointRequestProtocol: props.endpointRequestProtocol,
            name: props.name,
            endpointGroupRegion: props.endpointGroupRegion,
            healthCheckProtocol: props.healthCheckProtocol,
            healthCheckPort: props.healthCheckPort,
            acceleratorId: props.acceleratorId,
            endpointConfigurations: props.endpointConfigurations,
            endpointGroupType: props.endpointGroupType,
            listenerId: props.listenerId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEndpointGroup;
        this.attrEndpointGroupId = rosEndpointGroup.attrEndpointGroupId;
    }
}
exports.EndpointGroup = EndpointGroup;
//# sourceMappingURL=data:application/json;base64,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