import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2-alpha';
import * as servicediscovery from 'aws-cdk-lib/aws-servicediscovery';
import { HttpPrivateIntegrationOptions } from './base-types';
import { HttpPrivateIntegration } from './private/integration';
/**
 * (experimental) Properties to initialize `HttpServiceDiscoveryIntegration`.
 *
 * @experimental
 */
export interface HttpServiceDiscoveryIntegrationProps extends HttpPrivateIntegrationOptions {
    /**
     * (experimental) The discovery service used for the integration.
     *
     * @experimental
     */
    readonly service: servicediscovery.IService;
}
/**
 * (experimental) The Service Discovery integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpServiceDiscoveryIntegration extends HttpPrivateIntegration {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: HttpServiceDiscoveryIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(_: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
