# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['falocalrepo']

package_data = \
{'': ['*']}

install_requires = \
['faapi==2.5.0', 'filetype==1.0.7']

entry_points = \
{'console_scripts': ['falocalrepo = falocalrepo.__main__:main']}

setup_kwargs = {
    'name': 'falocalrepo',
    'version': '3.0.1',
    'description': "Pure Python program to download any user's gallery/scraps/favorites and more from FurAffinity forum in an easily handled database.",
    'long_description': '# FALocalRepo\n\n[![pypi version](https://img.shields.io/pypi/v/falocalrepo)](https://pypi.org/project/falocalrepo/)\n[![supported Python version](https://img.shields.io/pypi/pyversions/falocalrepo)](https://pypi.org/project/falocalrepo/)\n[![license](https://img.shields.io/pypi/l/falocalrepo)](https://pypi.org/project/falocalrepo/)\n\nPure Python program to download any user\'s gallery/scraps/favorites from the FurAffinity forum in an easily handled database.\n\n## Introduction\n\nThis program was born with the desire to provide a relatively easy-to-use method for FA users to download submissions that they care about from the forum.\n\nThis program uses a custom scraping library to get content from FurAffinity. This is developed as a separate package also available on PyPi ([FAAPI@PyPi.org](https://pypi.org/project/faapi/)) and GitLab ([FAAPI@GitLab.com](https://gitlab.com/MatteoCampinoti94/FAAPI)). The data thus collected is then stored into a SQLite3 database and the submissions files are saved in a tiered tree structure based on their ID\'s.\n\n## Contents\n\n1. [Installation](#installation--requirements)\n2. [How to Read Usage Instructions](#how-to-read-usage-instructions)\n2. [Cookies](#cookies)\n3. [Usage](#usage)\n    1. [Help](#help)\n    2. [Init](#init)\n    3. [Configuration](#configuration)\n    4. [Download](#download)\n    5. [Database](#database)\n4. [Database](#database-1)\n5. [Submission Files](#submission-files)\n6. [Upgrading from Earlier Versions](#upgrading-from-earlier-versions)\n7. [Issues](#issues)\n8. [Appendix](#appendix)\n\n## Installation & Requirements\n\nTo install the program it is sufficient to use Python pip and get the package `falocalrepo`.\n\n```shell\npython3 -m pip install falocalrepo\n```\n\nPython 3.8 or above is needed to run this program, all other dependencies are handled by pip during installation. For information on how to install Python on your computer, refer to the official website [Python.org](https://www.python.org/).\n\nThe program needs cookies from a logged-in FurAffinity session to download protected pages. Without the cookies the program can still download publicly available pages, but others will return empty. See [#Cookies](#cookies) for more details on which cookies to use.\n\n**Warning**: FurAffinity theme needs to be set to "beta"\n\n## How to Read Usage Instructions\n\n* `command` a static command keyword\n* `<arg>` `<param>` `value` an argument, parameter, value, etc... that must be provided to a command\n* `[<optional>]` an optional argument that can be omitted\n\n## Cookies\n\nThe scraping library used by this program needs two specific cookies from a logged-in FurAffinity session. These are cookie `a` and cookie `b`.\n\nAs of 2020-08-09 these take the form of hexadecimal strings like `356f5962-5a60-0922-1c11-65003b703038`.\n\nThe easiest way to obtain these cookies is by using a browser extension to extract your cookies and then search for `a` and `b`.<br>\nAlternatively, the storage inspection tool of a desktop browser can also be used. For example on Mozilla\'s Firefox this can be opened with &#8679;F9 shortcut.\n\nTo set the cookies use the `config cookies` command. See [#Configuration](#configuration) for more details.\n\n## Usage\n\nTo run the program, simply call `falocalrepo` in your shell after installation.\n\nRunning without arguments will prompt a help message with all the available options and commands.\n\nGenerally, commands need to be in the following format:\n\n```\nfalocalrepo [-h] [-v] [-d] <command> [<arg1>] ... [<argN>]\n```\n\nAvailable options are:\n\n* `-h, --help` show help message\n* `-v, --version` show program version\n* `-d, --database` show database version\n\nAvailable commands are:\n\n* `help` display the manual of a command\n* `init` create the database and exit\n* `config` manage settings\n* `download` perform downloads\n* `database` operate on the database\n\n_Note:_ all the commands with the exception of `help` will create and initialise the database if it is not present in the folder\n\nWhen the database is first initialised, it defaults the submissions files folder to `FA.files`. This value can be changed using the [`config` command](#configuration).\n\nCookies need to be set manually with the config command before the program will be able to access protected pages.\n\n### Help\n\n`help [<command>]`\n\nThe `help` command gives information on the usage of the program and its commands. Run alone for help on the whole program and with a single argument to get help for a specific command.\n\n```\nfalocalrepo help\n```\n```\nfalocalrepo help download\n```\n\n### Init\n\nThe `init` command initialises the database or, if one is already present, updates to a new version - if available - and then exits.\n\nIt can be used to create the database and then manually edit it, or to update it to a new version without calling other commands.\n\n### Configuration\n\n`config [<setting>] [<value1>] ... [<valueN>]`\n\nThe `config` command allows to change the settings used by the program.\n\nRunning the command alone will show the current values of the settings stored in the database. Running `config <setting>` without value arguments will show the current value of that specific setting.\n\nAvailable settings are:\n\n* `cookies [<cookie a>] [<cookie b>]` the cookies stored in the database.\n```\nfalocalrepo config cookies 38565475-3421-3f21-7f63-3d341339737 356f5962-5a60-0922-1c11-65003b703038\n```\n* `files-folder [<new folder>]` the folder used to store submission files. This can be any path relative to the folder of the database. If a new value is given, the program will move any files to the new location.\n```\nfalocalrepo config files-folder SubmissionFiles\n```\n\n### Download\n\n`download <operation> [<arg1>] ... [<argN>]`\n\nThe `download` command performs all download and repository update operations.\n\nAvailable operations are:\n\n* `update` update the repository by checking the previously downloaded folders (gallery, scraps or favorites) of each user and stopping when it finds a submission that is already present in the repository. Requires no arguments.\n* `users <user1>,...,<userN> <folder1>,...,<folderN>` download specific user folders. Requires two arguments in the format is one of gallery, scraps or favorites.\n```\nfalocalrepo download users tom,jerry gallery,scraps\n```\n* `submissions <id1> ... [<idN>]` download specific submissions. Requires submission ID\'s provided as separate arguments.\n```\nfalocalrepo download submissions 12345678 13572468 87651234\n```\n\n### Database\n\n`database [<operation>] [<param1>=<value1>] ... [<paramN>=<valueN>]`\n\nThe `database` command allows to operate on the database. Used without an operation command shows the database statistics (number of users and submissions and time of last update) and version.\n\nAvailable operations are:\n\n* `search <param1>=<value1> ... [<paramN>=<valueN>]` search the submissions entries using metadata fields. Search is conducted case-insensitively using the SQLite `like` expression which allows for limited pattern matching. For example this string can be used to search two tags together separated by an unknown amount of characters `cat,%mouse`. The following search parameters are supported:\n    * `author` author (uploader) in display format - e.g. with underscores "_" -\n    * `title`\n    * `date`\n    * `description` \n    * `tags` alphabetically sorted tags (keywords)\n    * `category`\n    * `species`\n    * `gender`\n    * `rating`\n```\nfalocalrepo database search tags=cat,%mouse date=2020-% category=%artwork%\n```\n* `manual-entry <param1>=<value1> ... <paramN>=<valueN>` add a submission to the database manually. The submission file is not downloaded and can instead be provided with the extra parameter `file_local_url`. The following parameters are necessary for a submission entry to be accepted:\n    * `id` submission id\n    * `title`\n    * `author`\n    * `date` date in the format YYYY-MM-DD\n    * `category`\n    * `species`\n    * `gender`\n    * `rating`<br>\nThe following parameters are optional:\n    * `tags` comma-separated tags\n    * `description`\n    * `file_url` the url of the submission file, not used to download the file\n    * `file_local_url` if provided, take the submission file from this path and put it into the database\n```\nfalocalrepo database manual-entry id=12345678 \'title=cat & mouse\' author=CartoonArtist \\\n    date=2020-08-09 category=Artwork \'species=Unspecified / Any\' gender=Any rating=General \\\n    tags=cat,mouse,cartoon \'description=There once were a cat named Tom and a mouse named Jerry.\' \\\n    \'file_url=http://remote.url/to/submission.file\' file_local_url=path/to/submission.file\n```\n* `check-errors` check the database for common errors and prints a list of entries that contain erroneous data. Requires no arguments.\n* `remove-users <user1> ... [<userN>]` remove specific users from the database.\n```\nfalocalrepo database remove-users jerry\n```\n* `remove-submissions <id1> ... [<idN>]` remove specific submissions from the database.\n```\nfalocalrepo database remove-submissions 12345678 13572468 87651234\n```\n* `clean` clean the database using the SQLite [VACUUM](https://www.sqlite.org/lang_vacuum.html) function. Requires no arguments.\n\n## Database\n\nTo store the metadata of the downloaded submissions, downloaded users, cookies and statistics, the program uses a SQLite3 database. This database is built to be as light as possible while also containing all the metadata that can be extracted from a submission page. \n\nTo store all this information, the database uses three tables: `SETTINGS`, `USERS` and `SUBMISSIONS`.\n\n### `SETTINGS`\n\nThe settings table contains settings for the program and statistics of the database.\n\n* `USRN` number of users in the `USERS` table\n* `SUBN` number of submissions in the `SUBMISSIONS` table\n* `LASTUPDATE` time when the last update was completed (UNIX time in seconds)\n* `LASTSTART` time when the program was last started (UNIX time in seconds)\n* `COOKIES` cookies for the scraper, stored in JSON format\n* `FILESFOLDER` location of downloaded submission files\n* `VERSION` database version, this can differ from the program version\n\n### `USERS`\n\nThe users table contains a list of all the users that have been download with the program, the folders that have been downloaded and the submissions found in each of those.\n\nEach entry contains the following fields:\n\n* `USERNAME` The URL username of the user (no underscores or spaces)\n* `FOLDERS` the folders downloaded for that specific user.\n* `GALLERY`\n* `SCRAPS`\n* `FAVORITES`\n* `EXTRAS` this is a legacy entry used by the program up to version 2.11.2\n\n### `SUBMISSIONS`\n\nThe submissions table contains the metadata of the submissions downloaded by the program and information on their files \n\n* `ID` the id of the submission\n* `AUTHOR` the username of the author (uploader) in full format\n* `TITLE`\n* `UDATE` upload date in the format YYYY-MM-DD\n* `DESCRIPTION` description in html format\n* `TAGS` keywords sorted alphanumerically and comma-separated\n* `CATEGORY`\n* `SPECIES`\n* `GENDER`\n* `RATING`\n* `FILELINK` the remote URL of the submission file\n* `FILEEXT` the extensions of the downloaded file. Can be empty if the file contained errors and could not be recognised upon download\n* `FILESAVED` 1 if the file was successfully downloaded and saved, 0 if there was an error during download\n\n## Submission Files\n\nSubmission files are saved in a tiered tree structure based on their submission ID. ID\'s are zero-padded to 10 digits and then broken up in 5 segments of 2 digits; each of this segments represents a folder tha will be created in the tree.\n\nFor example, a submission `1457893` will be padded to `0001457893` and divided into `00`, `01`, `45`, `78`, `93`. The submission file will then be saved as `00/01/45/78/93/submission.file` with the correct extension extracted from the file itself - FurAffinity links do not always contain the right extension and often confuse jpg and png -.\n\n## Upgrading from Earlier Versions\n\nWhen the program starts, it checks the version of the database against the one used by the program and if the latter is more advanced it updates the database.\n\n_Note:_ Versions before 2.7.0 are not supported by falocalrepo version 3.0.0 and above. To update from those to the new version use version 2.11.2 to update the database to version 2.7.0\n\n### 2.7.0 &rarr; 3.0.0\n\nInformation from the database are copied over to the new version, but otherwise remain unaltered save for a few changed column names in the `SUBMISSIONS` and `USERS` tables.\n\nFiles are moved to the new structure and the old files folder is deleted. Only submissions files are kept starting from version 3.0.0\n\n## Issues\n\nIf any problem is encountered during usage of the program, an issue can be opened on the project\'s Gitlab page: [FALocalRepo/Issues](https://gitlab.com/MatteoCampinoti94/FALocalRepo/issues).\n\nWhen opening an issue on GitLab, please copy the error message and describe the operation in progress when the error occurred.\n\n## Appendix\n\n### Earlier Releases\n\nRelease binaries for versions 2.11.x can be found on GitLab under tags -> [FALocalRepo/tags 2.11](https://gitlab.com/MatteoCampinoti94/FALocalRepo/tags?search=v2.11)\n\nRelease binaries before and including 2.10.2 can be found on GitHub -> [Releases](https://github.com/MatteoCampinoti94/FALocalRepo/releases).',
    'author': 'Matteo Campinoti',
    'author_email': 'matteo.campinoti94@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/MatteoCampinoti94/FALocalRepo',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
