/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

// NOLINT(build/header_guard)

/*
 * Adobe Glyph List v1.2, sorted by glyph name. 1051 entries.
 *
 * Some glyph names are mapped to two Unicode values. In these cases, the entry
 * with the "secondary" Unicode value records the glyph name with a percent
 * sign appended, to distinguish it from the other entry, the "primary" Unicode
 * value. The percent sign is not to be construed as part of the glyph name in
 * a font; rather, it indicates in this table that the glyph is being mapped to
 * more than one Unicode value.
 *
 * Refer to the document "Unicode and Glyph Names" at:
 * http://partners.adobe.com/asn/developer/typeforum/unicodegn.html
 * for information on how to use this list.
 *
 * This is an aggregate initializer for an array of structs of type:
 * typedef struct
 *     {
 *     const char *glyphName;  // PostScript glyph name
 *     unsigned short uv;      // Unicode value
 *     } UnicodeChar;
 */

    { "A",                    0x0041 },
    { "AE",                   0x00C6 },
    { "AEacute",              0x01FC },
    { "AEsmall",              0xF7E6 },
    { "Aacute",               0x00C1 },
    { "Aacutesmall",          0xF7E1 },
    { "Abreve",               0x0102 },
    { "Acircumflex",          0x00C2 },
    { "Acircumflexsmall",     0xF7E2 },
    { "Acute",                0xF6C9 },
    { "Acutesmall",           0xF7B4 },
    { "Adieresis",            0x00C4 },
    { "Adieresissmall",       0xF7E4 },
    { "Agrave",               0x00C0 },
    { "Agravesmall",          0xF7E0 },
    { "Alpha",                0x0391 },
    { "Alphatonos",           0x0386 },
    { "Amacron",              0x0100 },
    { "Aogonek",              0x0104 },
    { "Aring",                0x00C5 },
    { "Aringacute",           0x01FA },
    { "Aringsmall",           0xF7E5 },
    { "Asmall",               0xF761 },
    { "Atilde",               0x00C3 },
    { "Atildesmall",          0xF7E3 },
    { "B",                    0x0042 },
    { "Beta",                 0x0392 },
    { "Brevesmall",           0xF6F4 },
    { "Bsmall",               0xF762 },
    { "C",                    0x0043 },
    { "Cacute",               0x0106 },
    { "Caron",                0xF6CA },
    { "Caronsmall",           0xF6F5 },
    { "Ccaron",               0x010C },
    { "Ccedilla",             0x00C7 },
    { "Ccedillasmall",        0xF7E7 },
    { "Ccircumflex",          0x0108 },
    { "Cdotaccent",           0x010A },
    { "Cedillasmall",         0xF7B8 },
    { "Chi",                  0x03A7 },
    { "Circumflexsmall",      0xF6F6 },
    { "Csmall",               0xF763 },
    { "D",                    0x0044 },
    { "Dcaron",               0x010E },
    { "Dcroat",               0x0110 },
    { "Delta",                0x2206 },
    { "Delta%",               0x0394 },
    { "Dieresis",             0xF6CB },
    { "DieresisAcute",        0xF6CC },
    { "DieresisGrave",        0xF6CD },
    { "Dieresissmall",        0xF7A8 },
    { "Dotaccentsmall",       0xF6F7 },
    { "Dsmall",               0xF764 },
    { "E",                    0x0045 },
    { "Eacute",               0x00C9 },
    { "Eacutesmall",          0xF7E9 },
    { "Ebreve",               0x0114 },
    { "Ecaron",               0x011A },
    { "Ecircumflex",          0x00CA },
    { "Ecircumflexsmall",     0xF7EA },
    { "Edieresis",            0x00CB },
    { "Edieresissmall",       0xF7EB },
    { "Edotaccent",           0x0116 },
    { "Egrave",               0x00C8 },
    { "Egravesmall",          0xF7E8 },
    { "Emacron",              0x0112 },
    { "Eng",                  0x014A },
    { "Eogonek",              0x0118 },
    { "Epsilon",              0x0395 },
    { "Epsilontonos",         0x0388 },
    { "Esmall",               0xF765 },
    { "Eta",                  0x0397 },
    { "Etatonos",             0x0389 },
    { "Eth",                  0x00D0 },
    { "Ethsmall",             0xF7F0 },
    { "Euro",                 0x20AC },
    { "F",                    0x0046 },
    { "Fsmall",               0xF766 },
    { "G",                    0x0047 },
    { "Gamma",                0x0393 },
    { "Gbreve",               0x011E },
    { "Gcaron",               0x01E6 },
    { "Gcircumflex",          0x011C },
    { "Gcommaaccent",         0x0122 },
    { "Gdotaccent",           0x0120 },
    { "Grave",                0xF6CE },
    { "Gravesmall",           0xF760 },
    { "Gsmall",               0xF767 },
    { "H",                    0x0048 },
    { "H18533",               0x25CF },
    { "H18543",               0x25AA },
    { "H18551",               0x25AB },
    { "H22073",               0x25A1 },
    { "Hbar",                 0x0126 },
    { "Hcircumflex",          0x0124 },
    { "Hsmall",               0xF768 },
    { "Hungarumlaut",         0xF6CF },
    { "Hungarumlautsmall",    0xF6F8 },
    { "I",                    0x0049 },
    { "IJ",                   0x0132 },
    { "Iacute",               0x00CD },
    { "Iacutesmall",          0xF7ED },
    { "Ibreve",               0x012C },
    { "Icircumflex",          0x00CE },
    { "Icircumflexsmall",     0xF7EE },
    { "Idieresis",            0x00CF },
    { "Idieresissmall",       0xF7EF },
    { "Idotaccent",           0x0130 },
    { "Ifraktur",             0x2111 },
    { "Igrave",               0x00CC },
    { "Igravesmall",          0xF7EC },
    { "Imacron",              0x012A },
    { "Iogonek",              0x012E },
    { "Iota",                 0x0399 },
    { "Iotadieresis",         0x03AA },
    { "Iotatonos",            0x038A },
    { "Ismall",               0xF769 },
    { "Itilde",               0x0128 },
    { "J",                    0x004A },
    { "Jcircumflex",          0x0134 },
    { "Jsmall",               0xF76A },
    { "K",                    0x004B },
    { "Kappa",                0x039A },
    { "Kcommaaccent",         0x0136 },
    { "Ksmall",               0xF76B },
    { "L",                    0x004C },
    { "LL",                   0xF6BF },
    { "Lacute",               0x0139 },
    { "Lambda",               0x039B },
    { "Lcaron",               0x013D },
    { "Lcommaaccent",         0x013B },
    { "Ldot",                 0x013F },
    { "Lslash",               0x0141 },
    { "Lslashsmall",          0xF6F9 },
    { "Lsmall",               0xF76C },
    { "M",                    0x004D },
    { "Macron",               0xF6D0 },
    { "Macronsmall",          0xF7AF },
    { "Msmall",               0xF76D },
    { "Mu",                   0x039C },
    { "N",                    0x004E },
    { "Nacute",               0x0143 },
    { "Ncaron",               0x0147 },
    { "Ncommaaccent",         0x0145 },
    { "Nsmall",               0xF76E },
    { "Ntilde",               0x00D1 },
    { "Ntildesmall",          0xF7F1 },
    { "Nu",                   0x039D },
    { "O",                    0x004F },
    { "OE",                   0x0152 },
    { "OEsmall",              0xF6FA },
    { "Oacute",               0x00D3 },
    { "Oacutesmall",          0xF7F3 },
    { "Obreve",               0x014E },
    { "Ocircumflex",          0x00D4 },
    { "Ocircumflexsmall",     0xF7F4 },
    { "Odieresis",            0x00D6 },
    { "Odieresissmall",       0xF7F6 },
    { "Ogoneksmall",          0xF6FB },
    { "Ograve",               0x00D2 },
    { "Ogravesmall",          0xF7F2 },
    { "Ohorn",                0x01A0 },
    { "Ohungarumlaut",        0x0150 },
    { "Omacron",              0x014C },
    { "Omega",                0x2126 },
    { "Omega%",               0x03A9 },
    { "Omegatonos",           0x038F },
    { "Omicron",              0x039F },
    { "Omicrontonos",         0x038C },
    { "Oslash",               0x00D8 },
    { "Oslashacute",          0x01FE },
    { "Oslashsmall",          0xF7F8 },
    { "Osmall",               0xF76F },
    { "Otilde",               0x00D5 },
    { "Otildesmall",          0xF7F5 },
    { "P",                    0x0050 },
    { "Phi",                  0x03A6 },
    { "Pi",                   0x03A0 },
    { "Psi",                  0x03A8 },
    { "Psmall",               0xF770 },
    { "Q",                    0x0051 },
    { "Qsmall",               0xF771 },
    { "R",                    0x0052 },
    { "Racute",               0x0154 },
    { "Rcaron",               0x0158 },
    { "Rcommaaccent",         0x0156 },
    { "Rfraktur",             0x211C },
    { "Rho",                  0x03A1 },
    { "Ringsmall",            0xF6FC },
    { "Rsmall",               0xF772 },
    { "S",                    0x0053 },
    { "SF010000",             0x250C },
    { "SF020000",             0x2514 },
    { "SF030000",             0x2510 },
    { "SF040000",             0x2518 },
    { "SF050000",             0x253C },
    { "SF060000",             0x252C },
    { "SF070000",             0x2534 },
    { "SF080000",             0x251C },
    { "SF090000",             0x2524 },
    { "SF100000",             0x2500 },
    { "SF110000",             0x2502 },
    { "SF190000",             0x2561 },
    { "SF200000",             0x2562 },
    { "SF210000",             0x2556 },
    { "SF220000",             0x2555 },
    { "SF230000",             0x2563 },
    { "SF240000",             0x2551 },
    { "SF250000",             0x2557 },
    { "SF260000",             0x255D },
    { "SF270000",             0x255C },
    { "SF280000",             0x255B },
    { "SF360000",             0x255E },
    { "SF370000",             0x255F },
    { "SF380000",             0x255A },
    { "SF390000",             0x2554 },
    { "SF400000",             0x2569 },
    { "SF410000",             0x2566 },
    { "SF420000",             0x2560 },
    { "SF430000",             0x2550 },
    { "SF440000",             0x256C },
    { "SF450000",             0x2567 },
    { "SF460000",             0x2568 },
    { "SF470000",             0x2564 },
    { "SF480000",             0x2565 },
    { "SF490000",             0x2559 },
    { "SF500000",             0x2558 },
    { "SF510000",             0x2552 },
    { "SF520000",             0x2553 },
    { "SF530000",             0x256B },
    { "SF540000",             0x256A },
    { "Sacute",               0x015A },
    { "Scaron",               0x0160 },
    { "Scaronsmall",          0xF6FD },
    { "Scedilla",             0x015E },
    { "Scedilla%",            0xF6C1 },
    { "Scircumflex",          0x015C },
    { "Scommaaccent",         0x0218 },
    { "Sigma",                0x03A3 },
    { "Ssmall",               0xF773 },
    { "T",                    0x0054 },
    { "Tau",                  0x03A4 },
    { "Tbar",                 0x0166 },
    { "Tcaron",               0x0164 },
    { "Tcommaaccent",         0x0162 },
    { "Tcommaaccent%",        0x021A },
    { "Theta",                0x0398 },
    { "Thorn",                0x00DE },
    { "Thornsmall",           0xF7FE },
    { "Tildesmall",           0xF6FE },
    { "Tsmall",               0xF774 },
    { "U",                    0x0055 },
    { "Uacute",               0x00DA },
    { "Uacutesmall",          0xF7FA },
    { "Ubreve",               0x016C },
    { "Ucircumflex",          0x00DB },
    { "Ucircumflexsmall",     0xF7FB },
    { "Udieresis",            0x00DC },
    { "Udieresissmall",       0xF7FC },
    { "Ugrave",               0x00D9 },
    { "Ugravesmall",          0xF7F9 },
    { "Uhorn",                0x01AF },
    { "Uhungarumlaut",        0x0170 },
    { "Umacron",              0x016A },
    { "Uogonek",              0x0172 },
    { "Upsilon",              0x03A5 },
    { "Upsilon1",             0x03D2 },
    { "Upsilondieresis",      0x03AB },
    { "Upsilontonos",         0x038E },
    { "Uring",                0x016E },
    { "Usmall",               0xF775 },
    { "Utilde",               0x0168 },
    { "V",                    0x0056 },
    { "Vsmall",               0xF776 },
    { "W",                    0x0057 },
    { "Wacute",               0x1E82 },
    { "Wcircumflex",          0x0174 },
    { "Wdieresis",            0x1E84 },
    { "Wgrave",               0x1E80 },
    { "Wsmall",               0xF777 },
    { "X",                    0x0058 },
    { "Xi",                   0x039E },
    { "Xsmall",               0xF778 },
    { "Y",                    0x0059 },
    { "Yacute",               0x00DD },
    { "Yacutesmall",          0xF7FD },
    { "Ycircumflex",          0x0176 },
    { "Ydieresis",            0x0178 },
    { "Ydieresissmall",       0xF7FF },
    { "Ygrave",               0x1EF2 },
    { "Ysmall",               0xF779 },
    { "Z",                    0x005A },
    { "Zacute",               0x0179 },
    { "Zcaron",               0x017D },
    { "Zcaronsmall",          0xF6FF },
    { "Zdotaccent",           0x017B },
    { "Zeta",                 0x0396 },
    { "Zsmall",               0xF77A },
    { "a",                    0x0061 },
    { "aacute",               0x00E1 },
    { "abreve",               0x0103 },
    { "acircumflex",          0x00E2 },
    { "acute",                0x00B4 },
    { "acutecomb",            0x0301 },
    { "adieresis",            0x00E4 },
    { "ae",                   0x00E6 },
    { "aeacute",              0x01FD },
    { "afii00208",            0x2015 },
    { "afii10017",            0x0410 },
    { "afii10018",            0x0411 },
    { "afii10019",            0x0412 },
    { "afii10020",            0x0413 },
    { "afii10021",            0x0414 },
    { "afii10022",            0x0415 },
    { "afii10023",            0x0401 },
    { "afii10024",            0x0416 },
    { "afii10025",            0x0417 },
    { "afii10026",            0x0418 },
    { "afii10027",            0x0419 },
    { "afii10028",            0x041A },
    { "afii10029",            0x041B },
    { "afii10030",            0x041C },
    { "afii10031",            0x041D },
    { "afii10032",            0x041E },
    { "afii10033",            0x041F },
    { "afii10034",            0x0420 },
    { "afii10035",            0x0421 },
    { "afii10036",            0x0422 },
    { "afii10037",            0x0423 },
    { "afii10038",            0x0424 },
    { "afii10039",            0x0425 },
    { "afii10040",            0x0426 },
    { "afii10041",            0x0427 },
    { "afii10042",            0x0428 },
    { "afii10043",            0x0429 },
    { "afii10044",            0x042A },
    { "afii10045",            0x042B },
    { "afii10046",            0x042C },
    { "afii10047",            0x042D },
    { "afii10048",            0x042E },
    { "afii10049",            0x042F },
    { "afii10050",            0x0490 },
    { "afii10051",            0x0402 },
    { "afii10052",            0x0403 },
    { "afii10053",            0x0404 },
    { "afii10054",            0x0405 },
    { "afii10055",            0x0406 },
    { "afii10056",            0x0407 },
    { "afii10057",            0x0408 },
    { "afii10058",            0x0409 },
    { "afii10059",            0x040A },
    { "afii10060",            0x040B },
    { "afii10061",            0x040C },
    { "afii10062",            0x040E },
    { "afii10063",            0xF6C4 },
    { "afii10064",            0xF6C5 },
    { "afii10065",            0x0430 },
    { "afii10066",            0x0431 },
    { "afii10067",            0x0432 },
    { "afii10068",            0x0433 },
    { "afii10069",            0x0434 },
    { "afii10070",            0x0435 },
    { "afii10071",            0x0451 },
    { "afii10072",            0x0436 },
    { "afii10073",            0x0437 },
    { "afii10074",            0x0438 },
    { "afii10075",            0x0439 },
    { "afii10076",            0x043A },
    { "afii10077",            0x043B },
    { "afii10078",            0x043C },
    { "afii10079",            0x043D },
    { "afii10080",            0x043E },
    { "afii10081",            0x043F },
    { "afii10082",            0x0440 },
    { "afii10083",            0x0441 },
    { "afii10084",            0x0442 },
    { "afii10085",            0x0443 },
    { "afii10086",            0x0444 },
    { "afii10087",            0x0445 },
    { "afii10088",            0x0446 },
    { "afii10089",            0x0447 },
    { "afii10090",            0x0448 },
    { "afii10091",            0x0449 },
    { "afii10092",            0x044A },
    { "afii10093",            0x044B },
    { "afii10094",            0x044C },
    { "afii10095",            0x044D },
    { "afii10096",            0x044E },
    { "afii10097",            0x044F },
    { "afii10098",            0x0491 },
    { "afii10099",            0x0452 },
    { "afii10100",            0x0453 },
    { "afii10101",            0x0454 },
    { "afii10102",            0x0455 },
    { "afii10103",            0x0456 },
    { "afii10104",            0x0457 },
    { "afii10105",            0x0458 },
    { "afii10106",            0x0459 },
    { "afii10107",            0x045A },
    { "afii10108",            0x045B },
    { "afii10109",            0x045C },
    { "afii10110",            0x045E },
    { "afii10145",            0x040F },
    { "afii10146",            0x0462 },
    { "afii10147",            0x0472 },
    { "afii10148",            0x0474 },
    { "afii10192",            0xF6C6 },
    { "afii10193",            0x045F },
    { "afii10194",            0x0463 },
    { "afii10195",            0x0473 },
    { "afii10196",            0x0475 },
    { "afii10831",            0xF6C7 },
    { "afii10832",            0xF6C8 },
    { "afii10846",            0x04D9 },
    { "afii299",              0x200E },
    { "afii300",              0x200F },
    { "afii301",              0x200D },
    { "afii57381",            0x066A },
    { "afii57388",            0x060C },
    { "afii57392",            0x0660 },
    { "afii57393",            0x0661 },
    { "afii57394",            0x0662 },
    { "afii57395",            0x0663 },
    { "afii57396",            0x0664 },
    { "afii57397",            0x0665 },
    { "afii57398",            0x0666 },
    { "afii57399",            0x0667 },
    { "afii57400",            0x0668 },
    { "afii57401",            0x0669 },
    { "afii57403",            0x061B },
    { "afii57407",            0x061F },
    { "afii57409",            0x0621 },
    { "afii57410",            0x0622 },
    { "afii57411",            0x0623 },
    { "afii57412",            0x0624 },
    { "afii57413",            0x0625 },
    { "afii57414",            0x0626 },
    { "afii57415",            0x0627 },
    { "afii57416",            0x0628 },
    { "afii57417",            0x0629 },
    { "afii57418",            0x062A },
    { "afii57419",            0x062B },
    { "afii57420",            0x062C },
    { "afii57421",            0x062D },
    { "afii57422",            0x062E },
    { "afii57423",            0x062F },
    { "afii57424",            0x0630 },
    { "afii57425",            0x0631 },
    { "afii57426",            0x0632 },
    { "afii57427",            0x0633 },
    { "afii57428",            0x0634 },
    { "afii57429",            0x0635 },
    { "afii57430",            0x0636 },
    { "afii57431",            0x0637 },
    { "afii57432",            0x0638 },
    { "afii57433",            0x0639 },
    { "afii57434",            0x063A },
    { "afii57440",            0x0640 },
    { "afii57441",            0x0641 },
    { "afii57442",            0x0642 },
    { "afii57443",            0x0643 },
    { "afii57444",            0x0644 },
    { "afii57445",            0x0645 },
    { "afii57446",            0x0646 },
    { "afii57448",            0x0648 },
    { "afii57449",            0x0649 },
    { "afii57450",            0x064A },
    { "afii57451",            0x064B },
    { "afii57452",            0x064C },
    { "afii57453",            0x064D },
    { "afii57454",            0x064E },
    { "afii57455",            0x064F },
    { "afii57456",            0x0650 },
    { "afii57457",            0x0651 },
    { "afii57458",            0x0652 },
    { "afii57470",            0x0647 },
    { "afii57505",            0x06A4 },
    { "afii57506",            0x067E },
    { "afii57507",            0x0686 },
    { "afii57508",            0x0698 },
    { "afii57509",            0x06AF },
    { "afii57511",            0x0679 },
    { "afii57512",            0x0688 },
    { "afii57513",            0x0691 },
    { "afii57514",            0x06BA },
    { "afii57519",            0x06D2 },
    { "afii57534",            0x06D5 },
    { "afii57636",            0x20AA },
    { "afii57645",            0x05BE },
    { "afii57658",            0x05C3 },
    { "afii57664",            0x05D0 },
    { "afii57665",            0x05D1 },
    { "afii57666",            0x05D2 },
    { "afii57667",            0x05D3 },
    { "afii57668",            0x05D4 },
    { "afii57669",            0x05D5 },
    { "afii57670",            0x05D6 },
    { "afii57671",            0x05D7 },
    { "afii57672",            0x05D8 },
    { "afii57673",            0x05D9 },
    { "afii57674",            0x05DA },
    { "afii57675",            0x05DB },
    { "afii57676",            0x05DC },
    { "afii57677",            0x05DD },
    { "afii57678",            0x05DE },
    { "afii57679",            0x05DF },
    { "afii57680",            0x05E0 },
    { "afii57681",            0x05E1 },
    { "afii57682",            0x05E2 },
    { "afii57683",            0x05E3 },
    { "afii57684",            0x05E4 },
    { "afii57685",            0x05E5 },
    { "afii57686",            0x05E6 },
    { "afii57687",            0x05E7 },
    { "afii57688",            0x05E8 },
    { "afii57689",            0x05E9 },
    { "afii57690",            0x05EA },
    { "afii57694",            0xFB2A },
    { "afii57695",            0xFB2B },
    { "afii57700",            0xFB4B },
    { "afii57705",            0xFB1F },
    { "afii57716",            0x05F0 },
    { "afii57717",            0x05F1 },
    { "afii57718",            0x05F2 },
    { "afii57723",            0xFB35 },
    { "afii57793",            0x05B4 },
    { "afii57794",            0x05B5 },
    { "afii57795",            0x05B6 },
    { "afii57796",            0x05BB },
    { "afii57797",            0x05B8 },
    { "afii57798",            0x05B7 },
    { "afii57799",            0x05B0 },
    { "afii57800",            0x05B2 },
    { "afii57801",            0x05B1 },
    { "afii57802",            0x05B3 },
    { "afii57803",            0x05C2 },
    { "afii57804",            0x05C1 },
    { "afii57806",            0x05B9 },
    { "afii57807",            0x05BC },
    { "afii57839",            0x05BD },
    { "afii57841",            0x05BF },
    { "afii57842",            0x05C0 },
    { "afii57929",            0x02BC },
    { "afii61248",            0x2105 },
    { "afii61289",            0x2113 },
    { "afii61352",            0x2116 },
    { "afii61573",            0x202C },
    { "afii61574",            0x202D },
    { "afii61575",            0x202E },
    { "afii61664",            0x200C },
    { "afii63167",            0x066D },
    { "afii64937",            0x02BD },
    { "agrave",               0x00E0 },
    { "aleph",                0x2135 },
    { "alpha",                0x03B1 },
    { "alphatonos",           0x03AC },
    { "amacron",              0x0101 },
    { "ampersand",            0x0026 },
    { "ampersandsmall",       0xF726 },
    { "angle",                0x2220 },
    { "angleleft",            0x2329 },
    { "angleright",           0x232A },
    { "anoteleia",            0x0387 },
    { "aogonek",              0x0105 },
    { "approxequal",          0x2248 },
    { "aring",                0x00E5 },
    { "aringacute",           0x01FB },
    { "arrowboth",            0x2194 },
    { "arrowdblboth",         0x21D4 },
    { "arrowdbldown",         0x21D3 },
    { "arrowdblleft",         0x21D0 },
    { "arrowdblright",        0x21D2 },
    { "arrowdblup",           0x21D1 },
    { "arrowdown",            0x2193 },
    { "arrowhorizex",         0x23AF },
    { "arrowleft",            0x2190 },
    { "arrowright",           0x2192 },
    { "arrowup",              0x2191 },
    { "arrowupdn",            0x2195 },
    { "arrowupdnbse",         0x21A8 },
    { "arrowvertex",          0xF8E6 },
    { "asciicircum",          0x005E },
    { "asciitilde",           0x007E },
    { "asterisk",             0x002A },
    { "asteriskmath",         0x2217 },
    { "asuperior",            0xF6E9 },
    { "at",                   0x0040 },
    { "atilde",               0x00E3 },
    { "b",                    0x0062 },
    { "backslash",            0x005C },
    { "bar",                  0x007C },
    { "beta",                 0x03B2 },
    { "block",                0x2588 },
    { "braceex",              0x23AA },
    { "braceleft",            0x007B },
    { "braceleftbt",          0x23A9 },
    { "braceleftmid",         0x23A8 },
    { "bracelefttp",          0x23A7 },
    { "braceright",           0x007D },
    { "bracerightbt",         0x23AD },
    { "bracerightmid",        0x23AC },
    { "bracerighttp",         0x23AB },
    { "bracketleft",          0x005B },
    { "bracketleftbt",        0x23A3 },
    { "bracketleftex",        0x23A2 },
    { "bracketlefttp",        0x23A1 },
    { "bracketright",         0x005D },
    { "bracketrightbt",       0x23A6 },
    { "bracketrightex",       0x23A5 },
    { "bracketrighttp",       0x23A4 },
    { "breve",                0x02D8 },
    { "brokenbar",            0x00A6 },
    { "bsuperior",            0xF6EA },
    { "bullet",               0x2022 },
    { "c",                    0x0063 },
    { "cacute",               0x0107 },
    { "caron",                0x02C7 },
    { "carriagereturn",       0x21B5 },
    { "ccaron",               0x010D },
    { "ccedilla",             0x00E7 },
    { "ccircumflex",          0x0109 },
    { "cdotaccent",           0x010B },
    { "cedilla",              0x00B8 },
    { "cent",                 0x00A2 },
    { "centinferior",         0xF6DF },
    { "centoldstyle",         0xF7A2 },
    { "centsuperior",         0xF6E0 },
    { "chi",                  0x03C7 },
    { "circle",               0x25CB },
    { "circlemultiply",       0x2297 },
    { "circleplus",           0x2295 },
    { "circumflex",           0x02C6 },
    { "club",                 0x2663 },
    { "colon",                0x003A },
    { "colonmonetary",        0x20A1 },
    { "comma",                0x002C },
    { "commaaccent",          0xF6C3 },
    { "commainferior",        0xF6E1 },
    { "commasuperior",        0xF6E2 },
    { "congruent",            0x2245 },
    { "copyright",            0x00A9 },
    { "copyrightsans",        0xF8E9 },
    { "copyrightserif",       0xF6D9 },
    { "currency",             0x00A4 },
    { "cyrBreve",             0xF6D1 },
    { "cyrFlex",              0xF6D2 },
    { "cyrbreve",             0xF6D4 },
    { "cyrflex",              0xF6D5 },
    { "d",                    0x0064 },
    { "dagger",               0x2020 },
    { "daggerdbl",            0x2021 },
    { "dblGrave",             0xF6D3 },
    { "dblgrave",             0xF6D6 },
    { "dcaron",               0x010F },
    { "dcroat",               0x0111 },
    { "degree",               0x00B0 },
    { "delta",                0x03B4 },
    { "diamond",              0x2666 },
    { "dieresis",             0x00A8 },
    { "dieresisacute",        0xF6D7 },
    { "dieresisgrave",        0xF6D8 },
    { "dieresistonos",        0x0385 },
    { "divide",               0x00F7 },
    { "dkshade",              0x2593 },
    { "dnblock",              0x2584 },
    { "dollar",               0x0024 },
    { "dollarinferior",       0xF6E3 },
    { "dollaroldstyle",       0xF724 },
    { "dollarsuperior",       0xF6E4 },
    { "dong",                 0x20AB },
    { "dotaccent",            0x02D9 },
    { "dotbelowcomb",         0x0323 },
    { "dotlessi",             0x0131 },
    { "dotlessj",             0xF6BE },
    { "dotmath",              0x22C5 },
    { "dsuperior",            0xF6EB },
    { "e",                    0x0065 },
    { "eacute",               0x00E9 },
    { "ebreve",               0x0115 },
    { "ecaron",               0x011B },
    { "ecircumflex",          0x00EA },
    { "edieresis",            0x00EB },
    { "edotaccent",           0x0117 },
    { "egrave",               0x00E8 },
    { "eight",                0x0038 },
    { "eightinferior",        0x2088 },
    { "eightoldstyle",        0xF738 },
    { "eightsuperior",        0x2078 },
    { "element",              0x2208 },
    { "ellipsis",             0x2026 },
    { "emacron",              0x0113 },
    { "emdash",               0x2014 },
    { "emptyset",             0x2205 },
    { "endash",               0x2013 },
    { "eng",                  0x014B },
    { "eogonek",              0x0119 },
    { "epsilon",              0x03B5 },
    { "epsilontonos",         0x03AD },
    { "equal",                0x003D },
    { "equivalence",          0x2261 },
    { "estimated",            0x212E },
    { "esuperior",            0xF6EC },
    { "eta",                  0x03B7 },
    { "etatonos",             0x03AE },
    { "eth",                  0x00F0 },
    { "exclam",               0x0021 },
    { "exclamdbl",            0x203C },
    { "exclamdown",           0x00A1 },
    { "exclamdownsmall",      0xF7A1 },
    { "exclamsmall",          0xF721 },
    { "existential",          0x2203 },
    { "f",                    0x0066 },
    { "female",               0x2640 },
    { "ff",                   0xFB00 },
    { "ffi",                  0xFB03 },
    { "ffl",                  0xFB04 },
    { "fi",                   0xFB01 },
    { "figuredash",           0x2012 },
    { "filledbox",            0x25A0 },
    { "filledrect",           0x25AC },
    { "five",                 0x0035 },
    { "fiveeighths",          0x215D },
    { "fiveinferior",         0x2085 },
    { "fiveoldstyle",         0xF735 },
    { "fivesuperior",         0x2075 },
    { "fl",                   0xFB02 },
    { "florin",               0x0192 },
    { "four",                 0x0034 },
    { "fourinferior",         0x2084 },
    { "fouroldstyle",         0xF734 },
    { "foursuperior",         0x2074 },
    { "fraction",             0x2044 },
    { "fraction%",            0x2215 },
    { "franc",                0x20A3 },
    { "g",                    0x0067 },
    { "gamma",                0x03B3 },
    { "gbreve",               0x011F },
    { "gcaron",               0x01E7 },
    { "gcircumflex",          0x011D },
    { "gcommaaccent",         0x0123 },
    { "gdotaccent",           0x0121 },
    { "germandbls",           0x00DF },
    { "gradient",             0x2207 },
    { "grave",                0x0060 },
    { "gravecomb",            0x0300 },
    { "greater",              0x003E },
    { "greaterequal",         0x2265 },
    { "guillemotleft",        0x00AB },
    { "guillemotright",       0x00BB },
    { "guilsinglleft",        0x2039 },
    { "guilsinglright",       0x203A },
    { "h",                    0x0068 },
    { "hbar",                 0x0127 },
    { "hcircumflex",          0x0125 },
    { "heart",                0x2665 },
    { "hookabovecomb",        0x0309 },
    { "house",                0x2302 },
    { "hungarumlaut",         0x02DD },
    { "hyphen",               0x002D },
    { "hyphen%",              0x00AD },
    { "hypheninferior",       0xF6E5 },
    { "hyphensuperior",       0xF6E6 },
    { "i",                    0x0069 },
    { "iacute",               0x00ED },
    { "ibreve",               0x012D },
    { "icircumflex",          0x00EE },
    { "idieresis",            0x00EF },
    { "igrave",               0x00EC },
    { "ij",                   0x0133 },
    { "imacron",              0x012B },
    { "infinity",             0x221E },
    { "integral",             0x222B },
    { "integralbt",           0x2321 },
    { "integralex",           0x23AE },
    { "integraltp",           0x2320 },
    { "intersection",         0x2229 },
    { "invbullet",            0x25D8 },
    { "invcircle",            0x25D9 },
    { "invsmileface",         0x263B },
    { "iogonek",              0x012F },
    { "iota",                 0x03B9 },
    { "iotadieresis",         0x03CA },
    { "iotadieresistonos",    0x0390 },
    { "iotatonos",            0x03AF },
    { "isuperior",            0xF6ED },
    { "itilde",               0x0129 },
    { "j",                    0x006A },
    { "jcircumflex",          0x0135 },
    { "k",                    0x006B },
    { "kappa",                0x03BA },
    { "kcommaaccent",         0x0137 },
    { "kgreenlandic",         0x0138 },
    { "l",                    0x006C },
    { "lacute",               0x013A },
    { "lambda",               0x03BB },
    { "lcaron",               0x013E },
    { "lcommaaccent",         0x013C },
    { "ldot",                 0x0140 },
    { "less",                 0x003C },
    { "lessequal",            0x2264 },
    { "lfblock",              0x258C },
    { "lira",                 0x20A4 },
    { "ll",                   0xF6C0 },
    { "logicaland",           0x2227 },
    { "logicalnot",           0x00AC },
    { "logicalor",            0x2228 },
    { "longs",                0x017F },
    { "lozenge",              0x25CA },
    { "lslash",               0x0142 },
    { "lsuperior",            0xF6EE },
    { "ltshade",              0x2591 },
    { "m",                    0x006D },
    { "macron",               0x00AF },
    { "macron%",              0x02C9 },
    { "male",                 0x2642 },
    { "minus",                0x2212 },
    { "minute",               0x2032 },
    { "msuperior",            0xF6EF },
    { "mu",                   0x00B5 },
    { "mu%",                  0x03BC },
    { "multiply",             0x00D7 },
    { "musicalnote",          0x266A },
    { "musicalnotedbl",       0x266B },
    { "n",                    0x006E },
    { "nacute",               0x0144 },
    { "napostrophe",          0x0149 },
    { "ncaron",               0x0148 },
    { "ncommaaccent",         0x0146 },
    { "nine",                 0x0039 },
    { "nineinferior",         0x2089 },
    { "nineoldstyle",         0xF739 },
    { "ninesuperior",         0x2079 },
    { "notelement",           0x2209 },
    { "notequal",             0x2260 },
    { "notsubset",            0x2284 },
    { "nsuperior",            0x207F },
    { "ntilde",               0x00F1 },
    { "nu",                   0x03BD },
    { "numbersign",           0x0023 },
    { "o",                    0x006F },
    { "oacute",               0x00F3 },
    { "obreve",               0x014F },
    { "ocircumflex",          0x00F4 },
    { "odieresis",            0x00F6 },
    { "oe",                   0x0153 },
    { "ogonek",               0x02DB },
    { "ograve",               0x00F2 },
    { "ohorn",                0x01A1 },
    { "ohungarumlaut",        0x0151 },
    { "omacron",              0x014D },
    { "omega",                0x03C9 },
    { "omega1",               0x03D6 },
    { "omegatonos",           0x03CE },
    { "omicron",              0x03BF },
    { "omicrontonos",         0x03CC },
    { "one",                  0x0031 },
    { "onedotenleader",       0x2024 },
    { "oneeighth",            0x215B },
    { "onefitted",            0xF6DC },
    { "onehalf",              0x00BD },
    { "oneinferior",          0x2081 },
    { "oneoldstyle",          0xF731 },
    { "onequarter",           0x00BC },
    { "onesuperior",          0x00B9 },
    { "onethird",             0x2153 },
    { "openbullet",           0x25E6 },
    { "ordfeminine",          0x00AA },
    { "ordmasculine",         0x00BA },
    { "orthogonal",           0x221F },
    { "oslash",               0x00F8 },
    { "oslashacute",          0x01FF },
    { "osuperior",            0xF6F0 },
    { "otilde",               0x00F5 },
    { "p",                    0x0070 },
    { "paragraph",            0x00B6 },
    { "parenleft",            0x0028 },
    { "parenleftbt",          0x239D },
    { "parenleftex",          0x239C },
    { "parenleftinferior",    0x208D },
    { "parenleftsuperior",    0x207D },
    { "parenlefttp",          0x239B },
    { "parenright",           0x0029 },
    { "parenrightbt",         0x23A0 },
    { "parenrightex",         0x239F },
    { "parenrightinferior",   0x208E },
    { "parenrightsuperior",   0x207E },
    { "parenrighttp",         0x239E },
    { "partialdiff",          0x2202 },
    { "percent",              0x0025 },
    { "period",               0x002E },
    { "periodcentered",       0x00B7 },
    { "periodcentered%",      0x2219 },
    { "periodinferior",       0xF6E7 },
    { "periodsuperior",       0xF6E8 },
    { "perpendicular",        0x22A5 },
    { "perthousand",          0x2030 },
    { "peseta",               0x20A7 },
    { "phi",                  0x03C6 },
    { "phi1",                 0x03D5 },
    { "pi",                   0x03C0 },
    { "plus",                 0x002B },
    { "plusminus",            0x00B1 },
    { "prescription",         0x211E },
    { "product",              0x220F },
    { "propersubset",         0x2282 },
    { "propersuperset",       0x2283 },
    { "proportional",         0x221D },
    { "psi",                  0x03C8 },
    { "q",                    0x0071 },
    { "question",             0x003F },
    { "questiondown",         0x00BF },
    { "questiondownsmall",    0xF7BF },
    { "questionsmall",        0xF73F },
    { "quotedbl",             0x0022 },
    { "quotedblbase",         0x201E },
    { "quotedblleft",         0x201C },
    { "quotedblright",        0x201D },
    { "quoteleft",            0x2018 },
    { "quotereversed",        0x201B },
    { "quoteright",           0x2019 },
    { "quotesinglbase",       0x201A },
    { "quotesingle",          0x0027 },
    { "r",                    0x0072 },
    { "racute",               0x0155 },
    { "radical",              0x221A },
    { "radicalex",            0xF8E5 },
    { "rcaron",               0x0159 },
    { "rcommaaccent",         0x0157 },
    { "reflexsubset",         0x2286 },
    { "reflexsuperset",       0x2287 },
    { "registered",           0x00AE },
    { "registersans",         0xF8E8 },
    { "registerserif",        0xF6DA },
    { "revlogicalnot",        0x2310 },
    { "rho",                  0x03C1 },
    { "ring",                 0x02DA },
    { "rsuperior",            0xF6F1 },
    { "rtblock",              0x2590 },
    { "rupiah",               0xF6DD },
    { "s",                    0x0073 },
    { "sacute",               0x015B },
    { "scaron",               0x0161 },
    { "scedilla",             0x015F },
    { "scedilla%",            0xF6C2 },
    { "scircumflex",          0x015D },
    { "scommaaccent",         0x0219 },
    { "second",               0x2033 },
    { "section",              0x00A7 },
    { "semicolon",            0x003B },
    { "seven",                0x0037 },
    { "seveneighths",         0x215E },
    { "seveninferior",        0x2087 },
    { "sevenoldstyle",        0xF737 },
    { "sevensuperior",        0x2077 },
    { "shade",                0x2592 },
    { "sigma",                0x03C3 },
    { "sigma1",               0x03C2 },
    { "similar",              0x223C },
    { "six",                  0x0036 },
    { "sixinferior",          0x2086 },
    { "sixoldstyle",          0xF736 },
    { "sixsuperior",          0x2076 },
    { "slash",                0x002F },
    { "smileface",            0x263A },
    { "space",                0x0020 },
    { "space%",               0x00A0 },
    { "spade",                0x2660 },
    { "ssuperior",            0xF6F2 },
    { "sterling",             0x00A3 },
    { "suchthat",             0x220B },
    { "summation",            0x2211 },
    { "sun",                  0x263C },
    { "t",                    0x0074 },
    { "tau",                  0x03C4 },
    { "tbar",                 0x0167 },
    { "tcaron",               0x0165 },
    { "tcommaaccent",         0x0163 },
    { "tcommaaccent%",        0x021B },
    { "therefore",            0x2234 },
    { "theta",                0x03B8 },
    { "theta1",               0x03D1 },
    { "thorn",                0x00FE },
    { "three",                0x0033 },
    { "threeeighths",         0x215C },
    { "threeinferior",        0x2083 },
    { "threeoldstyle",        0xF733 },
    { "threequarters",        0x00BE },
    { "threequartersemdash",  0xF6DE },
    { "threesuperior",        0x00B3 },
    { "tilde",                0x02DC },
    { "tildecomb",            0x0303 },
    { "tonos",                0x0384 },
    { "trademark",            0x2122 },
    { "trademarksans",        0xF8EA },
    { "trademarkserif",       0xF6DB },
    { "triagdn",              0x25BC },
    { "triaglf",              0x25C4 },
    { "triagrt",              0x25BA },
    { "triagup",              0x25B2 },
    { "tsuperior",            0xF6F3 },
    { "two",                  0x0032 },
    { "twodotenleader",       0x2025 },
    { "twoinferior",          0x2082 },
    { "twooldstyle",          0xF732 },
    { "twosuperior",          0x00B2 },
    { "twothirds",            0x2154 },
    { "u",                    0x0075 },
    { "uacute",               0x00FA },
    { "ubreve",               0x016D },
    { "ucircumflex",          0x00FB },
    { "udieresis",            0x00FC },
    { "ugrave",               0x00F9 },
    { "uhorn",                0x01B0 },
    { "uhungarumlaut",        0x0171 },
    { "umacron",              0x016B },
    { "underscore",           0x005F },
    { "underscoredbl",        0x2017 },
    { "union",                0x222A },
    { "universal",            0x2200 },
    { "uogonek",              0x0173 },
    { "upblock",              0x2580 },
    { "upsilon",              0x03C5 },
    { "upsilondieresis",      0x03CB },
    { "upsilondieresistonos", 0x03B0 },
    { "upsilontonos",         0x03CD },
    { "uring",                0x016F },
    { "utilde",               0x0169 },
    { "v",                    0x0076 },
    { "w",                    0x0077 },
    { "wacute",               0x1E83 },
    { "wcircumflex",          0x0175 },
    { "wdieresis",            0x1E85 },
    { "weierstrass",          0x2118 },
    { "wgrave",               0x1E81 },
    { "x",                    0x0078 },
    { "xi",                   0x03BE },
    { "y",                    0x0079 },
    { "yacute",               0x00FD },
    { "ycircumflex",          0x0177 },
    { "ydieresis",            0x00FF },
    { "yen",                  0x00A5 },
    { "ygrave",               0x1EF3 },
    { "z",                    0x007A },
    { "zacute",               0x017A },
    { "zcaron",               0x017E },
    { "zdotaccent",           0x017C },
    { "zero",                 0x0030 },
    { "zeroinferior",         0x2080 },
    { "zerooldstyle",         0xF730 },
    { "zerosuperior",         0x2070 },
    { "zeta",                 0x03B6 },
