/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

// NOLINT(build/header_guard)

/* Mac OS Gujarati aggregate Unicode initializer.

   Element values are UVs. UV_UNDEF is 0xFFFF. Index by code, get UV.
   Source: ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/APPLE/GUJARATI.TXT
   as of 9/9/99. */

UV_UNDEF,   /* 00 */
UV_UNDEF,   /* 01 */
UV_UNDEF,   /* 02 */
UV_UNDEF,   /* 03 */
UV_UNDEF,   /* 04 */
UV_UNDEF,   /* 05 */
UV_UNDEF,   /* 06 */
UV_UNDEF,   /* 07 */
UV_UNDEF,   /* 08 */
UV_UNDEF,   /* 09 */
UV_UNDEF,   /* 0A */
UV_UNDEF,   /* 0B */
UV_UNDEF,   /* 0C */
UV_UNDEF,   /* 0D */
UV_UNDEF,   /* 0E */
UV_UNDEF,   /* 0F */
UV_UNDEF,   /* 10 */
UV_UNDEF,   /* 11 */
UV_UNDEF,   /* 12 */
UV_UNDEF,   /* 13 */
UV_UNDEF,   /* 14 */
UV_UNDEF,   /* 15 */
UV_UNDEF,   /* 16 */
UV_UNDEF,   /* 17 */
UV_UNDEF,   /* 18 */
UV_UNDEF,   /* 19 */
UV_UNDEF,   /* 1A */
UV_UNDEF,   /* 1B */
UV_UNDEF,   /* 1C */
UV_UNDEF,   /* 1D */
UV_UNDEF,   /* 1E */
UV_UNDEF,   /* 1F */
0x0020,     /* 20  SPACE */
0x0021,     /* 21  EXCLAMATION MARK */
0x0022,     /* 22  QUOTATION MARK */
0x0023,     /* 23  NUMBER SIGN */
0x0024,     /* 24  DOLLAR SIGN */
0x0025,     /* 25  PERCENT SIGN */
0x0026,     /* 26  AMPERSAND */
0x0027,     /* 27  APOSTROPHE */
0x0028,     /* 28  LEFT PARENTHESIS */
0x0029,     /* 29  RIGHT PARENTHESIS */
0x002A,     /* 2A  ASTERISK */
0x002B,     /* 2B  PLUS SIGN */
0x002C,     /* 2C  COMMA */
0x002D,     /* 2D  HYPHEN-MINUS */
0x002E,     /* 2E  FULL STOP */
0x002F,     /* 2F  SOLIDUS */
0x0030,     /* 30  DIGIT ZERO */
0x0031,     /* 31  DIGIT ONE */
0x0032,     /* 32  DIGIT TWO */
0x0033,     /* 33  DIGIT THREE */
0x0034,     /* 34  DIGIT FOUR */
0x0035,     /* 35  DIGIT FIVE */
0x0036,     /* 36  DIGIT SIX */
0x0037,     /* 37  DIGIT SEVEN */
0x0038,     /* 38  DIGIT EIGHT */
0x0039,     /* 39  DIGIT NINE */
0x003A,     /* 3A  COLON */
0x003B,     /* 3B  SEMICOLON */
0x003C,     /* 3C  LESS-THAN SIGN */
0x003D,     /* 3D  EQUALS SIGN */
0x003E,     /* 3E  GREATER-THAN SIGN */
0x003F,     /* 3F  QUESTION MARK */
0x0040,     /* 40  COMMERCIAL AT */
0x0041,     /* 41  LATIN CAPITAL LETTER A */
0x0042,     /* 42  LATIN CAPITAL LETTER B */
0x0043,     /* 43  LATIN CAPITAL LETTER C */
0x0044,     /* 44  LATIN CAPITAL LETTER D */
0x0045,     /* 45  LATIN CAPITAL LETTER E */
0x0046,     /* 46  LATIN CAPITAL LETTER F */
0x0047,     /* 47  LATIN CAPITAL LETTER G */
0x0048,     /* 48  LATIN CAPITAL LETTER H */
0x0049,     /* 49  LATIN CAPITAL LETTER I */
0x004A,     /* 4A  LATIN CAPITAL LETTER J */
0x004B,     /* 4B  LATIN CAPITAL LETTER K */
0x004C,     /* 4C  LATIN CAPITAL LETTER L */
0x004D,     /* 4D  LATIN CAPITAL LETTER M */
0x004E,     /* 4E  LATIN CAPITAL LETTER N */
0x004F,     /* 4F  LATIN CAPITAL LETTER O */
0x0050,     /* 50  LATIN CAPITAL LETTER P */
0x0051,     /* 51  LATIN CAPITAL LETTER Q */
0x0052,     /* 52  LATIN CAPITAL LETTER R */
0x0053,     /* 53  LATIN CAPITAL LETTER S */
0x0054,     /* 54  LATIN CAPITAL LETTER T */
0x0055,     /* 55  LATIN CAPITAL LETTER U */
0x0056,     /* 56  LATIN CAPITAL LETTER V */
0x0057,     /* 57  LATIN CAPITAL LETTER W */
0x0058,     /* 58  LATIN CAPITAL LETTER X */
0x0059,     /* 59  LATIN CAPITAL LETTER Y */
0x005A,     /* 5A  LATIN CAPITAL LETTER Z */
0x005B,     /* 5B  LEFT SQUARE BRACKET */
0x005C,     /* 5C  REVERSE SOLIDUS */
0x005D,     /* 5D  RIGHT SQUARE BRACKET */
0x005E,     /* 5E  CIRCUMFLEX ACCENT */
0x005F,     /* 5F  LOW LINE */
0x0060,     /* 60  GRAVE ACCENT */
0x0061,     /* 61  LATIN SMALL LETTER A */
0x0062,     /* 62  LATIN SMALL LETTER B */
0x0063,     /* 63  LATIN SMALL LETTER C */
0x0064,     /* 64  LATIN SMALL LETTER D */
0x0065,     /* 65  LATIN SMALL LETTER E */
0x0066,     /* 66  LATIN SMALL LETTER F */
0x0067,     /* 67  LATIN SMALL LETTER G */
0x0068,     /* 68  LATIN SMALL LETTER H */
0x0069,     /* 69  LATIN SMALL LETTER I */
0x006A,     /* 6A  LATIN SMALL LETTER J */
0x006B,     /* 6B  LATIN SMALL LETTER K */
0x006C,     /* 6C  LATIN SMALL LETTER L */
0x006D,     /* 6D  LATIN SMALL LETTER M */
0x006E,     /* 6E  LATIN SMALL LETTER N */
0x006F,     /* 6F  LATIN SMALL LETTER O */
0x0070,     /* 70  LATIN SMALL LETTER P */
0x0071,     /* 71  LATIN SMALL LETTER Q */
0x0072,     /* 72  LATIN SMALL LETTER R */
0x0073,     /* 73  LATIN SMALL LETTER S */
0x0074,     /* 74  LATIN SMALL LETTER T */
0x0075,     /* 75  LATIN SMALL LETTER U */
0x0076,     /* 76  LATIN SMALL LETTER V */
0x0077,     /* 77  LATIN SMALL LETTER W */
0x0078,     /* 78  LATIN SMALL LETTER X */
0x0079,     /* 79  LATIN SMALL LETTER Y */
0x007A,     /* 7A  LATIN SMALL LETTER Z */
0x007B,     /* 7B  LEFT CURLY BRACKET */
0x007C,     /* 7C  VERTICAL LINE */
0x007D,     /* 7D  RIGHT CURLY BRACKET */
0x007E,     /* 7E  TILDE */
UV_UNDEF,   /* 7F */
0x00D7,     /* 80  MULTIPLICATION SIGN */
0x2212,     /* 81  MINUS SIGN */
0x2013,     /* 82  EN DASH */
0x2014,     /* 83  EM DASH */
0x2018,     /* 84  LEFT SINGLE QUOTATION MARK */
0x2019,     /* 85  RIGHT SINGLE QUOTATION MARK */
0x2026,     /* 86  HORIZONTAL ELLIPSIS */
0x2022,     /* 87  BULLET */
0x00A9,     /* 88  COPYRIGHT SIGN */
0x00AE,     /* 89  REGISTERED SIGN */
0x2122,     /* 8A  TRADE MARK SIGN */
UV_UNDEF,   /* 8B */
UV_UNDEF,   /* 8C */
UV_UNDEF,   /* 8D */
UV_UNDEF,   /* 8E */
UV_UNDEF,   /* 8F */
0x0965,     /* 90  DEVANAGARI DOUBLE DANDA */
UV_UNDEF,   /* 91 */
UV_UNDEF,   /* 92 */
UV_UNDEF,   /* 93 */
UV_UNDEF,   /* 94 */
UV_UNDEF,   /* 95 */
UV_UNDEF,   /* 96 */
UV_UNDEF,   /* 97 */
UV_UNDEF,   /* 98 */
UV_UNDEF,   /* 99 */
UV_UNDEF,   /* 9A */
UV_UNDEF,   /* 9B */
UV_UNDEF,   /* 9C */
UV_UNDEF,   /* 9D */
UV_UNDEF,   /* 9E */
UV_UNDEF,   /* 9F */
UV_UNDEF,   /* A0 */
0x0A81,     /* A1  GUJARATI SIGN CANDRABINDU */
0x0A82,     /* A2  GUJARATI SIGN ANUSVARA */
0x0A83,     /* A3  GUJARATI SIGN VISARGA */
0x0A85,     /* A4  GUJARATI LETTER A */
0x0A86,     /* A5  GUJARATI LETTER AA */
0x0A87,     /* A6  GUJARATI LETTER I */
0x0A88,     /* A7  GUJARATI LETTER II */
0x0A89,     /* A8  GUJARATI LETTER U */
0x0A8A,     /* A9  GUJARATI LETTER UU */
0x0A8B,     /* AA  GUJARATI LETTER VOCALIC R */
UV_UNDEF,   /* AB */
0x0A8F,     /* AC  GUJARATI LETTER E */
0x0A90,     /* AD  GUJARATI LETTER AI */
0x0A8D,     /* AE  GUJARATI VOWEL CANDRA E */
UV_UNDEF,   /* AF */
0x0A93,     /* B0  GUJARATI LETTER O */
0x0A94,     /* B1  GUJARATI LETTER AU */
0x0A91,     /* B2  GUJARATI VOWEL CANDRA O */
0x0A95,     /* B3  GUJARATI LETTER KA */
0x0A96,     /* B4  GUJARATI LETTER KHA */
0x0A97,     /* B5  GUJARATI LETTER GA */
0x0A98,     /* B6  GUJARATI LETTER GHA */
0x0A99,     /* B7  GUJARATI LETTER NGA */
0x0A9A,     /* B8  GUJARATI LETTER CA */
0x0A9B,     /* B9  GUJARATI LETTER CHA */
0x0A9C,     /* BA  GUJARATI LETTER JA */
0x0A9D,     /* BB  GUJARATI LETTER JHA */
0x0A9E,     /* BC  GUJARATI LETTER NYA */
0x0A9F,     /* BD  GUJARATI LETTER TTA */
0x0AA0,     /* BE  GUJARATI LETTER TTHA */
0x0AA1,     /* BF  GUJARATI LETTER DDA */
0x0AA2,     /* C0  GUJARATI LETTER DDHA */
0x0AA3,     /* C1  GUJARATI LETTER NNA */
0x0AA4,     /* C2  GUJARATI LETTER TA */
0x0AA5,     /* C3  GUJARATI LETTER THA */
0x0AA6,     /* C4  GUJARATI LETTER DA */
0x0AA7,     /* C5  GUJARATI LETTER DHA */
0x0AA8,     /* C6  GUJARATI LETTER NA */
UV_UNDEF,   /* C7 */
0x0AAA,     /* C8  GUJARATI LETTER PA */
0x0AAB,     /* C9  GUJARATI LETTER PHA */
0x0AAC,     /* CA  GUJARATI LETTER BA */
0x0AAD,     /* CB  GUJARATI LETTER BHA */
0x0AAE,     /* CC  GUJARATI LETTER MA */
0x0AAF,     /* CD  GUJARATI LETTER YA */
UV_UNDEF,   /* CE */
0x0AB0,     /* CF  GUJARATI LETTER RA */
UV_UNDEF,   /* D0 */
0x0AB2,     /* D1  GUJARATI LETTER LA */
0x0AB3,     /* D2  GUJARATI LETTER LLA */
UV_UNDEF,   /* D3 */
0x0AB5,     /* D4  GUJARATI LETTER VA */
0x0AB6,     /* D5  GUJARATI LETTER SHA */
0x0AB7,     /* D6  GUJARATI LETTER SSA */
0x0AB8,     /* D7  GUJARATI LETTER SA */
0x0AB9,     /* D8  GUJARATI LETTER HA */
0x200E,     /* D9  LEFT-TO-RIGHT MARK (invisible consonant) */
0x0ABE,     /* DA  GUJARATI VOWEL SIGN AA */
0x0ABF,     /* DB  GUJARATI VOWEL SIGN I */
0x0AC0,     /* DC  GUJARATI VOWEL SIGN II */
0x0AC1,     /* DD  GUJARATI VOWEL SIGN U */
0x0AC2,     /* DE  GUJARATI VOWEL SIGN UU */
0x0AC3,     /* DF  GUJARATI VOWEL SIGN VOCALIC R */
UV_UNDEF,   /* E0 */
0x0AC7,     /* E1  GUJARATI VOWEL SIGN E */
0x0AC8,     /* E2  GUJARATI VOWEL SIGN AI */
0x0AC5,     /* E3  GUJARATI VOWEL SIGN CANDRA E */
UV_UNDEF,   /* E4 */
0x0ACB,     /* E5  GUJARATI VOWEL SIGN O */
0x0ACC,     /* E6  GUJARATI VOWEL SIGN AU */
0x0AC9,     /* E7  GUJARATI VOWEL SIGN CANDRA O */
0x0ACD,     /* E8  GUJARATI SIGN VIRAMA (halant) */
0x0ABC,     /* E9  GUJARATI SIGN NUKTA */
0x0964,     /* EA  DEVANAGARI DANDA */
UV_UNDEF,   /* EB */
UV_UNDEF,   /* EC */
UV_UNDEF,   /* ED */
UV_UNDEF,   /* EE */
UV_UNDEF,   /* EF */
UV_UNDEF,   /* F0 */
0x0AE6,     /* F1  GUJARATI DIGIT ZERO */
0x0AE7,     /* F2  GUJARATI DIGIT ONE */
0x0AE8,     /* F3  GUJARATI DIGIT TWO */
0x0AE9,     /* F4  GUJARATI DIGIT THREE */
0x0AEA,     /* F5  GUJARATI DIGIT FOUR */
0x0AEB,     /* F6  GUJARATI DIGIT FIVE */
0x0AEC,     /* F7  GUJARATI DIGIT SIX */
0x0AED,     /* F8  GUJARATI DIGIT SEVEN */
0x0AEE,     /* F9  GUJARATI DIGIT EIGHT */
0x0AEF,     /* FA  GUJARATI DIGIT NINE */
UV_UNDEF,   /* FB */
UV_UNDEF,   /* FC */
UV_UNDEF,   /* FD */
UV_UNDEF,   /* FE */
UV_UNDEF,   /* FF */
