/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

// NOLINT(build/header_guard)

/* Mac OS Gurmukhi aggregate Unicode initializer.

   Element values are UVs. UV_UNDEF is 0xFFFF. Index by code, get UV.
   Source: ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/APPLE/GURMUKHI.TXT
   as of 9/9/99.

   1 entry is mapped to regular Unicode values for which Apple has defined
   a transcoding hint sequence. The full transcoding hint sequence is shown in
   parentheses for such mappings. */

UV_UNDEF,   /* 00 */
UV_UNDEF,   /* 01 */
UV_UNDEF,   /* 02 */
UV_UNDEF,   /* 03 */
UV_UNDEF,   /* 04 */
UV_UNDEF,   /* 05 */
UV_UNDEF,   /* 06 */
UV_UNDEF,   /* 07 */
UV_UNDEF,   /* 08 */
UV_UNDEF,   /* 09 */
UV_UNDEF,   /* 0A */
UV_UNDEF,   /* 0B */
UV_UNDEF,   /* 0C */
UV_UNDEF,   /* 0D */
UV_UNDEF,   /* 0E */
UV_UNDEF,   /* 0F */
UV_UNDEF,   /* 10 */
UV_UNDEF,   /* 11 */
UV_UNDEF,   /* 12 */
UV_UNDEF,   /* 13 */
UV_UNDEF,   /* 14 */
UV_UNDEF,   /* 15 */
UV_UNDEF,   /* 16 */
UV_UNDEF,   /* 17 */
UV_UNDEF,   /* 18 */
UV_UNDEF,   /* 19 */
UV_UNDEF,   /* 1A */
UV_UNDEF,   /* 1B */
UV_UNDEF,   /* 1C */
UV_UNDEF,   /* 1D */
UV_UNDEF,   /* 1E */
UV_UNDEF,   /* 1F */
0x0020,     /* 20  SPACE */
0x0021,     /* 21  EXCLAMATION MARK */
0x0022,     /* 22  QUOTATION MARK */
0x0023,     /* 23  NUMBER SIGN */
0x0024,     /* 24  DOLLAR SIGN */
0x0025,     /* 25  PERCENT SIGN */
0x0026,     /* 26  AMPERSAND */
0x0027,     /* 27  APOSTROPHE */
0x0028,     /* 28  LEFT PARENTHESIS */
0x0029,     /* 29  RIGHT PARENTHESIS */
0x002A,     /* 2A  ASTERISK */
0x002B,     /* 2B  PLUS SIGN */
0x002C,     /* 2C  COMMA */
0x002D,     /* 2D  HYPHEN-MINUS */
0x002E,     /* 2E  FULL STOP */
0x002F,     /* 2F  SOLIDUS */
0x0030,     /* 30  DIGIT ZERO */
0x0031,     /* 31  DIGIT ONE */
0x0032,     /* 32  DIGIT TWO */
0x0033,     /* 33  DIGIT THREE */
0x0034,     /* 34  DIGIT FOUR */
0x0035,     /* 35  DIGIT FIVE */
0x0036,     /* 36  DIGIT SIX */
0x0037,     /* 37  DIGIT SEVEN */
0x0038,     /* 38  DIGIT EIGHT */
0x0039,     /* 39  DIGIT NINE */
0x003A,     /* 3A  COLON */
0x003B,     /* 3B  SEMICOLON */
0x003C,     /* 3C  LESS-THAN SIGN */
0x003D,     /* 3D  EQUALS SIGN */
0x003E,     /* 3E  GREATER-THAN SIGN */
0x003F,     /* 3F  QUESTION MARK */
0x0040,     /* 40  COMMERCIAL AT */
0x0041,     /* 41  LATIN CAPITAL LETTER A */
0x0042,     /* 42  LATIN CAPITAL LETTER B */
0x0043,     /* 43  LATIN CAPITAL LETTER C */
0x0044,     /* 44  LATIN CAPITAL LETTER D */
0x0045,     /* 45  LATIN CAPITAL LETTER E */
0x0046,     /* 46  LATIN CAPITAL LETTER F */
0x0047,     /* 47  LATIN CAPITAL LETTER G */
0x0048,     /* 48  LATIN CAPITAL LETTER H */
0x0049,     /* 49  LATIN CAPITAL LETTER I */
0x004A,     /* 4A  LATIN CAPITAL LETTER J */
0x004B,     /* 4B  LATIN CAPITAL LETTER K */
0x004C,     /* 4C  LATIN CAPITAL LETTER L */
0x004D,     /* 4D  LATIN CAPITAL LETTER M */
0x004E,     /* 4E  LATIN CAPITAL LETTER N */
0x004F,     /* 4F  LATIN CAPITAL LETTER O */
0x0050,     /* 50  LATIN CAPITAL LETTER P */
0x0051,     /* 51  LATIN CAPITAL LETTER Q */
0x0052,     /* 52  LATIN CAPITAL LETTER R */
0x0053,     /* 53  LATIN CAPITAL LETTER S */
0x0054,     /* 54  LATIN CAPITAL LETTER T */
0x0055,     /* 55  LATIN CAPITAL LETTER U */
0x0056,     /* 56  LATIN CAPITAL LETTER V */
0x0057,     /* 57  LATIN CAPITAL LETTER W */
0x0058,     /* 58  LATIN CAPITAL LETTER X */
0x0059,     /* 59  LATIN CAPITAL LETTER Y */
0x005A,     /* 5A  LATIN CAPITAL LETTER Z */
0x005B,     /* 5B  LEFT SQUARE BRACKET */
0x005C,     /* 5C  REVERSE SOLIDUS */
0x005D,     /* 5D  RIGHT SQUARE BRACKET */
0x005E,     /* 5E  CIRCUMFLEX ACCENT */
0x005F,     /* 5F  LOW LINE */
0x0060,     /* 60  GRAVE ACCENT */
0x0061,     /* 61  LATIN SMALL LETTER A */
0x0062,     /* 62  LATIN SMALL LETTER B */
0x0063,     /* 63  LATIN SMALL LETTER C */
0x0064,     /* 64  LATIN SMALL LETTER D */
0x0065,     /* 65  LATIN SMALL LETTER E */
0x0066,     /* 66  LATIN SMALL LETTER F */
0x0067,     /* 67  LATIN SMALL LETTER G */
0x0068,     /* 68  LATIN SMALL LETTER H */
0x0069,     /* 69  LATIN SMALL LETTER I */
0x006A,     /* 6A  LATIN SMALL LETTER J */
0x006B,     /* 6B  LATIN SMALL LETTER K */
0x006C,     /* 6C  LATIN SMALL LETTER L */
0x006D,     /* 6D  LATIN SMALL LETTER M */
0x006E,     /* 6E  LATIN SMALL LETTER N */
0x006F,     /* 6F  LATIN SMALL LETTER O */
0x0070,     /* 70  LATIN SMALL LETTER P */
0x0071,     /* 71  LATIN SMALL LETTER Q */
0x0072,     /* 72  LATIN SMALL LETTER R */
0x0073,     /* 73  LATIN SMALL LETTER S */
0x0074,     /* 74  LATIN SMALL LETTER T */
0x0075,     /* 75  LATIN SMALL LETTER U */
0x0076,     /* 76  LATIN SMALL LETTER V */
0x0077,     /* 77  LATIN SMALL LETTER W */
0x0078,     /* 78  LATIN SMALL LETTER X */
0x0079,     /* 79  LATIN SMALL LETTER Y */
0x007A,     /* 7A  LATIN SMALL LETTER Z */
0x007B,     /* 7B  LEFT CURLY BRACKET */
0x007C,     /* 7C  VERTICAL LINE */
0x007D,     /* 7D  RIGHT CURLY BRACKET */
0x007E,     /* 7E  TILDE */
UV_UNDEF,   /* 7F */
0x00D7,     /* 80  MULTIPLICATION SIGN */
0x2212,     /* 81  MINUS SIGN */
0x2013,     /* 82  EN DASH */
0x2014,     /* 83  EM DASH */
0x2018,     /* 84  LEFT SINGLE QUOTATION MARK */
0x2019,     /* 85  RIGHT SINGLE QUOTATION MARK */
0x2026,     /* 86  HORIZONTAL ELLIPSIS */
0x2022,     /* 87  BULLET */
0x00A9,     /* 88  COPYRIGHT SIGN */
0x00AE,     /* 89  REGISTERED SIGN */
0x2122,     /* 8A  TRADE MARK SIGN */
UV_UNDEF,   /* 8B */
UV_UNDEF,   /* 8C */
UV_UNDEF,   /* 8D */
UV_UNDEF,   /* 8E */
UV_UNDEF,   /* 8F */
0x0A71,     /* 90  GURMUKHI ADDAK */
0x0A5C,     /* 91  GURMUKHI LETTER RRA, alternate (0xF860+0x0A21+0x0A3C) */
0x0A73,     /* 92  GURMUKHI URA */
0x0A72,     /* 93  GURMUKHI IRI */
0x0A74,     /* 94  GURMUKHI EK ONKAR */
UV_UNDEF,   /* 95 */
UV_UNDEF,   /* 96 */
UV_UNDEF,   /* 97 */
UV_UNDEF,   /* 98 */
UV_UNDEF,   /* 99 */
UV_UNDEF,   /* 9A */
UV_UNDEF,   /* 9B */
UV_UNDEF,   /* 9C */
UV_UNDEF,   /* 9D */
UV_UNDEF,   /* 9E */
UV_UNDEF,   /* 9F */
UV_UNDEF,   /* A0 */
UV_UNDEF,   /* A1 */
0x0A02,     /* A2  GURMUKHI SIGN BINDI */
UV_UNDEF,   /* A3 */
0x0A05,     /* A4  GURMUKHI LETTER A */
0x0A06,     /* A5  GURMUKHI LETTER AA */
0x0A07,     /* A6  GURMUKHI LETTER I */
0x0A08,     /* A7  GURMUKHI LETTER II */
0x0A09,     /* A8  GURMUKHI LETTER U */
0x0A0A,     /* A9  GURMUKHI LETTER UU */
UV_UNDEF,   /* AA */
UV_UNDEF,   /* AB */
0x0A0F,     /* AC  GURMUKHI LETTER EE */
0x0A10,     /* AD  GURMUKHI LETTER AI */
UV_UNDEF,   /* AE */
UV_UNDEF,   /* AF */
0x0A13,     /* B0  GURMUKHI LETTER OO */
0x0A14,     /* B1  GURMUKHI LETTER AU */
UV_UNDEF,   /* B2 */
0x0A15,     /* B3  GURMUKHI LETTER KA */
0x0A16,     /* B4  GURMUKHI LETTER KHA */
0x0A17,     /* B5  GURMUKHI LETTER GA */
0x0A18,     /* B6  GURMUKHI LETTER GHA */
0x0A19,     /* B7  GURMUKHI LETTER NGA */
0x0A1A,     /* B8  GURMUKHI LETTER CA */
0x0A1B,     /* B9  GURMUKHI LETTER CHA */
0x0A1C,     /* BA  GURMUKHI LETTER JA */
0x0A1D,     /* BB  GURMUKHI LETTER JHA */
0x0A1E,     /* BC  GURMUKHI LETTER NYA */
0x0A1F,     /* BD  GURMUKHI LETTER TTA */
0x0A20,     /* BE  GURMUKHI LETTER TTHA */
0x0A21,     /* BF  GURMUKHI LETTER DDA */
0x0A22,     /* C0  GURMUKHI LETTER DDHA */
0x0A23,     /* C1  GURMUKHI LETTER NNA */
0x0A24,     /* C2  GURMUKHI LETTER TA */
0x0A25,     /* C3  GURMUKHI LETTER THA */
0x0A26,     /* C4  GURMUKHI LETTER DA */
0x0A27,     /* C5  GURMUKHI LETTER DHA */
0x0A28,     /* C6  GURMUKHI LETTER NA */
UV_UNDEF,   /* C7 */
0x0A2A,     /* C8  GURMUKHI LETTER PA */
0x0A2B,     /* C9  GURMUKHI LETTER PHA */
0x0A2C,     /* CA  GURMUKHI LETTER BA */
0x0A2D,     /* CB  GURMUKHI LETTER BHA */
0x0A2E,     /* CC  GURMUKHI LETTER MA */
0x0A2F,     /* CD  GURMUKHI LETTER YA */
UV_UNDEF,   /* CE */
0x0A30,     /* CF  GURMUKHI LETTER RA */
UV_UNDEF,   /* D0 */
0x0A32,     /* D1  GURMUKHI LETTER LA */
UV_UNDEF,   /* D2 */
UV_UNDEF,   /* D3 */
0x0A35,     /* D4  GURMUKHI LETTER VA */
0x0A36,     /* D5  GURMUKHI LETTER SHA */
UV_UNDEF,   /* D6 */
0x0A38,     /* D7  GURMUKHI LETTER SA */
0x0A39,     /* D8  GURMUKHI LETTER HA */
0x200E,     /* D9  LEFT-TO-RIGHT MARK (invisible consonant) */
0x0A3E,     /* DA  GURMUKHI VOWEL SIGN AA */
0x0A3F,     /* DB  GURMUKHI VOWEL SIGN I */
0x0A40,     /* DC  GURMUKHI VOWEL SIGN II */
0x0A41,     /* DD  GURMUKHI VOWEL SIGN U */
0x0A42,     /* DE  GURMUKHI VOWEL SIGN UU */
UV_UNDEF,   /* DF */
UV_UNDEF,   /* E0 */
0x0A47,     /* E1  GURMUKHI VOWEL SIGN EE */
0x0A48,     /* E2  GURMUKHI VOWEL SIGN AI */
UV_UNDEF,   /* E3 */
UV_UNDEF,   /* E4 */
0x0A4B,     /* E5  GURMUKHI VOWEL SIGN OO */
0x0A4C,     /* E6  GURMUKHI VOWEL SIGN AU */
UV_UNDEF,   /* E7 */
0x0A4D,     /* E8  GURMUKHI SIGN VIRAMA (halant) */
0x0A3C,     /* E9  GURMUKHI SIGN NUKTA */
0x0964,     /* EA  DEVANAGARI DANDA */
UV_UNDEF,   /* EB */
UV_UNDEF,   /* EC */
UV_UNDEF,   /* ED */
UV_UNDEF,   /* EE */
UV_UNDEF,   /* EF */
UV_UNDEF,   /* F0 */
0x0A66,     /* F1  GURMUKHI DIGIT ZERO */
0x0A67,     /* F2  GURMUKHI DIGIT ONE */
0x0A68,     /* F3  GURMUKHI DIGIT TWO */
0x0A69,     /* F4  GURMUKHI DIGIT THREE */
0x0A6A,     /* F5  GURMUKHI DIGIT FOUR */
0x0A6B,     /* F6  GURMUKHI DIGIT FIVE */
0x0A6C,     /* F7  GURMUKHI DIGIT SIX */
0x0A6D,     /* F8  GURMUKHI DIGIT SEVEN */
0x0A6E,     /* F9  GURMUKHI DIGIT EIGHT */
0x0A6F,     /* FA  GURMUKHI DIGIT NINE */
UV_UNDEF,   /* FB */
UV_UNDEF,   /* FC */
UV_UNDEF,   /* FD */
UV_UNDEF,   /* FE */
UV_UNDEF,   /* FF */
