/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

/*
 * Alternate metrics table format definition.
 */

#ifndef FORMAT_ALMX_H
#define FORMAT_ALMX_H

#define ALMX_VERSION VERSION(1, 0)

typedef struct
{
    uint16_t glyphIdDelta;
    FWord *hAdv;   /* [nMasters] */
    FWord *hOrigX; /* [nMasters] */
    FWord *vAdv;   /* [nMasters] */
    FWord *vOrigY; /* [nMasters] */
} ALMXMetrics;
#define ALMX_METR_SIZE(nMasters) (SIZEOF(ALMXMetrics, glyphIdDelta) + \
                                  (SIZEOF(ALMXMetrics, hAdv[0]) +     \
                                   SIZEOF(ALMXMetrics, hOrigX[0]) +   \
                                   SIZEOF(ALMXMetrics, vAdv[0]) +     \
                                   SIZEOF(ALMXMetrics, vOrigY[0])) *  \
                                      nMasters)
typedef struct
{
    Fixed version;
    uint16_t flags;
    uint16_t nMasters;
    GlyphId firstGlyph;
    GlyphId lastGlyph;
    Lookup lookup;
} ALMXTbl;

#endif /* FORMAT_ALMX_H */
