/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

/*
 * Bounding box table format definition.
 */

#ifndef FORMAT_BBOX_H
#define FORMAT_BBOX_H

#define BBOX_VERSION VERSION(1, 0)

typedef struct
{
    FWord *left;   /* [nMasters] */
    FWord *bottom; /* [nMasters] */
    FWord *right;  /* [nMasters] */
    FWord *top;    /* [nMasters] */
} BBox;

typedef struct
{
    Fixed version;
    uint16_t flags;
    uint16_t nGlyphs;
    uint16_t nMasters;
    BBox *bbox; /* [nGlyphs] */
} BBOXTbl;

#endif /* FORMAT_BBOX_H */
