/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

/*
 * Rotation table format definition.
 */

#ifndef FORMAT_ROTA_H
#define FORMAT_ROTA_H

#define ROTA_VERSION VERSION(1, 0)

typedef struct
{
    uint16_t glyphIdDelta;
    FWord *hBslnShift; /* [nMasters] */
    FWord *vBslnShift; /* [nMasters] */
} ROTAMetrics;
#define ROTA_METR_SIZE(nMasters)            \
    (SIZEOF(ROTAMetrics, glyphIdDelta) +    \
     (SIZEOF(ROTAMetrics, hBslnShift[0]) +  \
      SIZEOF(ROTAMetrics, vBslnShift[0])) * \
         nMasters)

typedef struct
{
    Fixed version;
    uint16_t flags;
    uint16_t nMasters;
    GlyphId firstGlyph;
    GlyphId lastGlyph;
    Lookup lookup;
} ROTATbl;

#endif /* FORMAT_ROTA_H */
