# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from asana.api_client import ApiClient


class GoalRelationshipsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_supporting_relationship(self, body, goal_gid, **kwargs):  # noqa: E501
        """Add a supporting goal relationship  # noqa: E501

        Creates a goal relationship by adding a supporting resource to a given goal.  Returns the newly created goal relationship record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_supporting_relationship(body, goal_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalGidAddSupportingRelationshipBody body: The supporting resource to be added to the goal (required)
        :param str goal_gid: Globally unique identifier for the goal. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.add_supporting_relationship_with_http_info(body, goal_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_supporting_relationship_with_http_info(body, goal_gid, **kwargs)  # noqa: E501
            return data

    def add_supporting_relationship_with_http_info(self, body, goal_gid, **kwargs):  # noqa: E501
        """Add a supporting goal relationship  # noqa: E501

        Creates a goal relationship by adding a supporting resource to a given goal.  Returns the newly created goal relationship record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_supporting_relationship_with_http_info(body, goal_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalGidAddSupportingRelationshipBody body: The supporting resource to be added to the goal (required)
        :param str goal_gid: Globally unique identifier for the goal. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'goal_gid', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_supporting_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_supporting_relationship`")  # noqa: E501
        # verify the required parameter 'goal_gid' is set
        if ('goal_gid' not in params or
                params['goal_gid'] is None):
            raise ValueError("Missing the required parameter `goal_gid` when calling `add_supporting_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_gid' in params:
            path_params['goal_gid'] = params['goal_gid']  # noqa: E501

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goals/{goal_gid}/addSupportingRelationship', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoalRelationshipResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_relationship(self, goal_relationship_gid, **kwargs):  # noqa: E501
        """Get a goal relationship  # noqa: E501

        Returns the complete updated goal relationship record for a single goal relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_relationship(goal_relationship_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_relationship_gid: Globally unique identifier for the goal relationship. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.get_goal_relationship_with_http_info(goal_relationship_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_relationship_with_http_info(goal_relationship_gid, **kwargs)  # noqa: E501
            return data

    def get_goal_relationship_with_http_info(self, goal_relationship_gid, **kwargs):  # noqa: E501
        """Get a goal relationship  # noqa: E501

        Returns the complete updated goal relationship record for a single goal relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_relationship_with_http_info(goal_relationship_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_relationship_gid: Globally unique identifier for the goal relationship. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_relationship_gid', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_relationship_gid' is set
        if ('goal_relationship_gid' not in params or
                params['goal_relationship_gid'] is None):
            raise ValueError("Missing the required parameter `goal_relationship_gid` when calling `get_goal_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_relationship_gid' in params:
            path_params['goal_relationship_gid'] = params['goal_relationship_gid']  # noqa: E501

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_relationships/{goal_relationship_gid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoalRelationshipResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_relationships(self, supported_goal, **kwargs):  # noqa: E501
        """Get goal relationships  # noqa: E501

        Returns compact goal relationship records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_relationships(supported_goal, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str supported_goal: Globally unique identifier for the supported goal in the goal relationship. (required)
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param str resource_subtype: If provided, filter to goal relationships with a given resource_subtype.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.get_goal_relationships_with_http_info(supported_goal, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_relationships_with_http_info(supported_goal, **kwargs)  # noqa: E501
            return data

    def get_goal_relationships_with_http_info(self, supported_goal, **kwargs):  # noqa: E501
        """Get goal relationships  # noqa: E501

        Returns compact goal relationship records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_relationships_with_http_info(supported_goal, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str supported_goal: Globally unique identifier for the supported goal in the goal relationship. (required)
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param str resource_subtype: If provided, filter to goal relationships with a given resource_subtype.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['supported_goal', 'limit', 'offset', 'resource_subtype', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_relationships" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'supported_goal' is set
        if ('supported_goal' not in params or
                params['supported_goal'] is None):
            raise ValueError("Missing the required parameter `supported_goal` when calling `get_goal_relationships`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'supported_goal' in params:
            query_params.append(('supported_goal', params['supported_goal']))  # noqa: E501
        if 'resource_subtype' in params:
            query_params.append(('resource_subtype', params['resource_subtype']))  # noqa: E501
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_relationships', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoalRelationshipResponseArray',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_supporting_relationship(self, body, goal_gid, **kwargs):  # noqa: E501
        """Removes a supporting goal relationship  # noqa: E501

        Removes a goal relationship for a given parent goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_supporting_relationship(body, goal_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalGidRemoveSupportingRelationshipBody body: The supporting resource to be removed from the goal (required)
        :param str goal_gid: Globally unique identifier for the goal. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.remove_supporting_relationship_with_http_info(body, goal_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_supporting_relationship_with_http_info(body, goal_gid, **kwargs)  # noqa: E501
            return data

    def remove_supporting_relationship_with_http_info(self, body, goal_gid, **kwargs):  # noqa: E501
        """Removes a supporting goal relationship  # noqa: E501

        Removes a goal relationship for a given parent goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_supporting_relationship_with_http_info(body, goal_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalGidRemoveSupportingRelationshipBody body: The supporting resource to be removed from the goal (required)
        :param str goal_gid: Globally unique identifier for the goal. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'goal_gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_supporting_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_supporting_relationship`")  # noqa: E501
        # verify the required parameter 'goal_gid' is set
        if ('goal_gid' not in params or
                params['goal_gid'] is None):
            raise ValueError("Missing the required parameter `goal_gid` when calling `remove_supporting_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_gid' in params:
            path_params['goal_gid'] = params['goal_gid']  # noqa: E501

        query_params = []


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goals/{goal_gid}/removeSupportingRelationship', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_goal_relationship(self, body, goal_relationship_gid, **kwargs):  # noqa: E501
        """Update a goal relationship  # noqa: E501

        An existing goal relationship can be updated by making a PUT request on the URL for that goal relationship. Only the fields provided in the `data` block will be updated; any unspecified fields will remain unchanged.  Returns the complete updated goal relationship record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_goal_relationship(body, goal_relationship_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalRelationshipsGoalRelationshipGidBody body: The updated fields for the goal relationship. (required)
        :param str goal_relationship_gid: Globally unique identifier for the goal relationship. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.update_goal_relationship_with_http_info(body, goal_relationship_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_goal_relationship_with_http_info(body, goal_relationship_gid, **kwargs)  # noqa: E501
            return data

    def update_goal_relationship_with_http_info(self, body, goal_relationship_gid, **kwargs):  # noqa: E501
        """Update a goal relationship  # noqa: E501

        An existing goal relationship can be updated by making a PUT request on the URL for that goal relationship. Only the fields provided in the `data` block will be updated; any unspecified fields will remain unchanged.  Returns the complete updated goal relationship record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_goal_relationship_with_http_info(body, goal_relationship_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalRelationshipsGoalRelationshipGidBody body: The updated fields for the goal relationship. (required)
        :param str goal_relationship_gid: Globally unique identifier for the goal relationship. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: GoalRelationshipResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'goal_relationship_gid', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_goal_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_goal_relationship`")  # noqa: E501
        # verify the required parameter 'goal_relationship_gid' is set
        if ('goal_relationship_gid' not in params or
                params['goal_relationship_gid'] is None):
            raise ValueError("Missing the required parameter `goal_relationship_gid` when calling `update_goal_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_relationship_gid' in params:
            path_params['goal_relationship_gid'] = params['goal_relationship_gid']  # noqa: E501

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_relationships/{goal_relationship_gid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoalRelationshipResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
