# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from asana.api_client import ApiClient


class PortfoliosApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_custom_field_setting_for_portfolio(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Add a custom field to a portfolio  # noqa: E501

        Custom fields are associated with portfolios by way of custom field settings.  This method creates a setting for the portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_custom_field_setting_for_portfolio(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidAddCustomFieldSettingBody body: Information about the custom field setting. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: CustomFieldSettingResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.add_custom_field_setting_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_custom_field_setting_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
            return data

    def add_custom_field_setting_for_portfolio_with_http_info(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Add a custom field to a portfolio  # noqa: E501

        Custom fields are associated with portfolios by way of custom field settings.  This method creates a setting for the portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_custom_field_setting_for_portfolio_with_http_info(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidAddCustomFieldSettingBody body: Information about the custom field setting. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: CustomFieldSettingResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'portfolio_gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_custom_field_setting_for_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_custom_field_setting_for_portfolio`")  # noqa: E501
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `add_custom_field_setting_for_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}/addCustomFieldSetting', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFieldSettingResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_item_for_portfolio(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Add a portfolio item  # noqa: E501

        Add an item to a portfolio. Returns an empty data block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_item_for_portfolio(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidAddItemBody body: Information about the item being inserted. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.add_item_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_item_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
            return data

    def add_item_for_portfolio_with_http_info(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Add a portfolio item  # noqa: E501

        Add an item to a portfolio. Returns an empty data block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_item_for_portfolio_with_http_info(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidAddItemBody body: Information about the item being inserted. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'portfolio_gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_item_for_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_item_for_portfolio`")  # noqa: E501
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `add_item_for_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}/addItem', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_members_for_portfolio(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Add users to a portfolio  # noqa: E501

        Adds the specified list of users as members of the portfolio. Returns the updated portfolio record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_members_for_portfolio(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidAddMembersBody body: Information about the members being added. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.add_members_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_members_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
            return data

    def add_members_for_portfolio_with_http_info(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Add users to a portfolio  # noqa: E501

        Adds the specified list of users as members of the portfolio. Returns the updated portfolio record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_members_for_portfolio_with_http_info(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidAddMembersBody body: Information about the members being added. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'portfolio_gid', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_members_for_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_members_for_portfolio`")  # noqa: E501
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `add_members_for_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}/addMembers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio(self, body, **kwargs):  # noqa: E501
        """Create a portfolio  # noqa: E501

        Creates a new portfolio in the given workspace with the supplied name.  Note that portfolios created in the Asana UI may have some state (like the “Priority” custom field) which is automatically added to the portfolio when it is created. Portfolios created via our API will *not* be created with the same initial state to allow integrations to create their own starting state on a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfoliosBody body: The portfolio to create. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.create_portfolio_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_portfolio_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a portfolio  # noqa: E501

        Creates a new portfolio in the given workspace with the supplied name.  Note that portfolios created in the Asana UI may have some state (like the “Priority” custom field) which is automatically added to the portfolio when it is created. Portfolios created via our API will *not* be created with the same initial state to allow integrations to create their own starting state on a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfoliosBody body: The portfolio to create. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portfolio(self, portfolio_gid, **kwargs):  # noqa: E501
        """Delete a portfolio  # noqa: E501

        An existing portfolio can be deleted by making a DELETE request on the URL for that portfolio.  Returns an empty data record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio(portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.delete_portfolio_with_http_info(portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portfolio_with_http_info(portfolio_gid, **kwargs)  # noqa: E501
            return data

    def delete_portfolio_with_http_info(self, portfolio_gid, **kwargs):  # noqa: E501
        """Delete a portfolio  # noqa: E501

        An existing portfolio can be deleted by making a DELETE request on the URL for that portfolio.  Returns an empty data record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_with_http_info(portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `delete_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_items_for_portfolio(self, portfolio_gid, **kwargs):  # noqa: E501
        """Get portfolio items  # noqa: E501

        Get a list of the items in compact form in a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_items_for_portfolio(portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: ProjectResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.get_items_for_portfolio_with_http_info(portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_items_for_portfolio_with_http_info(portfolio_gid, **kwargs)  # noqa: E501
            return data

    def get_items_for_portfolio_with_http_info(self, portfolio_gid, **kwargs):  # noqa: E501
        """Get portfolio items  # noqa: E501

        Get a list of the items in compact form in a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_items_for_portfolio_with_http_info(portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: ProjectResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_gid', 'limit', 'offset', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_items_for_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `get_items_for_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}/items', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectResponseArray',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio(self, portfolio_gid, **kwargs):  # noqa: E501
        """Get a portfolio  # noqa: E501

        Returns the complete portfolio record for a single portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio(portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.get_portfolio_with_http_info(portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_with_http_info(portfolio_gid, **kwargs)  # noqa: E501
            return data

    def get_portfolio_with_http_info(self, portfolio_gid, **kwargs):  # noqa: E501
        """Get a portfolio  # noqa: E501

        Returns the complete portfolio record for a single portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_with_http_info(portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_gid', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `get_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolios(self, workspace, **kwargs):  # noqa: E501
        """Get multiple portfolios  # noqa: E501

        Returns a list of the portfolios in compact representation that are owned by the current API user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolios(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: The workspace or organization to filter portfolios on. (required)
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param str owner: The user who owns the portfolio. Currently, API users can only get a list of portfolios that they themselves own, unless the request is made from a Service Account. In the case of a Service Account, if this parameter is specified, then all portfolios owned by this parameter are returned. Otherwise, all portfolios across the workspace are returned.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.get_portfolios_with_http_info(workspace, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolios_with_http_info(workspace, **kwargs)  # noqa: E501
            return data

    def get_portfolios_with_http_info(self, workspace, **kwargs):  # noqa: E501
        """Get multiple portfolios  # noqa: E501

        Returns a list of the portfolios in compact representation that are owned by the current API user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolios_with_http_info(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace: The workspace or organization to filter portfolios on. (required)
        :param int limit: Results per page. The number of objects to return per page. The value must be between 1 and 100.
        :param str offset: Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        :param str owner: The user who owns the portfolio. Currently, API users can only get a list of portfolios that they themselves own, unless the request is made from a Service Account. In the case of a Service Account, if this parameter is specified, then all portfolios owned by this parameter are returned. Otherwise, all portfolios across the workspace are returned.
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace', 'limit', 'offset', 'owner', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolios" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace' is set
        if ('workspace' not in params or
                params['workspace'] is None):
            raise ValueError("Missing the required parameter `workspace` when calling `get_portfolios`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'workspace' in params:
            query_params.append(('workspace', params['workspace']))  # noqa: E501
        if 'owner' in params:
            query_params.append(('owner', params['owner']))  # noqa: E501
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioResponseArray',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_custom_field_setting_for_portfolio(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Remove a custom field from a portfolio  # noqa: E501

        Removes a custom field setting from a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_custom_field_setting_for_portfolio(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidRemoveCustomFieldSettingBody body: Information about the custom field setting being removed. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.remove_custom_field_setting_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_custom_field_setting_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
            return data

    def remove_custom_field_setting_for_portfolio_with_http_info(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Remove a custom field from a portfolio  # noqa: E501

        Removes a custom field setting from a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_custom_field_setting_for_portfolio_with_http_info(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidRemoveCustomFieldSettingBody body: Information about the custom field setting being removed. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'portfolio_gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_custom_field_setting_for_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_custom_field_setting_for_portfolio`")  # noqa: E501
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `remove_custom_field_setting_for_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}/removeCustomFieldSetting', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_item_for_portfolio(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Remove a portfolio item  # noqa: E501

        Remove an item from a portfolio. Returns an empty data block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_item_for_portfolio(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidRemoveItemBody body: Information about the item being removed. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.remove_item_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_item_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
            return data

    def remove_item_for_portfolio_with_http_info(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Remove a portfolio item  # noqa: E501

        Remove an item from a portfolio. Returns an empty data block.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_item_for_portfolio_with_http_info(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidRemoveItemBody body: Information about the item being removed. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :return: EmptyResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'portfolio_gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_item_for_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_item_for_portfolio`")  # noqa: E501
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `remove_item_for_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}/removeItem', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_members_for_portfolio(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Remove users from a portfolio  # noqa: E501

        Removes the specified list of users from members of the portfolio. Returns the updated portfolio record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_members_for_portfolio(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidRemoveMembersBody body: Information about the members being removed. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.remove_members_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_members_for_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
            return data

    def remove_members_for_portfolio_with_http_info(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Remove users from a portfolio  # noqa: E501

        Removes the specified list of users from members of the portfolio. Returns the updated portfolio record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_members_for_portfolio_with_http_info(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGidRemoveMembersBody body: Information about the members being removed. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'portfolio_gid', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_members_for_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_members_for_portfolio`")  # noqa: E501
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `remove_members_for_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}/removeMembers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_portfolio(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Update a portfolio  # noqa: E501

        An existing portfolio can be updated by making a PUT request on the URL for that portfolio. Only the fields provided in the `data` block will be updated; any unspecified fields will remain unchanged.  Returns the complete updated portfolio record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfoliosPortfolioGidBody body: The updated fields for the portfolio. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = kwargs.get("_return_http_data_only", True)
        if kwargs.get('async_req'):
            return self.update_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_portfolio_with_http_info(body, portfolio_gid, **kwargs)  # noqa: E501
            return data

    def update_portfolio_with_http_info(self, body, portfolio_gid, **kwargs):  # noqa: E501
        """Update a portfolio  # noqa: E501

        An existing portfolio can be updated by making a PUT request on the URL for that portfolio. Only the fields provided in the `data` block will be updated; any unspecified fields will remain unchanged.  Returns the complete updated portfolio record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_with_http_info(body, portfolio_gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfoliosPortfolioGidBody body: The updated fields for the portfolio. (required)
        :param str portfolio_gid: Globally unique identifier for the portfolio. (required)
        :param list[str] opt_fields: This endpoint returns a compact resource, which excludes some properties by default. To include those optional properties, set this query parameter to a comma-separated list of the properties you wish to include.
        :return: PortfolioResponseData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'portfolio_gid', 'opt_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('header_params')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_portfolio`")  # noqa: E501
        # verify the required parameter 'portfolio_gid' is set
        if ('portfolio_gid' not in params or
                params['portfolio_gid'] is None):
            raise ValueError("Missing the required parameter `portfolio_gid` when calling `update_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_gid' in params:
            path_params['portfolio_gid'] = params['portfolio_gid']  # noqa: E501

        query_params = []
        if 'opt_fields' in params:
            query_params.append(('opt_fields', params['opt_fields']))  # noqa: E501
            collection_formats['opt_fields'] = 'csv'  # noqa: E501


        header_params = kwargs.get("header_params", {})

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolios/{portfolio_gid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioResponseData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
