# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AttachmentRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource_subtype': 'str',
        'file': 'str',
        'parent': 'str',
        'url': 'str',
        'name': 'str',
        'connect_to_app': 'bool'
    }

    attribute_map = {
        'resource_subtype': 'resource_subtype',
        'file': 'file',
        'parent': 'parent',
        'url': 'url',
        'name': 'name',
        'connect_to_app': 'connect_to_app'
    }

    def __init__(self, resource_subtype=None, file=None, parent=None, url=None, name=None, connect_to_app=None):  # noqa: E501
        """AttachmentRequest - a model defined in Swagger"""  # noqa: E501
        self._resource_subtype = None
        self._file = None
        self._parent = None
        self._url = None
        self._name = None
        self._connect_to_app = None
        self.discriminator = None
        if resource_subtype is not None:
            self.resource_subtype = resource_subtype
        if file is not None:
            self.file = file
        self.parent = parent
        if url is not None:
            self.url = url
        if name is not None:
            self.name = name
        if connect_to_app is not None:
            self.connect_to_app = connect_to_app

    @property
    def resource_subtype(self):
        """Gets the resource_subtype of this AttachmentRequest.  # noqa: E501

        The type of the attachment. Must be one of the given values. If not specified, a file attachment of type `asana` will be assumed. Note that if the value of `resource_subtype` is `external`, a `parent`, `name`, and `url` must also be provided.   # noqa: E501

        :return: The resource_subtype of this AttachmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._resource_subtype

    @resource_subtype.setter
    def resource_subtype(self, resource_subtype):
        """Sets the resource_subtype of this AttachmentRequest.

        The type of the attachment. Must be one of the given values. If not specified, a file attachment of type `asana` will be assumed. Note that if the value of `resource_subtype` is `external`, a `parent`, `name`, and `url` must also be provided.   # noqa: E501

        :param resource_subtype: The resource_subtype of this AttachmentRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["asana", "dropbox", "gdrive", "onedrive", "box", "vimeo", "external"]  # noqa: E501
        if resource_subtype not in allowed_values:
            raise ValueError(
                "Invalid value for `resource_subtype` ({0}), must be one of {1}"  # noqa: E501
                .format(resource_subtype, allowed_values)
            )

        self._resource_subtype = resource_subtype

    @property
    def file(self):
        """Gets the file of this AttachmentRequest.  # noqa: E501

        Required for `asana` attachments.   # noqa: E501

        :return: The file of this AttachmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this AttachmentRequest.

        Required for `asana` attachments.   # noqa: E501

        :param file: The file of this AttachmentRequest.  # noqa: E501
        :type: str
        """

        self._file = file

    @property
    def parent(self):
        """Gets the parent of this AttachmentRequest.  # noqa: E501

        Required identifier of the parent task, project, or project_brief, as a string.   # noqa: E501

        :return: The parent of this AttachmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this AttachmentRequest.

        Required identifier of the parent task, project, or project_brief, as a string.   # noqa: E501

        :param parent: The parent of this AttachmentRequest.  # noqa: E501
        :type: str
        """
        if parent is None:
            raise ValueError("Invalid value for `parent`, must not be `None`")  # noqa: E501

        self._parent = parent

    @property
    def url(self):
        """Gets the url of this AttachmentRequest.  # noqa: E501

        The URL of the external resource being attached. Required for attachments of type `external`.   # noqa: E501

        :return: The url of this AttachmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this AttachmentRequest.

        The URL of the external resource being attached. Required for attachments of type `external`.   # noqa: E501

        :param url: The url of this AttachmentRequest.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def name(self):
        """Gets the name of this AttachmentRequest.  # noqa: E501

        The name of the external resource being attached. Required for attachments of type `external`.   # noqa: E501

        :return: The name of this AttachmentRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AttachmentRequest.

        The name of the external resource being attached. Required for attachments of type `external`.   # noqa: E501

        :param name: The name of this AttachmentRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def connect_to_app(self):
        """Gets the connect_to_app of this AttachmentRequest.  # noqa: E501

        *Optional*. Only relevant for external attachments with a parent task. A boolean indicating whether the current app should be connected with the attachment for the purposes of showing an app components widget. Requires the app to have been added to a project the parent task is in.   # noqa: E501

        :return: The connect_to_app of this AttachmentRequest.  # noqa: E501
        :rtype: bool
        """
        return self._connect_to_app

    @connect_to_app.setter
    def connect_to_app(self, connect_to_app):
        """Sets the connect_to_app of this AttachmentRequest.

        *Optional*. Only relevant for external attachments with a parent task. A boolean indicating whether the current app should be connected with the attachment for the purposes of showing an app components widget. Requires the app to have been added to a project the parent task is in.   # noqa: E501

        :param connect_to_app: The connect_to_app of this AttachmentRequest.  # noqa: E501
        :type: bool
        """

        self._connect_to_app = connect_to_app

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AttachmentRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AttachmentRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
