# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AttachmentResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'resource_subtype': 'str',
        'created_at': 'datetime',
        'download_url': 'str',
        'permanent_url': 'str',
        'host': 'str',
        'parent': 'AttachmentResponseParent',
        'size': 'int',
        'view_url': 'str',
        'connected_to_app': 'bool'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'resource_subtype': 'resource_subtype',
        'created_at': 'created_at',
        'download_url': 'download_url',
        'permanent_url': 'permanent_url',
        'host': 'host',
        'parent': 'parent',
        'size': 'size',
        'view_url': 'view_url',
        'connected_to_app': 'connected_to_app'
    }

    def __init__(self, gid=None, resource_type=None, name=None, resource_subtype=None, created_at=None, download_url=None, permanent_url=None, host=None, parent=None, size=None, view_url=None, connected_to_app=None):  # noqa: E501
        """AttachmentResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._resource_subtype = None
        self._created_at = None
        self._download_url = None
        self._permanent_url = None
        self._host = None
        self._parent = None
        self._size = None
        self._view_url = None
        self._connected_to_app = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if resource_subtype is not None:
            self.resource_subtype = resource_subtype
        if created_at is not None:
            self.created_at = created_at
        if download_url is not None:
            self.download_url = download_url
        if permanent_url is not None:
            self.permanent_url = permanent_url
        if host is not None:
            self.host = host
        if parent is not None:
            self.parent = parent
        if size is not None:
            self.size = size
        if view_url is not None:
            self.view_url = view_url
        if connected_to_app is not None:
            self.connected_to_app = connected_to_app

    @property
    def gid(self):
        """Gets the gid of this AttachmentResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this AttachmentResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this AttachmentResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this AttachmentResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this AttachmentResponse.  # noqa: E501

        The name of the file.  # noqa: E501

        :return: The name of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AttachmentResponse.

        The name of the file.  # noqa: E501

        :param name: The name of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def resource_subtype(self):
        """Gets the resource_subtype of this AttachmentResponse.  # noqa: E501

        The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `onedrive`, `box`, `vimeo`, and `external`.  # noqa: E501

        :return: The resource_subtype of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_subtype

    @resource_subtype.setter
    def resource_subtype(self, resource_subtype):
        """Sets the resource_subtype of this AttachmentResponse.

        The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `onedrive`, `box`, `vimeo`, and `external`.  # noqa: E501

        :param resource_subtype: The resource_subtype of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._resource_subtype = resource_subtype

    @property
    def created_at(self):
        """Gets the created_at of this AttachmentResponse.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this AttachmentResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this AttachmentResponse.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this AttachmentResponse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def download_url(self):
        """Gets the download_url of this AttachmentResponse.  # noqa: E501

        The URL containing the content of the attachment. *Note:* May be null if the attachment is hosted by [Box](https://www.box.com/) and will be null if the attachment is a Video Message hosted by [Vimeo](https://vimeo.com/). If present, this URL may only be valid for two minutes from the time of retrieval. You should avoid persisting this URL somewhere and just refresh it on demand to ensure you do not keep stale URLs.  # noqa: E501

        :return: The download_url of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url):
        """Sets the download_url of this AttachmentResponse.

        The URL containing the content of the attachment. *Note:* May be null if the attachment is hosted by [Box](https://www.box.com/) and will be null if the attachment is a Video Message hosted by [Vimeo](https://vimeo.com/). If present, this URL may only be valid for two minutes from the time of retrieval. You should avoid persisting this URL somewhere and just refresh it on demand to ensure you do not keep stale URLs.  # noqa: E501

        :param download_url: The download_url of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._download_url = download_url

    @property
    def permanent_url(self):
        """Gets the permanent_url of this AttachmentResponse.  # noqa: E501


        :return: The permanent_url of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._permanent_url

    @permanent_url.setter
    def permanent_url(self, permanent_url):
        """Sets the permanent_url of this AttachmentResponse.


        :param permanent_url: The permanent_url of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._permanent_url = permanent_url

    @property
    def host(self):
        """Gets the host of this AttachmentResponse.  # noqa: E501

        The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `box`, and `vimeo`.  # noqa: E501

        :return: The host of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this AttachmentResponse.

        The service hosting the attachment. Valid values are `asana`, `dropbox`, `gdrive`, `box`, and `vimeo`.  # noqa: E501

        :param host: The host of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._host = host

    @property
    def parent(self):
        """Gets the parent of this AttachmentResponse.  # noqa: E501


        :return: The parent of this AttachmentResponse.  # noqa: E501
        :rtype: AttachmentResponseParent
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this AttachmentResponse.


        :param parent: The parent of this AttachmentResponse.  # noqa: E501
        :type: AttachmentResponseParent
        """

        self._parent = parent

    @property
    def size(self):
        """Gets the size of this AttachmentResponse.  # noqa: E501

        The size of the attachment in bytes. Only present when the `resource_subtype` is `asana`.  # noqa: E501

        :return: The size of this AttachmentResponse.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this AttachmentResponse.

        The size of the attachment in bytes. Only present when the `resource_subtype` is `asana`.  # noqa: E501

        :param size: The size of this AttachmentResponse.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def view_url(self):
        """Gets the view_url of this AttachmentResponse.  # noqa: E501

        The URL where the attachment can be viewed, which may be friendlier to users in a browser than just directing them to a raw file. May be null if no view URL exists for the service.  # noqa: E501

        :return: The view_url of this AttachmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._view_url

    @view_url.setter
    def view_url(self, view_url):
        """Sets the view_url of this AttachmentResponse.

        The URL where the attachment can be viewed, which may be friendlier to users in a browser than just directing them to a raw file. May be null if no view URL exists for the service.  # noqa: E501

        :param view_url: The view_url of this AttachmentResponse.  # noqa: E501
        :type: str
        """

        self._view_url = view_url

    @property
    def connected_to_app(self):
        """Gets the connected_to_app of this AttachmentResponse.  # noqa: E501

        Whether the attachment is connected to the app making the request for the purposes of showing an app components widget. Only present when the `resource_subtype` is `external` or `gdrive`.  # noqa: E501

        :return: The connected_to_app of this AttachmentResponse.  # noqa: E501
        :rtype: bool
        """
        return self._connected_to_app

    @connected_to_app.setter
    def connected_to_app(self, connected_to_app):
        """Sets the connected_to_app of this AttachmentResponse.

        Whether the attachment is connected to the app making the request for the purposes of showing an app components widget. Only present when the `resource_subtype` is `external` or `gdrive`.  # noqa: E501

        :param connected_to_app: The connected_to_app of this AttachmentResponse.  # noqa: E501
        :type: bool
        """

        self._connected_to_app = connected_to_app

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AttachmentResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AttachmentResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
