# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AuditLogEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'created_at': 'datetime',
        'event_type': 'str',
        'event_category': 'str',
        'actor': 'AuditLogEventActor',
        'resource': 'AuditLogEventResource',
        'details': 'object',
        'context': 'AuditLogEventContext'
    }

    attribute_map = {
        'gid': 'gid',
        'created_at': 'created_at',
        'event_type': 'event_type',
        'event_category': 'event_category',
        'actor': 'actor',
        'resource': 'resource',
        'details': 'details',
        'context': 'context'
    }

    def __init__(self, gid=None, created_at=None, event_type=None, event_category=None, actor=None, resource=None, details=None, context=None):  # noqa: E501
        """AuditLogEvent - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._created_at = None
        self._event_type = None
        self._event_category = None
        self._actor = None
        self._resource = None
        self._details = None
        self._context = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if created_at is not None:
            self.created_at = created_at
        if event_type is not None:
            self.event_type = event_type
        if event_category is not None:
            self.event_category = event_category
        if actor is not None:
            self.actor = actor
        if resource is not None:
            self.resource = resource
        if details is not None:
            self.details = details
        if context is not None:
            self.context = context

    @property
    def gid(self):
        """Gets the gid of this AuditLogEvent.  # noqa: E501

        Globally unique identifier of the `AuditLogEvent`, as a string.  # noqa: E501

        :return: The gid of this AuditLogEvent.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this AuditLogEvent.

        Globally unique identifier of the `AuditLogEvent`, as a string.  # noqa: E501

        :param gid: The gid of this AuditLogEvent.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def created_at(self):
        """Gets the created_at of this AuditLogEvent.  # noqa: E501

        The time the event was created.  # noqa: E501

        :return: The created_at of this AuditLogEvent.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this AuditLogEvent.

        The time the event was created.  # noqa: E501

        :param created_at: The created_at of this AuditLogEvent.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def event_type(self):
        """Gets the event_type of this AuditLogEvent.  # noqa: E501

        The type of the event.  # noqa: E501

        :return: The event_type of this AuditLogEvent.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this AuditLogEvent.

        The type of the event.  # noqa: E501

        :param event_type: The event_type of this AuditLogEvent.  # noqa: E501
        :type: str
        """

        self._event_type = event_type

    @property
    def event_category(self):
        """Gets the event_category of this AuditLogEvent.  # noqa: E501

        The category that this `event_type` belongs to.  # noqa: E501

        :return: The event_category of this AuditLogEvent.  # noqa: E501
        :rtype: str
        """
        return self._event_category

    @event_category.setter
    def event_category(self, event_category):
        """Sets the event_category of this AuditLogEvent.

        The category that this `event_type` belongs to.  # noqa: E501

        :param event_category: The event_category of this AuditLogEvent.  # noqa: E501
        :type: str
        """

        self._event_category = event_category

    @property
    def actor(self):
        """Gets the actor of this AuditLogEvent.  # noqa: E501


        :return: The actor of this AuditLogEvent.  # noqa: E501
        :rtype: AuditLogEventActor
        """
        return self._actor

    @actor.setter
    def actor(self, actor):
        """Sets the actor of this AuditLogEvent.


        :param actor: The actor of this AuditLogEvent.  # noqa: E501
        :type: AuditLogEventActor
        """

        self._actor = actor

    @property
    def resource(self):
        """Gets the resource of this AuditLogEvent.  # noqa: E501


        :return: The resource of this AuditLogEvent.  # noqa: E501
        :rtype: AuditLogEventResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this AuditLogEvent.


        :param resource: The resource of this AuditLogEvent.  # noqa: E501
        :type: AuditLogEventResource
        """

        self._resource = resource

    @property
    def details(self):
        """Gets the details of this AuditLogEvent.  # noqa: E501

        Event specific details. The schema will vary depending on the `event_type`.  # noqa: E501

        :return: The details of this AuditLogEvent.  # noqa: E501
        :rtype: object
        """
        return self._details

    @details.setter
    def details(self, details):
        """Sets the details of this AuditLogEvent.

        Event specific details. The schema will vary depending on the `event_type`.  # noqa: E501

        :param details: The details of this AuditLogEvent.  # noqa: E501
        :type: object
        """

        self._details = details

    @property
    def context(self):
        """Gets the context of this AuditLogEvent.  # noqa: E501


        :return: The context of this AuditLogEvent.  # noqa: E501
        :rtype: AuditLogEventContext
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this AuditLogEvent.


        :param context: The context of this AuditLogEvent.  # noqa: E501
        :type: AuditLogEventContext
        """

        self._context = context

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AuditLogEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuditLogEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
