# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AuditLogEventContext(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'context_type': 'str',
        'api_authentication_method': 'str',
        'client_ip_address': 'str',
        'user_agent': 'str',
        'oauth_app_name': 'str'
    }

    attribute_map = {
        'context_type': 'context_type',
        'api_authentication_method': 'api_authentication_method',
        'client_ip_address': 'client_ip_address',
        'user_agent': 'user_agent',
        'oauth_app_name': 'oauth_app_name'
    }

    def __init__(self, context_type=None, api_authentication_method=None, client_ip_address=None, user_agent=None, oauth_app_name=None):  # noqa: E501
        """AuditLogEventContext - a model defined in Swagger"""  # noqa: E501
        self._context_type = None
        self._api_authentication_method = None
        self._client_ip_address = None
        self._user_agent = None
        self._oauth_app_name = None
        self.discriminator = None
        if context_type is not None:
            self.context_type = context_type
        if api_authentication_method is not None:
            self.api_authentication_method = api_authentication_method
        if client_ip_address is not None:
            self.client_ip_address = client_ip_address
        if user_agent is not None:
            self.user_agent = user_agent
        if oauth_app_name is not None:
            self.oauth_app_name = oauth_app_name

    @property
    def context_type(self):
        """Gets the context_type of this AuditLogEventContext.  # noqa: E501

        The type of context. Can be one of `web`, `desktop`, `mobile`, `asana_support`, `asana`, `email`, or `api`.  # noqa: E501

        :return: The context_type of this AuditLogEventContext.  # noqa: E501
        :rtype: str
        """
        return self._context_type

    @context_type.setter
    def context_type(self, context_type):
        """Sets the context_type of this AuditLogEventContext.

        The type of context. Can be one of `web`, `desktop`, `mobile`, `asana_support`, `asana`, `email`, or `api`.  # noqa: E501

        :param context_type: The context_type of this AuditLogEventContext.  # noqa: E501
        :type: str
        """
        allowed_values = ["web", "desktop", "mobile", "asana_support", "asana", "email", "api"]  # noqa: E501
        if context_type not in allowed_values:
            raise ValueError(
                "Invalid value for `context_type` ({0}), must be one of {1}"  # noqa: E501
                .format(context_type, allowed_values)
            )

        self._context_type = context_type

    @property
    def api_authentication_method(self):
        """Gets the api_authentication_method of this AuditLogEventContext.  # noqa: E501

        The authentication method used in the context of an API request. Only present if the `context_type` is `api`. Can be one of `cookie`, `oauth`, `personal_access_token`, or `service_account`.  # noqa: E501

        :return: The api_authentication_method of this AuditLogEventContext.  # noqa: E501
        :rtype: str
        """
        return self._api_authentication_method

    @api_authentication_method.setter
    def api_authentication_method(self, api_authentication_method):
        """Sets the api_authentication_method of this AuditLogEventContext.

        The authentication method used in the context of an API request. Only present if the `context_type` is `api`. Can be one of `cookie`, `oauth`, `personal_access_token`, or `service_account`.  # noqa: E501

        :param api_authentication_method: The api_authentication_method of this AuditLogEventContext.  # noqa: E501
        :type: str
        """
        allowed_values = ["cookie", "oauth", "personal_access_token", "service_account"]  # noqa: E501
        if api_authentication_method not in allowed_values:
            raise ValueError(
                "Invalid value for `api_authentication_method` ({0}), must be one of {1}"  # noqa: E501
                .format(api_authentication_method, allowed_values)
            )

        self._api_authentication_method = api_authentication_method

    @property
    def client_ip_address(self):
        """Gets the client_ip_address of this AuditLogEventContext.  # noqa: E501

        The IP address of the client that initiated the event, if applicable.  # noqa: E501

        :return: The client_ip_address of this AuditLogEventContext.  # noqa: E501
        :rtype: str
        """
        return self._client_ip_address

    @client_ip_address.setter
    def client_ip_address(self, client_ip_address):
        """Sets the client_ip_address of this AuditLogEventContext.

        The IP address of the client that initiated the event, if applicable.  # noqa: E501

        :param client_ip_address: The client_ip_address of this AuditLogEventContext.  # noqa: E501
        :type: str
        """

        self._client_ip_address = client_ip_address

    @property
    def user_agent(self):
        """Gets the user_agent of this AuditLogEventContext.  # noqa: E501

        The user agent of the client that initiated the event, if applicable.  # noqa: E501

        :return: The user_agent of this AuditLogEventContext.  # noqa: E501
        :rtype: str
        """
        return self._user_agent

    @user_agent.setter
    def user_agent(self, user_agent):
        """Sets the user_agent of this AuditLogEventContext.

        The user agent of the client that initiated the event, if applicable.  # noqa: E501

        :param user_agent: The user_agent of this AuditLogEventContext.  # noqa: E501
        :type: str
        """

        self._user_agent = user_agent

    @property
    def oauth_app_name(self):
        """Gets the oauth_app_name of this AuditLogEventContext.  # noqa: E501

        The name of the OAuth App that initiated the event. Only present if the `api_authentication_method` is `oauth`.  # noqa: E501

        :return: The oauth_app_name of this AuditLogEventContext.  # noqa: E501
        :rtype: str
        """
        return self._oauth_app_name

    @oauth_app_name.setter
    def oauth_app_name(self, oauth_app_name):
        """Sets the oauth_app_name of this AuditLogEventContext.

        The name of the OAuth App that initiated the event. Only present if the `api_authentication_method` is `oauth`.  # noqa: E501

        :param oauth_app_name: The oauth_app_name of this AuditLogEventContext.  # noqa: E501
        :type: str
        """

        self._oauth_app_name = oauth_app_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AuditLogEventContext, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuditLogEventContext):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
