# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BatchRequestAction(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'relative_path': 'str',
        'method': 'str',
        'data': 'object',
        'options': 'BatchRequestOptions'
    }

    attribute_map = {
        'relative_path': 'relative_path',
        'method': 'method',
        'data': 'data',
        'options': 'options'
    }

    def __init__(self, relative_path=None, method=None, data=None, options=None):  # noqa: E501
        """BatchRequestAction - a model defined in Swagger"""  # noqa: E501
        self._relative_path = None
        self._method = None
        self._data = None
        self._options = None
        self.discriminator = None
        self.relative_path = relative_path
        self.method = method
        if data is not None:
            self.data = data
        if options is not None:
            self.options = options

    @property
    def relative_path(self):
        """Gets the relative_path of this BatchRequestAction.  # noqa: E501

        The path of the desired endpoint relative to the API’s base URL. Query parameters are not accepted here; put them in `data` instead.  # noqa: E501

        :return: The relative_path of this BatchRequestAction.  # noqa: E501
        :rtype: str
        """
        return self._relative_path

    @relative_path.setter
    def relative_path(self, relative_path):
        """Sets the relative_path of this BatchRequestAction.

        The path of the desired endpoint relative to the API’s base URL. Query parameters are not accepted here; put them in `data` instead.  # noqa: E501

        :param relative_path: The relative_path of this BatchRequestAction.  # noqa: E501
        :type: str
        """
        if relative_path is None:
            raise ValueError("Invalid value for `relative_path`, must not be `None`")  # noqa: E501

        self._relative_path = relative_path

    @property
    def method(self):
        """Gets the method of this BatchRequestAction.  # noqa: E501

        The HTTP method you wish to emulate for the action.  # noqa: E501

        :return: The method of this BatchRequestAction.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this BatchRequestAction.

        The HTTP method you wish to emulate for the action.  # noqa: E501

        :param method: The method of this BatchRequestAction.  # noqa: E501
        :type: str
        """
        if method is None:
            raise ValueError("Invalid value for `method`, must not be `None`")  # noqa: E501
        allowed_values = ["get", "post", "put", "delete", "patch", "head"]  # noqa: E501
        if method not in allowed_values:
            raise ValueError(
                "Invalid value for `method` ({0}), must be one of {1}"  # noqa: E501
                .format(method, allowed_values)
            )

        self._method = method

    @property
    def data(self):
        """Gets the data of this BatchRequestAction.  # noqa: E501

        For `GET` requests, this should be a map of query parameters you would have normally passed in the URL. Options and pagination are not accepted here; put them in `options` instead. For `POST`, `PATCH`, and `PUT` methods, this should be the content you would have normally put in the data field of the body.  # noqa: E501

        :return: The data of this BatchRequestAction.  # noqa: E501
        :rtype: object
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this BatchRequestAction.

        For `GET` requests, this should be a map of query parameters you would have normally passed in the URL. Options and pagination are not accepted here; put them in `options` instead. For `POST`, `PATCH`, and `PUT` methods, this should be the content you would have normally put in the data field of the body.  # noqa: E501

        :param data: The data of this BatchRequestAction.  # noqa: E501
        :type: object
        """

        self._data = data

    @property
    def options(self):
        """Gets the options of this BatchRequestAction.  # noqa: E501


        :return: The options of this BatchRequestAction.  # noqa: E501
        :rtype: BatchRequestOptions
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this BatchRequestAction.


        :param options: The options of this BatchRequestAction.  # noqa: E501
        :type: BatchRequestOptions
        """

        self._options = options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BatchRequestAction, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BatchRequestAction):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
