# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BatchRequestOptions(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'limit': 'int',
        'offset': 'int',
        'fields': 'list[str]'
    }

    attribute_map = {
        'limit': 'limit',
        'offset': 'offset',
        'fields': 'fields'
    }

    def __init__(self, limit=None, offset=None, fields=None):  # noqa: E501
        """BatchRequestOptions - a model defined in Swagger"""  # noqa: E501
        self._limit = None
        self._offset = None
        self._fields = None
        self.discriminator = None
        if limit is not None:
            self.limit = limit
        if offset is not None:
            self.offset = offset
        if fields is not None:
            self.fields = fields

    @property
    def limit(self):
        """Gets the limit of this BatchRequestOptions.  # noqa: E501

        Pagination limit for the request.  # noqa: E501

        :return: The limit of this BatchRequestOptions.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this BatchRequestOptions.

        Pagination limit for the request.  # noqa: E501

        :param limit: The limit of this BatchRequestOptions.  # noqa: E501
        :type: int
        """

        self._limit = limit

    @property
    def offset(self):
        """Gets the offset of this BatchRequestOptions.  # noqa: E501

        Pagination offset for the request.  # noqa: E501

        :return: The offset of this BatchRequestOptions.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this BatchRequestOptions.

        Pagination offset for the request.  # noqa: E501

        :param offset: The offset of this BatchRequestOptions.  # noqa: E501
        :type: int
        """

        self._offset = offset

    @property
    def fields(self):
        """Gets the fields of this BatchRequestOptions.  # noqa: E501

        The fields to retrieve in the request.  # noqa: E501

        :return: The fields of this BatchRequestOptions.  # noqa: E501
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """Sets the fields of this BatchRequestOptions.

        The fields to retrieve in the request.  # noqa: E501

        :param fields: The fields of this BatchRequestOptions.  # noqa: E501
        :type: list[str]
        """

        self._fields = fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BatchRequestOptions, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BatchRequestOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
