# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateMembershipRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_active': 'bool',
        'member': 'str',
        'parent': 'str'
    }

    attribute_map = {
        'is_active': 'is_active',
        'member': 'member',
        'parent': 'parent'
    }

    def __init__(self, is_active=None, member=None, parent=None):  # noqa: E501
        """CreateMembershipRequest - a model defined in Swagger"""  # noqa: E501
        self._is_active = None
        self._member = None
        self._parent = None
        self.discriminator = None
        if is_active is not None:
            self.is_active = is_active
        if member is not None:
            self.member = member
        if parent is not None:
            self.parent = parent

    @property
    def is_active(self):
        """Gets the is_active of this CreateMembershipRequest.  # noqa: E501

        *Optional*. Denotes if a member is active. Applies to all memberships  # noqa: E501

        :return: The is_active of this CreateMembershipRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this CreateMembershipRequest.

        *Optional*. Denotes if a member is active. Applies to all memberships  # noqa: E501

        :param is_active: The is_active of this CreateMembershipRequest.  # noqa: E501
        :type: bool
        """

        self._is_active = is_active

    @property
    def member(self):
        """Gets the member of this CreateMembershipRequest.  # noqa: E501

        The gid of the user or team  # noqa: E501

        :return: The member of this CreateMembershipRequest.  # noqa: E501
        :rtype: str
        """
        return self._member

    @member.setter
    def member(self, member):
        """Sets the member of this CreateMembershipRequest.

        The gid of the user or team  # noqa: E501

        :param member: The member of this CreateMembershipRequest.  # noqa: E501
        :type: str
        """

        self._member = member

    @property
    def parent(self):
        """Gets the parent of this CreateMembershipRequest.  # noqa: E501

        The gid of the `goal`  # noqa: E501

        :return: The parent of this CreateMembershipRequest.  # noqa: E501
        :rtype: str
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this CreateMembershipRequest.

        The gid of the `goal`  # noqa: E501

        :param parent: The parent of this CreateMembershipRequest.  # noqa: E501
        :type: str
        """

        self._parent = parent

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateMembershipRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateMembershipRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
