# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ErrorResponseErrors(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'message': 'str',
        'help': 'str',
        'phrase': 'str'
    }

    attribute_map = {
        'message': 'message',
        'help': 'help',
        'phrase': 'phrase'
    }

    def __init__(self, message=None, help=None, phrase=None):  # noqa: E501
        """ErrorResponseErrors - a model defined in Swagger"""  # noqa: E501
        self._message = None
        self._help = None
        self._phrase = None
        self.discriminator = None
        if message is not None:
            self.message = message
        if help is not None:
            self.help = help
        if phrase is not None:
            self.phrase = phrase

    @property
    def message(self):
        """Gets the message of this ErrorResponseErrors.  # noqa: E501

        Message providing more detail about the error that occurred, if available.  # noqa: E501

        :return: The message of this ErrorResponseErrors.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ErrorResponseErrors.

        Message providing more detail about the error that occurred, if available.  # noqa: E501

        :param message: The message of this ErrorResponseErrors.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def help(self):
        """Gets the help of this ErrorResponseErrors.  # noqa: E501

        Additional information directing developers to resources on how to address and fix the problem, if available.  # noqa: E501

        :return: The help of this ErrorResponseErrors.  # noqa: E501
        :rtype: str
        """
        return self._help

    @help.setter
    def help(self, help):
        """Sets the help of this ErrorResponseErrors.

        Additional information directing developers to resources on how to address and fix the problem, if available.  # noqa: E501

        :param help: The help of this ErrorResponseErrors.  # noqa: E501
        :type: str
        """

        self._help = help

    @property
    def phrase(self):
        """Gets the phrase of this ErrorResponseErrors.  # noqa: E501

        *500 errors only*. A unique error phrase which can be used when contacting developer support to help identify the exact occurrence of the problem in Asana’s logs.  # noqa: E501

        :return: The phrase of this ErrorResponseErrors.  # noqa: E501
        :rtype: str
        """
        return self._phrase

    @phrase.setter
    def phrase(self, phrase):
        """Sets the phrase of this ErrorResponseErrors.

        *500 errors only*. A unique error phrase which can be used when contacting developer support to help identify the exact occurrence of the problem in Asana’s logs.  # noqa: E501

        :param phrase: The phrase of this ErrorResponseErrors.  # noqa: E501
        :type: str
        """

        self._phrase = phrase

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ErrorResponseErrors, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ErrorResponseErrors):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
