# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EventResponseChange(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'field': 'str',
        'action': 'str',
        'new_value': 'object',
        'added_value': 'object',
        'removed_value': 'object'
    }

    attribute_map = {
        'field': 'field',
        'action': 'action',
        'new_value': 'new_value',
        'added_value': 'added_value',
        'removed_value': 'removed_value'
    }

    def __init__(self, field=None, action=None, new_value=None, added_value=None, removed_value=None):  # noqa: E501
        """EventResponseChange - a model defined in Swagger"""  # noqa: E501
        self._field = None
        self._action = None
        self._new_value = None
        self._added_value = None
        self._removed_value = None
        self.discriminator = None
        if field is not None:
            self.field = field
        if action is not None:
            self.action = action
        if new_value is not None:
            self.new_value = new_value
        if added_value is not None:
            self.added_value = added_value
        if removed_value is not None:
            self.removed_value = removed_value

    @property
    def field(self):
        """Gets the field of this EventResponseChange.  # noqa: E501

        The name of the field that has changed in the resource.  # noqa: E501

        :return: The field of this EventResponseChange.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this EventResponseChange.

        The name of the field that has changed in the resource.  # noqa: E501

        :param field: The field of this EventResponseChange.  # noqa: E501
        :type: str
        """

        self._field = field

    @property
    def action(self):
        """Gets the action of this EventResponseChange.  # noqa: E501

        The type of action taken on the **field** which has been changed.  This can be one of `changed`, `added`, or `removed` depending on the nature of the change.  # noqa: E501

        :return: The action of this EventResponseChange.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this EventResponseChange.

        The type of action taken on the **field** which has been changed.  This can be one of `changed`, `added`, or `removed` depending on the nature of the change.  # noqa: E501

        :param action: The action of this EventResponseChange.  # noqa: E501
        :type: str
        """

        self._action = action

    @property
    def new_value(self):
        """Gets the new_value of this EventResponseChange.  # noqa: E501

        *Conditional.* This property is only present when the value of the event's `change.action` is `changed` _and_ the `new_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/inputoutput-options)) when using the [get events](/reference/getevents) endpoint.  # noqa: E501

        :return: The new_value of this EventResponseChange.  # noqa: E501
        :rtype: object
        """
        return self._new_value

    @new_value.setter
    def new_value(self, new_value):
        """Sets the new_value of this EventResponseChange.

        *Conditional.* This property is only present when the value of the event's `change.action` is `changed` _and_ the `new_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/inputoutput-options)) when using the [get events](/reference/getevents) endpoint.  # noqa: E501

        :param new_value: The new_value of this EventResponseChange.  # noqa: E501
        :type: object
        """

        self._new_value = new_value

    @property
    def added_value(self):
        """Gets the added_value of this EventResponseChange.  # noqa: E501

        *Conditional.* This property is only present when the value of the event's `change.action` is `added` _and_ the `added_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/inputoutput-options)) when using the [get events](/reference/getevents) endpoint.  # noqa: E501

        :return: The added_value of this EventResponseChange.  # noqa: E501
        :rtype: object
        """
        return self._added_value

    @added_value.setter
    def added_value(self, added_value):
        """Sets the added_value of this EventResponseChange.

        *Conditional.* This property is only present when the value of the event's `change.action` is `added` _and_ the `added_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/inputoutput-options)) when using the [get events](/reference/getevents) endpoint.  # noqa: E501

        :param added_value: The added_value of this EventResponseChange.  # noqa: E501
        :type: object
        """

        self._added_value = added_value

    @property
    def removed_value(self):
        """Gets the removed_value of this EventResponseChange.  # noqa: E501

        *Conditional.* This property is only present when the value of the event's `change.action` is `removed` _and_ the `removed_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/inputoutput-options)) when using the [get events](/reference/getevents) endpoint.  # noqa: E501

        :return: The removed_value of this EventResponseChange.  # noqa: E501
        :rtype: object
        """
        return self._removed_value

    @removed_value.setter
    def removed_value(self, removed_value):
        """Sets the removed_value of this EventResponseChange.

        *Conditional.* This property is only present when the value of the event's `change.action` is `removed` _and_ the `removed_value` is an Asana resource. This will be only the `gid` and `resource_type` of the resource when the events come from webhooks; this will be the compact representation (and can have fields expanded with [opt_fields](/docs/inputoutput-options)) when using the [get events](/reference/getevents) endpoint.  # noqa: E501

        :param removed_value: The removed_value of this EventResponseChange.  # noqa: E501
        :type: object
        """

        self._removed_value = removed_value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EventResponseChange, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventResponseChange):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
