# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GoalAddSubgoalRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'subgoal': 'str',
        'insert_before': 'str',
        'insert_after': 'str'
    }

    attribute_map = {
        'subgoal': 'subgoal',
        'insert_before': 'insert_before',
        'insert_after': 'insert_after'
    }

    def __init__(self, subgoal=None, insert_before=None, insert_after=None):  # noqa: E501
        """GoalAddSubgoalRequest - a model defined in Swagger"""  # noqa: E501
        self._subgoal = None
        self._insert_before = None
        self._insert_after = None
        self.discriminator = None
        self.subgoal = subgoal
        if insert_before is not None:
            self.insert_before = insert_before
        if insert_after is not None:
            self.insert_after = insert_after

    @property
    def subgoal(self):
        """Gets the subgoal of this GoalAddSubgoalRequest.  # noqa: E501

        The goal gid to add as subgoal to a parent goal  # noqa: E501

        :return: The subgoal of this GoalAddSubgoalRequest.  # noqa: E501
        :rtype: str
        """
        return self._subgoal

    @subgoal.setter
    def subgoal(self, subgoal):
        """Sets the subgoal of this GoalAddSubgoalRequest.

        The goal gid to add as subgoal to a parent goal  # noqa: E501

        :param subgoal: The subgoal of this GoalAddSubgoalRequest.  # noqa: E501
        :type: str
        """
        if subgoal is None:
            raise ValueError("Invalid value for `subgoal`, must not be `None`")  # noqa: E501

        self._subgoal = subgoal

    @property
    def insert_before(self):
        """Gets the insert_before of this GoalAddSubgoalRequest.  # noqa: E501

        An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.  # noqa: E501

        :return: The insert_before of this GoalAddSubgoalRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_before

    @insert_before.setter
    def insert_before(self, insert_before):
        """Sets the insert_before of this GoalAddSubgoalRequest.

        An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.  # noqa: E501

        :param insert_before: The insert_before of this GoalAddSubgoalRequest.  # noqa: E501
        :type: str
        """

        self._insert_before = insert_before

    @property
    def insert_after(self):
        """Gets the insert_after of this GoalAddSubgoalRequest.  # noqa: E501

        An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.  # noqa: E501

        :return: The insert_after of this GoalAddSubgoalRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_after

    @insert_after.setter
    def insert_after(self, insert_after):
        """Sets the insert_after of this GoalAddSubgoalRequest.

        An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified.  # noqa: E501

        :param insert_after: The insert_after of this GoalAddSubgoalRequest.  # noqa: E501
        :type: str
        """

        self._insert_after = insert_after

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GoalAddSubgoalRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GoalAddSubgoalRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
