# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GoalAddSupportingRelationshipRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'supporting_resource': 'str',
        'insert_before': 'str',
        'insert_after': 'str',
        'contribution_weight': 'float'
    }

    attribute_map = {
        'supporting_resource': 'supporting_resource',
        'insert_before': 'insert_before',
        'insert_after': 'insert_after',
        'contribution_weight': 'contribution_weight'
    }

    def __init__(self, supporting_resource=None, insert_before=None, insert_after=None, contribution_weight=None):  # noqa: E501
        """GoalAddSupportingRelationshipRequest - a model defined in Swagger"""  # noqa: E501
        self._supporting_resource = None
        self._insert_before = None
        self._insert_after = None
        self._contribution_weight = None
        self.discriminator = None
        self.supporting_resource = supporting_resource
        if insert_before is not None:
            self.insert_before = insert_before
        if insert_after is not None:
            self.insert_after = insert_after
        if contribution_weight is not None:
            self.contribution_weight = contribution_weight

    @property
    def supporting_resource(self):
        """Gets the supporting_resource of this GoalAddSupportingRelationshipRequest.  # noqa: E501

        The gid of the supporting resource to add to the parent goal. Must be the gid of a goal, project, or portfolio.  # noqa: E501

        :return: The supporting_resource of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :rtype: str
        """
        return self._supporting_resource

    @supporting_resource.setter
    def supporting_resource(self, supporting_resource):
        """Sets the supporting_resource of this GoalAddSupportingRelationshipRequest.

        The gid of the supporting resource to add to the parent goal. Must be the gid of a goal, project, or portfolio.  # noqa: E501

        :param supporting_resource: The supporting_resource of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :type: str
        """
        if supporting_resource is None:
            raise ValueError("Invalid value for `supporting_resource`, must not be `None`")  # noqa: E501

        self._supporting_resource = supporting_resource

    @property
    def insert_before(self):
        """Gets the insert_before of this GoalAddSupportingRelationshipRequest.  # noqa: E501

        An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.  # noqa: E501

        :return: The insert_before of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_before

    @insert_before.setter
    def insert_before(self, insert_before):
        """Sets the insert_before of this GoalAddSupportingRelationshipRequest.

        An id of a subgoal of this parent goal. The new subgoal will be added before the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.  # noqa: E501

        :param insert_before: The insert_before of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :type: str
        """

        self._insert_before = insert_before

    @property
    def insert_after(self):
        """Gets the insert_after of this GoalAddSupportingRelationshipRequest.  # noqa: E501

        An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.  # noqa: E501

        :return: The insert_after of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_after

    @insert_after.setter
    def insert_after(self, insert_after):
        """Sets the insert_after of this GoalAddSupportingRelationshipRequest.

        An id of a subgoal of this parent goal. The new subgoal will be added after the one specified here. `insert_before` and `insert_after` parameters cannot both be specified. Currently only supported when adding a subgoal.  # noqa: E501

        :param insert_after: The insert_after of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :type: str
        """

        self._insert_after = insert_after

    @property
    def contribution_weight(self):
        """Gets the contribution_weight of this GoalAddSupportingRelationshipRequest.  # noqa: E501

        The weight that the supporting resource's progress will contribute to the supported goal's progress. This can only be 0 or 1.  # noqa: E501

        :return: The contribution_weight of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :rtype: float
        """
        return self._contribution_weight

    @contribution_weight.setter
    def contribution_weight(self, contribution_weight):
        """Sets the contribution_weight of this GoalAddSupportingRelationshipRequest.

        The weight that the supporting resource's progress will contribute to the supported goal's progress. This can only be 0 or 1.  # noqa: E501

        :param contribution_weight: The contribution_weight of this GoalAddSupportingRelationshipRequest.  # noqa: E501
        :type: float
        """

        self._contribution_weight = contribution_weight

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GoalAddSupportingRelationshipRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GoalAddSupportingRelationshipRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
