# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GoalMembershipBase(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'resource_subtype': 'str',
        'member': 'MembershipCompactMember',
        'parent': 'MembershipCompactParent',
        'role': 'str',
        'goal': 'MembershipCompactGoal'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'resource_subtype': 'resource_subtype',
        'member': 'member',
        'parent': 'parent',
        'role': 'role',
        'goal': 'goal'
    }

    def __init__(self, gid=None, resource_type=None, resource_subtype=None, member=None, parent=None, role=None, goal=None):  # noqa: E501
        """GoalMembershipBase - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._resource_subtype = None
        self._member = None
        self._parent = None
        self._role = None
        self._goal = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if resource_subtype is not None:
            self.resource_subtype = resource_subtype
        if member is not None:
            self.member = member
        if parent is not None:
            self.parent = parent
        if role is not None:
            self.role = role
        if goal is not None:
            self.goal = goal

    @property
    def gid(self):
        """Gets the gid of this GoalMembershipBase.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this GoalMembershipBase.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this GoalMembershipBase.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this GoalMembershipBase.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this GoalMembershipBase.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this GoalMembershipBase.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this GoalMembershipBase.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this GoalMembershipBase.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def resource_subtype(self):
        """Gets the resource_subtype of this GoalMembershipBase.  # noqa: E501

        The type of membership.  # noqa: E501

        :return: The resource_subtype of this GoalMembershipBase.  # noqa: E501
        :rtype: str
        """
        return self._resource_subtype

    @resource_subtype.setter
    def resource_subtype(self, resource_subtype):
        """Sets the resource_subtype of this GoalMembershipBase.

        The type of membership.  # noqa: E501

        :param resource_subtype: The resource_subtype of this GoalMembershipBase.  # noqa: E501
        :type: str
        """

        self._resource_subtype = resource_subtype

    @property
    def member(self):
        """Gets the member of this GoalMembershipBase.  # noqa: E501


        :return: The member of this GoalMembershipBase.  # noqa: E501
        :rtype: MembershipCompactMember
        """
        return self._member

    @member.setter
    def member(self, member):
        """Sets the member of this GoalMembershipBase.


        :param member: The member of this GoalMembershipBase.  # noqa: E501
        :type: MembershipCompactMember
        """

        self._member = member

    @property
    def parent(self):
        """Gets the parent of this GoalMembershipBase.  # noqa: E501


        :return: The parent of this GoalMembershipBase.  # noqa: E501
        :rtype: MembershipCompactParent
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this GoalMembershipBase.


        :param parent: The parent of this GoalMembershipBase.  # noqa: E501
        :type: MembershipCompactParent
        """

        self._parent = parent

    @property
    def role(self):
        """Gets the role of this GoalMembershipBase.  # noqa: E501

        Describes if the member is a commenter or editor in goal.  # noqa: E501

        :return: The role of this GoalMembershipBase.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this GoalMembershipBase.

        Describes if the member is a commenter or editor in goal.  # noqa: E501

        :param role: The role of this GoalMembershipBase.  # noqa: E501
        :type: str
        """
        allowed_values = ["commenter", "editor"]  # noqa: E501
        if role not in allowed_values:
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def goal(self):
        """Gets the goal of this GoalMembershipBase.  # noqa: E501


        :return: The goal of this GoalMembershipBase.  # noqa: E501
        :rtype: MembershipCompactGoal
        """
        return self._goal

    @goal.setter
    def goal(self, goal):
        """Sets the goal of this GoalMembershipBase.


        :param goal: The goal of this GoalMembershipBase.  # noqa: E501
        :type: MembershipCompactGoal
        """

        self._goal = goal

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GoalMembershipBase, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GoalMembershipBase):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
