# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GoalResponseMetric(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'resource_subtype': 'str',
        'precision': 'int',
        'unit': 'str',
        'currency_code': 'str',
        'initial_number_value': 'float',
        'target_number_value': 'float',
        'current_number_value': 'float',
        'current_display_value': 'str',
        'progress_source': 'str',
        'can_manage': 'bool'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'resource_subtype': 'resource_subtype',
        'precision': 'precision',
        'unit': 'unit',
        'currency_code': 'currency_code',
        'initial_number_value': 'initial_number_value',
        'target_number_value': 'target_number_value',
        'current_number_value': 'current_number_value',
        'current_display_value': 'current_display_value',
        'progress_source': 'progress_source',
        'can_manage': 'can_manage'
    }

    def __init__(self, gid=None, resource_type=None, resource_subtype=None, precision=None, unit=None, currency_code=None, initial_number_value=None, target_number_value=None, current_number_value=None, current_display_value=None, progress_source=None, can_manage=None):  # noqa: E501
        """GoalResponseMetric - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._resource_subtype = None
        self._precision = None
        self._unit = None
        self._currency_code = None
        self._initial_number_value = None
        self._target_number_value = None
        self._current_number_value = None
        self._current_display_value = None
        self._progress_source = None
        self._can_manage = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if resource_subtype is not None:
            self.resource_subtype = resource_subtype
        if precision is not None:
            self.precision = precision
        if unit is not None:
            self.unit = unit
        if currency_code is not None:
            self.currency_code = currency_code
        if initial_number_value is not None:
            self.initial_number_value = initial_number_value
        if target_number_value is not None:
            self.target_number_value = target_number_value
        if current_number_value is not None:
            self.current_number_value = current_number_value
        if current_display_value is not None:
            self.current_display_value = current_display_value
        if progress_source is not None:
            self.progress_source = progress_source
        if can_manage is not None:
            self.can_manage = can_manage

    @property
    def gid(self):
        """Gets the gid of this GoalResponseMetric.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this GoalResponseMetric.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this GoalResponseMetric.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this GoalResponseMetric.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this GoalResponseMetric.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this GoalResponseMetric.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this GoalResponseMetric.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this GoalResponseMetric.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def resource_subtype(self):
        """Gets the resource_subtype of this GoalResponseMetric.  # noqa: E501

        The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.  # noqa: E501

        :return: The resource_subtype of this GoalResponseMetric.  # noqa: E501
        :rtype: str
        """
        return self._resource_subtype

    @resource_subtype.setter
    def resource_subtype(self, resource_subtype):
        """Sets the resource_subtype of this GoalResponseMetric.

        The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.  # noqa: E501

        :param resource_subtype: The resource_subtype of this GoalResponseMetric.  # noqa: E501
        :type: str
        """
        allowed_values = ["number"]  # noqa: E501
        if resource_subtype not in allowed_values:
            raise ValueError(
                "Invalid value for `resource_subtype` ({0}), must be one of {1}"  # noqa: E501
                .format(resource_subtype, allowed_values)
            )

        self._resource_subtype = resource_subtype

    @property
    def precision(self):
        """Gets the precision of this GoalResponseMetric.  # noqa: E501

        *Conditional*. Only relevant for goal metrics of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive. For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%.  # noqa: E501

        :return: The precision of this GoalResponseMetric.  # noqa: E501
        :rtype: int
        """
        return self._precision

    @precision.setter
    def precision(self, precision):
        """Sets the precision of this GoalResponseMetric.

        *Conditional*. Only relevant for goal metrics of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive. For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%.  # noqa: E501

        :param precision: The precision of this GoalResponseMetric.  # noqa: E501
        :type: int
        """

        self._precision = precision

    @property
    def unit(self):
        """Gets the unit of this GoalResponseMetric.  # noqa: E501

        A supported unit of measure for the goal metric, or none.  # noqa: E501

        :return: The unit of this GoalResponseMetric.  # noqa: E501
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """Sets the unit of this GoalResponseMetric.

        A supported unit of measure for the goal metric, or none.  # noqa: E501

        :param unit: The unit of this GoalResponseMetric.  # noqa: E501
        :type: str
        """
        allowed_values = ["none", "currency", "percentage"]  # noqa: E501
        if unit not in allowed_values:
            raise ValueError(
                "Invalid value for `unit` ({0}), must be one of {1}"  # noqa: E501
                .format(unit, allowed_values)
            )

        self._unit = unit

    @property
    def currency_code(self):
        """Gets the currency_code of this GoalResponseMetric.  # noqa: E501

        ISO 4217 currency code to format this custom field. This will be null if the `unit` is not `currency`.  # noqa: E501

        :return: The currency_code of this GoalResponseMetric.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this GoalResponseMetric.

        ISO 4217 currency code to format this custom field. This will be null if the `unit` is not `currency`.  # noqa: E501

        :param currency_code: The currency_code of this GoalResponseMetric.  # noqa: E501
        :type: str
        """

        self._currency_code = currency_code

    @property
    def initial_number_value(self):
        """Gets the initial_number_value of this GoalResponseMetric.  # noqa: E501

        This number is the start value of a goal metric of type number.  # noqa: E501

        :return: The initial_number_value of this GoalResponseMetric.  # noqa: E501
        :rtype: float
        """
        return self._initial_number_value

    @initial_number_value.setter
    def initial_number_value(self, initial_number_value):
        """Sets the initial_number_value of this GoalResponseMetric.

        This number is the start value of a goal metric of type number.  # noqa: E501

        :param initial_number_value: The initial_number_value of this GoalResponseMetric.  # noqa: E501
        :type: float
        """

        self._initial_number_value = initial_number_value

    @property
    def target_number_value(self):
        """Gets the target_number_value of this GoalResponseMetric.  # noqa: E501

        This number is the end value of a goal metric of type number. This number cannot equal `initial_number_value`.  # noqa: E501

        :return: The target_number_value of this GoalResponseMetric.  # noqa: E501
        :rtype: float
        """
        return self._target_number_value

    @target_number_value.setter
    def target_number_value(self, target_number_value):
        """Sets the target_number_value of this GoalResponseMetric.

        This number is the end value of a goal metric of type number. This number cannot equal `initial_number_value`.  # noqa: E501

        :param target_number_value: The target_number_value of this GoalResponseMetric.  # noqa: E501
        :type: float
        """

        self._target_number_value = target_number_value

    @property
    def current_number_value(self):
        """Gets the current_number_value of this GoalResponseMetric.  # noqa: E501

        This number is the current value of a goal metric of type number.  # noqa: E501

        :return: The current_number_value of this GoalResponseMetric.  # noqa: E501
        :rtype: float
        """
        return self._current_number_value

    @current_number_value.setter
    def current_number_value(self, current_number_value):
        """Sets the current_number_value of this GoalResponseMetric.

        This number is the current value of a goal metric of type number.  # noqa: E501

        :param current_number_value: The current_number_value of this GoalResponseMetric.  # noqa: E501
        :type: float
        """

        self._current_number_value = current_number_value

    @property
    def current_display_value(self):
        """Gets the current_display_value of this GoalResponseMetric.  # noqa: E501

        This string is the current value of a goal metric of type string.  # noqa: E501

        :return: The current_display_value of this GoalResponseMetric.  # noqa: E501
        :rtype: str
        """
        return self._current_display_value

    @current_display_value.setter
    def current_display_value(self, current_display_value):
        """Sets the current_display_value of this GoalResponseMetric.

        This string is the current value of a goal metric of type string.  # noqa: E501

        :param current_display_value: The current_display_value of this GoalResponseMetric.  # noqa: E501
        :type: str
        """

        self._current_display_value = current_display_value

    @property
    def progress_source(self):
        """Gets the progress_source of this GoalResponseMetric.  # noqa: E501

        This field defines how the progress value of a goal metric is being calculated. A goal's progress can be provided manually by the user, calculated automatically from contributing subgoals or projects, or managed by an integration with an external data source, such as Salesforce.  # noqa: E501

        :return: The progress_source of this GoalResponseMetric.  # noqa: E501
        :rtype: str
        """
        return self._progress_source

    @progress_source.setter
    def progress_source(self, progress_source):
        """Sets the progress_source of this GoalResponseMetric.

        This field defines how the progress value of a goal metric is being calculated. A goal's progress can be provided manually by the user, calculated automatically from contributing subgoals or projects, or managed by an integration with an external data source, such as Salesforce.  # noqa: E501

        :param progress_source: The progress_source of this GoalResponseMetric.  # noqa: E501
        :type: str
        """
        allowed_values = ["manual", "subgoal_progress", "project_task_completion", "project_milestone_completion", "external"]  # noqa: E501
        if progress_source not in allowed_values:
            raise ValueError(
                "Invalid value for `progress_source` ({0}), must be one of {1}"  # noqa: E501
                .format(progress_source, allowed_values)
            )

        self._progress_source = progress_source

    @property
    def can_manage(self):
        """Gets the can_manage of this GoalResponseMetric.  # noqa: E501

        *Conditional*. Only relevant for `progress_source` of type `external`. This boolean indicates whether the requester has the ability to update the current value of this metric. This returns `true` if the external metric was created by the requester, `false` otherwise.  # noqa: E501

        :return: The can_manage of this GoalResponseMetric.  # noqa: E501
        :rtype: bool
        """
        return self._can_manage

    @can_manage.setter
    def can_manage(self, can_manage):
        """Sets the can_manage of this GoalResponseMetric.

        *Conditional*. Only relevant for `progress_source` of type `external`. This boolean indicates whether the requester has the ability to update the current value of this metric. This returns `true` if the external metric was created by the requester, `false` otherwise.  # noqa: E501

        :param can_manage: The can_manage of this GoalResponseMetric.  # noqa: E501
        :type: bool
        """

        self._can_manage = can_manage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GoalResponseMetric, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GoalResponseMetric):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
