# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OrganizationExportCompact(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'created_at': 'datetime',
        'download_url': 'str',
        'state': 'str',
        'organization': 'GoalResponseWorkspace'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'created_at': 'created_at',
        'download_url': 'download_url',
        'state': 'state',
        'organization': 'organization'
    }

    def __init__(self, gid=None, resource_type=None, created_at=None, download_url=None, state=None, organization=None):  # noqa: E501
        """OrganizationExportCompact - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._created_at = None
        self._download_url = None
        self._state = None
        self._organization = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if created_at is not None:
            self.created_at = created_at
        if download_url is not None:
            self.download_url = download_url
        if state is not None:
            self.state = state
        if organization is not None:
            self.organization = organization

    @property
    def gid(self):
        """Gets the gid of this OrganizationExportCompact.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this OrganizationExportCompact.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this OrganizationExportCompact.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this OrganizationExportCompact.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this OrganizationExportCompact.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this OrganizationExportCompact.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this OrganizationExportCompact.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this OrganizationExportCompact.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def created_at(self):
        """Gets the created_at of this OrganizationExportCompact.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this OrganizationExportCompact.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this OrganizationExportCompact.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this OrganizationExportCompact.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def download_url(self):
        """Gets the download_url of this OrganizationExportCompact.  # noqa: E501

        Download this URL to retreive the full export of the organization in JSON format. It will be compressed in a gzip (.gz) container.  *Note: May be null if the export is still in progress or failed.  If present, this URL may only be valid for 1 hour from the time of retrieval. You should avoid persisting this URL somewhere and rather refresh on demand to ensure you do not keep stale URLs.*  # noqa: E501

        :return: The download_url of this OrganizationExportCompact.  # noqa: E501
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url):
        """Sets the download_url of this OrganizationExportCompact.

        Download this URL to retreive the full export of the organization in JSON format. It will be compressed in a gzip (.gz) container.  *Note: May be null if the export is still in progress or failed.  If present, this URL may only be valid for 1 hour from the time of retrieval. You should avoid persisting this URL somewhere and rather refresh on demand to ensure you do not keep stale URLs.*  # noqa: E501

        :param download_url: The download_url of this OrganizationExportCompact.  # noqa: E501
        :type: str
        """

        self._download_url = download_url

    @property
    def state(self):
        """Gets the state of this OrganizationExportCompact.  # noqa: E501

        The current state of the export.  # noqa: E501

        :return: The state of this OrganizationExportCompact.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this OrganizationExportCompact.

        The current state of the export.  # noqa: E501

        :param state: The state of this OrganizationExportCompact.  # noqa: E501
        :type: str
        """
        allowed_values = ["pending", "started", "finished", "error"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def organization(self):
        """Gets the organization of this OrganizationExportCompact.  # noqa: E501


        :return: The organization of this OrganizationExportCompact.  # noqa: E501
        :rtype: GoalResponseWorkspace
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this OrganizationExportCompact.


        :param organization: The organization of this OrganizationExportCompact.  # noqa: E501
        :type: GoalResponseWorkspace
        """

        self._organization = organization

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrganizationExportCompact, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganizationExportCompact):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
