# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PortfolioResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'color': 'str',
        'created_at': 'datetime',
        'created_by': 'CustomFieldResponsePeopleValue',
        'custom_field_settings': 'list[PortfolioResponseCustomFieldSettings]',
        'current_status_update': 'PortfolioResponseCurrentStatusUpdate',
        'due_on': 'date',
        'custom_fields': 'list[PortfolioResponseCustomFields]',
        'members': 'list[CustomFieldResponsePeopleValue]',
        'owner': 'CustomFieldResponsePeopleValue',
        'start_on': 'date',
        'workspace': 'PortfolioResponseWorkspace',
        'permalink_url': 'str',
        'public': 'bool',
        'project_templates': 'list[JobBaseNewProjectTemplate]'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'color': 'color',
        'created_at': 'created_at',
        'created_by': 'created_by',
        'custom_field_settings': 'custom_field_settings',
        'current_status_update': 'current_status_update',
        'due_on': 'due_on',
        'custom_fields': 'custom_fields',
        'members': 'members',
        'owner': 'owner',
        'start_on': 'start_on',
        'workspace': 'workspace',
        'permalink_url': 'permalink_url',
        'public': 'public',
        'project_templates': 'project_templates'
    }

    def __init__(self, gid=None, resource_type=None, name=None, color=None, created_at=None, created_by=None, custom_field_settings=None, current_status_update=None, due_on=None, custom_fields=None, members=None, owner=None, start_on=None, workspace=None, permalink_url=None, public=None, project_templates=None):  # noqa: E501
        """PortfolioResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._color = None
        self._created_at = None
        self._created_by = None
        self._custom_field_settings = None
        self._current_status_update = None
        self._due_on = None
        self._custom_fields = None
        self._members = None
        self._owner = None
        self._start_on = None
        self._workspace = None
        self._permalink_url = None
        self._public = None
        self._project_templates = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if color is not None:
            self.color = color
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if custom_field_settings is not None:
            self.custom_field_settings = custom_field_settings
        if current_status_update is not None:
            self.current_status_update = current_status_update
        if due_on is not None:
            self.due_on = due_on
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if members is not None:
            self.members = members
        if owner is not None:
            self.owner = owner
        if start_on is not None:
            self.start_on = start_on
        if workspace is not None:
            self.workspace = workspace
        if permalink_url is not None:
            self.permalink_url = permalink_url
        if public is not None:
            self.public = public
        if project_templates is not None:
            self.project_templates = project_templates

    @property
    def gid(self):
        """Gets the gid of this PortfolioResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this PortfolioResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this PortfolioResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this PortfolioResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this PortfolioResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this PortfolioResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this PortfolioResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this PortfolioResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this PortfolioResponse.  # noqa: E501

        The name of the portfolio.  # noqa: E501

        :return: The name of this PortfolioResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PortfolioResponse.

        The name of the portfolio.  # noqa: E501

        :param name: The name of this PortfolioResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def color(self):
        """Gets the color of this PortfolioResponse.  # noqa: E501

        Color of the portfolio.  # noqa: E501

        :return: The color of this PortfolioResponse.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this PortfolioResponse.

        Color of the portfolio.  # noqa: E501

        :param color: The color of this PortfolioResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["dark-pink", "dark-green", "dark-blue", "dark-red", "dark-teal", "dark-brown", "dark-orange", "dark-purple", "dark-warm-gray", "light-pink", "light-green", "light-blue", "light-red", "light-teal", "light-brown", "light-orange", "light-purple", "light-warm-gray"]  # noqa: E501
        if color not in allowed_values:
            raise ValueError(
                "Invalid value for `color` ({0}), must be one of {1}"  # noqa: E501
                .format(color, allowed_values)
            )

        self._color = color

    @property
    def created_at(self):
        """Gets the created_at of this PortfolioResponse.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this PortfolioResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this PortfolioResponse.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this PortfolioResponse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this PortfolioResponse.  # noqa: E501


        :return: The created_by of this PortfolioResponse.  # noqa: E501
        :rtype: CustomFieldResponsePeopleValue
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this PortfolioResponse.


        :param created_by: The created_by of this PortfolioResponse.  # noqa: E501
        :type: CustomFieldResponsePeopleValue
        """

        self._created_by = created_by

    @property
    def custom_field_settings(self):
        """Gets the custom_field_settings of this PortfolioResponse.  # noqa: E501

        Array of custom field settings applied to the portfolio.  # noqa: E501

        :return: The custom_field_settings of this PortfolioResponse.  # noqa: E501
        :rtype: list[PortfolioResponseCustomFieldSettings]
        """
        return self._custom_field_settings

    @custom_field_settings.setter
    def custom_field_settings(self, custom_field_settings):
        """Sets the custom_field_settings of this PortfolioResponse.

        Array of custom field settings applied to the portfolio.  # noqa: E501

        :param custom_field_settings: The custom_field_settings of this PortfolioResponse.  # noqa: E501
        :type: list[PortfolioResponseCustomFieldSettings]
        """

        self._custom_field_settings = custom_field_settings

    @property
    def current_status_update(self):
        """Gets the current_status_update of this PortfolioResponse.  # noqa: E501


        :return: The current_status_update of this PortfolioResponse.  # noqa: E501
        :rtype: PortfolioResponseCurrentStatusUpdate
        """
        return self._current_status_update

    @current_status_update.setter
    def current_status_update(self, current_status_update):
        """Sets the current_status_update of this PortfolioResponse.


        :param current_status_update: The current_status_update of this PortfolioResponse.  # noqa: E501
        :type: PortfolioResponseCurrentStatusUpdate
        """

        self._current_status_update = current_status_update

    @property
    def due_on(self):
        """Gets the due_on of this PortfolioResponse.  # noqa: E501

        The localized day on which this portfolio is due. This takes a date with format YYYY-MM-DD.  # noqa: E501

        :return: The due_on of this PortfolioResponse.  # noqa: E501
        :rtype: date
        """
        return self._due_on

    @due_on.setter
    def due_on(self, due_on):
        """Sets the due_on of this PortfolioResponse.

        The localized day on which this portfolio is due. This takes a date with format YYYY-MM-DD.  # noqa: E501

        :param due_on: The due_on of this PortfolioResponse.  # noqa: E501
        :type: date
        """

        self._due_on = due_on

    @property
    def custom_fields(self):
        """Gets the custom_fields of this PortfolioResponse.  # noqa: E501

        Array of Custom Fields.  # noqa: E501

        :return: The custom_fields of this PortfolioResponse.  # noqa: E501
        :rtype: list[PortfolioResponseCustomFields]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this PortfolioResponse.

        Array of Custom Fields.  # noqa: E501

        :param custom_fields: The custom_fields of this PortfolioResponse.  # noqa: E501
        :type: list[PortfolioResponseCustomFields]
        """

        self._custom_fields = custom_fields

    @property
    def members(self):
        """Gets the members of this PortfolioResponse.  # noqa: E501


        :return: The members of this PortfolioResponse.  # noqa: E501
        :rtype: list[CustomFieldResponsePeopleValue]
        """
        return self._members

    @members.setter
    def members(self, members):
        """Sets the members of this PortfolioResponse.


        :param members: The members of this PortfolioResponse.  # noqa: E501
        :type: list[CustomFieldResponsePeopleValue]
        """

        self._members = members

    @property
    def owner(self):
        """Gets the owner of this PortfolioResponse.  # noqa: E501


        :return: The owner of this PortfolioResponse.  # noqa: E501
        :rtype: CustomFieldResponsePeopleValue
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this PortfolioResponse.


        :param owner: The owner of this PortfolioResponse.  # noqa: E501
        :type: CustomFieldResponsePeopleValue
        """

        self._owner = owner

    @property
    def start_on(self):
        """Gets the start_on of this PortfolioResponse.  # noqa: E501

        The day on which work for this portfolio begins, or null if the portfolio has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*  # noqa: E501

        :return: The start_on of this PortfolioResponse.  # noqa: E501
        :rtype: date
        """
        return self._start_on

    @start_on.setter
    def start_on(self, start_on):
        """Sets the start_on of this PortfolioResponse.

        The day on which work for this portfolio begins, or null if the portfolio has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*  # noqa: E501

        :param start_on: The start_on of this PortfolioResponse.  # noqa: E501
        :type: date
        """

        self._start_on = start_on

    @property
    def workspace(self):
        """Gets the workspace of this PortfolioResponse.  # noqa: E501


        :return: The workspace of this PortfolioResponse.  # noqa: E501
        :rtype: PortfolioResponseWorkspace
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this PortfolioResponse.


        :param workspace: The workspace of this PortfolioResponse.  # noqa: E501
        :type: PortfolioResponseWorkspace
        """

        self._workspace = workspace

    @property
    def permalink_url(self):
        """Gets the permalink_url of this PortfolioResponse.  # noqa: E501

        A url that points directly to the object within Asana.  # noqa: E501

        :return: The permalink_url of this PortfolioResponse.  # noqa: E501
        :rtype: str
        """
        return self._permalink_url

    @permalink_url.setter
    def permalink_url(self, permalink_url):
        """Sets the permalink_url of this PortfolioResponse.

        A url that points directly to the object within Asana.  # noqa: E501

        :param permalink_url: The permalink_url of this PortfolioResponse.  # noqa: E501
        :type: str
        """

        self._permalink_url = permalink_url

    @property
    def public(self):
        """Gets the public of this PortfolioResponse.  # noqa: E501

        True if the portfolio is public to its workspace members.  # noqa: E501

        :return: The public of this PortfolioResponse.  # noqa: E501
        :rtype: bool
        """
        return self._public

    @public.setter
    def public(self, public):
        """Sets the public of this PortfolioResponse.

        True if the portfolio is public to its workspace members.  # noqa: E501

        :param public: The public of this PortfolioResponse.  # noqa: E501
        :type: bool
        """

        self._public = public

    @property
    def project_templates(self):
        """Gets the project_templates of this PortfolioResponse.  # noqa: E501

        Array of project templates that are in the portfolio  # noqa: E501

        :return: The project_templates of this PortfolioResponse.  # noqa: E501
        :rtype: list[JobBaseNewProjectTemplate]
        """
        return self._project_templates

    @project_templates.setter
    def project_templates(self, project_templates):
        """Sets the project_templates of this PortfolioResponse.

        Array of project templates that are in the portfolio  # noqa: E501

        :param project_templates: The project_templates of this PortfolioResponse.  # noqa: E501
        :type: list[JobBaseNewProjectTemplate]
        """

        self._project_templates = project_templates

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PortfolioResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PortfolioResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
