# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectBriefResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'title': 'str',
        'html_text': 'str',
        'text': 'str',
        'permalink_url': 'str',
        'project': 'ProjectBriefResponseProject'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'title': 'title',
        'html_text': 'html_text',
        'text': 'text',
        'permalink_url': 'permalink_url',
        'project': 'project'
    }

    def __init__(self, gid=None, resource_type=None, title=None, html_text=None, text=None, permalink_url=None, project=None):  # noqa: E501
        """ProjectBriefResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._title = None
        self._html_text = None
        self._text = None
        self._permalink_url = None
        self._project = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if title is not None:
            self.title = title
        if html_text is not None:
            self.html_text = html_text
        if text is not None:
            self.text = text
        if permalink_url is not None:
            self.permalink_url = permalink_url
        if project is not None:
            self.project = project

    @property
    def gid(self):
        """Gets the gid of this ProjectBriefResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this ProjectBriefResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this ProjectBriefResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this ProjectBriefResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this ProjectBriefResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this ProjectBriefResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this ProjectBriefResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this ProjectBriefResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def title(self):
        """Gets the title of this ProjectBriefResponse.  # noqa: E501

        The title of the project brief.  # noqa: E501

        :return: The title of this ProjectBriefResponse.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ProjectBriefResponse.

        The title of the project brief.  # noqa: E501

        :param title: The title of this ProjectBriefResponse.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def html_text(self):
        """Gets the html_text of this ProjectBriefResponse.  # noqa: E501

        HTML formatted text for the project brief.  # noqa: E501

        :return: The html_text of this ProjectBriefResponse.  # noqa: E501
        :rtype: str
        """
        return self._html_text

    @html_text.setter
    def html_text(self, html_text):
        """Sets the html_text of this ProjectBriefResponse.

        HTML formatted text for the project brief.  # noqa: E501

        :param html_text: The html_text of this ProjectBriefResponse.  # noqa: E501
        :type: str
        """

        self._html_text = html_text

    @property
    def text(self):
        """Gets the text of this ProjectBriefResponse.  # noqa: E501

        [Opt In](/docs/inputoutput-options). The plain text of the project brief.  # noqa: E501

        :return: The text of this ProjectBriefResponse.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this ProjectBriefResponse.

        [Opt In](/docs/inputoutput-options). The plain text of the project brief.  # noqa: E501

        :param text: The text of this ProjectBriefResponse.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def permalink_url(self):
        """Gets the permalink_url of this ProjectBriefResponse.  # noqa: E501

        A url that points directly to the object within Asana.  # noqa: E501

        :return: The permalink_url of this ProjectBriefResponse.  # noqa: E501
        :rtype: str
        """
        return self._permalink_url

    @permalink_url.setter
    def permalink_url(self, permalink_url):
        """Sets the permalink_url of this ProjectBriefResponse.

        A url that points directly to the object within Asana.  # noqa: E501

        :param permalink_url: The permalink_url of this ProjectBriefResponse.  # noqa: E501
        :type: str
        """

        self._permalink_url = permalink_url

    @property
    def project(self):
        """Gets the project of this ProjectBriefResponse.  # noqa: E501


        :return: The project of this ProjectBriefResponse.  # noqa: E501
        :rtype: ProjectBriefResponseProject
        """
        return self._project

    @project.setter
    def project(self, project):
        """Sets the project of this ProjectBriefResponse.


        :param project: The project of this ProjectBriefResponse.  # noqa: E501
        :type: ProjectBriefResponseProject
        """

        self._project = project

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectBriefResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectBriefResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
