# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectDuplicateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'team': 'str',
        'include': 'str',
        'schedule_dates': 'ProjectDuplicateRequestScheduleDates'
    }

    attribute_map = {
        'name': 'name',
        'team': 'team',
        'include': 'include',
        'schedule_dates': 'schedule_dates'
    }

    def __init__(self, name=None, team=None, include=None, schedule_dates=None):  # noqa: E501
        """ProjectDuplicateRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._team = None
        self._include = None
        self._schedule_dates = None
        self.discriminator = None
        self.name = name
        if team is not None:
            self.team = team
        if include is not None:
            self.include = include
        if schedule_dates is not None:
            self.schedule_dates = schedule_dates

    @property
    def name(self):
        """Gets the name of this ProjectDuplicateRequest.  # noqa: E501

        The name of the new project.  # noqa: E501

        :return: The name of this ProjectDuplicateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectDuplicateRequest.

        The name of the new project.  # noqa: E501

        :param name: The name of this ProjectDuplicateRequest.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def team(self):
        """Gets the team of this ProjectDuplicateRequest.  # noqa: E501

        Sets the team of the new project. If team is not defined, the new project will be in the same team as the the original project.  # noqa: E501

        :return: The team of this ProjectDuplicateRequest.  # noqa: E501
        :rtype: str
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this ProjectDuplicateRequest.

        Sets the team of the new project. If team is not defined, the new project will be in the same team as the the original project.  # noqa: E501

        :param team: The team of this ProjectDuplicateRequest.  # noqa: E501
        :type: str
        """

        self._team = team

    @property
    def include(self):
        """Gets the include of this ProjectDuplicateRequest.  # noqa: E501

        A comma-separated list of elements that will be duplicated to the new project. Tasks are always included. ##### Fields - forms - members - notes - task_assignee - task_attachments - task_dates - task_dependencies - task_followers - task_notes - task_projects - task_subtasks - task_tags  # noqa: E501

        :return: The include of this ProjectDuplicateRequest.  # noqa: E501
        :rtype: str
        """
        return self._include

    @include.setter
    def include(self, include):
        """Sets the include of this ProjectDuplicateRequest.

        A comma-separated list of elements that will be duplicated to the new project. Tasks are always included. ##### Fields - forms - members - notes - task_assignee - task_attachments - task_dates - task_dependencies - task_followers - task_notes - task_projects - task_subtasks - task_tags  # noqa: E501

        :param include: The include of this ProjectDuplicateRequest.  # noqa: E501
        :type: str
        """

        self._include = include

    @property
    def schedule_dates(self):
        """Gets the schedule_dates of this ProjectDuplicateRequest.  # noqa: E501


        :return: The schedule_dates of this ProjectDuplicateRequest.  # noqa: E501
        :rtype: ProjectDuplicateRequestScheduleDates
        """
        return self._schedule_dates

    @schedule_dates.setter
    def schedule_dates(self, schedule_dates):
        """Sets the schedule_dates of this ProjectDuplicateRequest.


        :param schedule_dates: The schedule_dates of this ProjectDuplicateRequest.  # noqa: E501
        :type: ProjectDuplicateRequestScheduleDates
        """

        self._schedule_dates = schedule_dates

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectDuplicateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectDuplicateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
