# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'archived': 'bool',
        'color': 'str',
        'created_at': 'datetime',
        'current_status': 'ProjectBaseCurrentStatus',
        'current_status_update': 'ProjectBaseCurrentStatusUpdate',
        'custom_field_settings': 'list[PortfolioResponseCustomFieldSettings]',
        'default_view': 'str',
        'due_date': 'date',
        'due_on': 'date',
        'html_notes': 'str',
        'members': 'list[CustomFieldResponsePeopleValue]',
        'modified_at': 'datetime',
        'notes': 'str',
        'public': 'bool',
        'start_on': 'date',
        'default_access_level': 'str',
        'minimum_access_level_for_customization': 'str',
        'minimum_access_level_for_sharing': 'str',
        'custom_fields': 'list[PortfolioResponseCustomFields]',
        'completed': 'bool',
        'completed_at': 'datetime',
        'completed_by': 'ProjectResponseCompletedBy',
        'followers': 'list[CustomFieldResponsePeopleValue]',
        'owner': 'AllOfProjectResponseOwner',
        'team': 'ProjectResponseTeam',
        'icon': 'str',
        'permalink_url': 'str',
        'project_brief': 'ProjectResponseProjectBrief',
        'created_from_template': 'ProjectResponseCreatedFromTemplate',
        'workspace': 'ProjectResponseWorkspace'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'archived': 'archived',
        'color': 'color',
        'created_at': 'created_at',
        'current_status': 'current_status',
        'current_status_update': 'current_status_update',
        'custom_field_settings': 'custom_field_settings',
        'default_view': 'default_view',
        'due_date': 'due_date',
        'due_on': 'due_on',
        'html_notes': 'html_notes',
        'members': 'members',
        'modified_at': 'modified_at',
        'notes': 'notes',
        'public': 'public',
        'start_on': 'start_on',
        'default_access_level': 'default_access_level',
        'minimum_access_level_for_customization': 'minimum_access_level_for_customization',
        'minimum_access_level_for_sharing': 'minimum_access_level_for_sharing',
        'custom_fields': 'custom_fields',
        'completed': 'completed',
        'completed_at': 'completed_at',
        'completed_by': 'completed_by',
        'followers': 'followers',
        'owner': 'owner',
        'team': 'team',
        'icon': 'icon',
        'permalink_url': 'permalink_url',
        'project_brief': 'project_brief',
        'created_from_template': 'created_from_template',
        'workspace': 'workspace'
    }

    def __init__(self, gid=None, resource_type=None, name=None, archived=None, color=None, created_at=None, current_status=None, current_status_update=None, custom_field_settings=None, default_view=None, due_date=None, due_on=None, html_notes=None, members=None, modified_at=None, notes=None, public=None, start_on=None, default_access_level=None, minimum_access_level_for_customization=None, minimum_access_level_for_sharing=None, custom_fields=None, completed=None, completed_at=None, completed_by=None, followers=None, owner=None, team=None, icon=None, permalink_url=None, project_brief=None, created_from_template=None, workspace=None):  # noqa: E501
        """ProjectResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._archived = None
        self._color = None
        self._created_at = None
        self._current_status = None
        self._current_status_update = None
        self._custom_field_settings = None
        self._default_view = None
        self._due_date = None
        self._due_on = None
        self._html_notes = None
        self._members = None
        self._modified_at = None
        self._notes = None
        self._public = None
        self._start_on = None
        self._default_access_level = None
        self._minimum_access_level_for_customization = None
        self._minimum_access_level_for_sharing = None
        self._custom_fields = None
        self._completed = None
        self._completed_at = None
        self._completed_by = None
        self._followers = None
        self._owner = None
        self._team = None
        self._icon = None
        self._permalink_url = None
        self._project_brief = None
        self._created_from_template = None
        self._workspace = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if archived is not None:
            self.archived = archived
        if color is not None:
            self.color = color
        if created_at is not None:
            self.created_at = created_at
        if current_status is not None:
            self.current_status = current_status
        if current_status_update is not None:
            self.current_status_update = current_status_update
        if custom_field_settings is not None:
            self.custom_field_settings = custom_field_settings
        if default_view is not None:
            self.default_view = default_view
        if due_date is not None:
            self.due_date = due_date
        if due_on is not None:
            self.due_on = due_on
        if html_notes is not None:
            self.html_notes = html_notes
        if members is not None:
            self.members = members
        if modified_at is not None:
            self.modified_at = modified_at
        if notes is not None:
            self.notes = notes
        if public is not None:
            self.public = public
        if start_on is not None:
            self.start_on = start_on
        if default_access_level is not None:
            self.default_access_level = default_access_level
        if minimum_access_level_for_customization is not None:
            self.minimum_access_level_for_customization = minimum_access_level_for_customization
        if minimum_access_level_for_sharing is not None:
            self.minimum_access_level_for_sharing = minimum_access_level_for_sharing
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if completed is not None:
            self.completed = completed
        if completed_at is not None:
            self.completed_at = completed_at
        if completed_by is not None:
            self.completed_by = completed_by
        if followers is not None:
            self.followers = followers
        if owner is not None:
            self.owner = owner
        if team is not None:
            self.team = team
        if icon is not None:
            self.icon = icon
        if permalink_url is not None:
            self.permalink_url = permalink_url
        if project_brief is not None:
            self.project_brief = project_brief
        if created_from_template is not None:
            self.created_from_template = created_from_template
        if workspace is not None:
            self.workspace = workspace

    @property
    def gid(self):
        """Gets the gid of this ProjectResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this ProjectResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this ProjectResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this ProjectResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this ProjectResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this ProjectResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this ProjectResponse.  # noqa: E501

        Name of the project. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.  # noqa: E501

        :return: The name of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectResponse.

        Name of the project. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.  # noqa: E501

        :param name: The name of this ProjectResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def archived(self):
        """Gets the archived of this ProjectResponse.  # noqa: E501

        True if the project is archived, false if not. Archived projects do not show in the UI by default and may be treated differently for queries.  # noqa: E501

        :return: The archived of this ProjectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._archived

    @archived.setter
    def archived(self, archived):
        """Sets the archived of this ProjectResponse.

        True if the project is archived, false if not. Archived projects do not show in the UI by default and may be treated differently for queries.  # noqa: E501

        :param archived: The archived of this ProjectResponse.  # noqa: E501
        :type: bool
        """

        self._archived = archived

    @property
    def color(self):
        """Gets the color of this ProjectResponse.  # noqa: E501

        Color of the project.  # noqa: E501

        :return: The color of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this ProjectResponse.

        Color of the project.  # noqa: E501

        :param color: The color of this ProjectResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["dark-pink", "dark-green", "dark-blue", "dark-red", "dark-teal", "dark-brown", "dark-orange", "dark-purple", "dark-warm-gray", "light-pink", "light-green", "light-blue", "light-red", "light-teal", "light-brown", "light-orange", "light-purple", "light-warm-gray", "none", ""]  # noqa: E501
        if color not in allowed_values:
            raise ValueError(
                "Invalid value for `color` ({0}), must be one of {1}"  # noqa: E501
                .format(color, allowed_values)
            )

        self._color = color

    @property
    def created_at(self):
        """Gets the created_at of this ProjectResponse.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this ProjectResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ProjectResponse.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this ProjectResponse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def current_status(self):
        """Gets the current_status of this ProjectResponse.  # noqa: E501


        :return: The current_status of this ProjectResponse.  # noqa: E501
        :rtype: ProjectBaseCurrentStatus
        """
        return self._current_status

    @current_status.setter
    def current_status(self, current_status):
        """Sets the current_status of this ProjectResponse.


        :param current_status: The current_status of this ProjectResponse.  # noqa: E501
        :type: ProjectBaseCurrentStatus
        """

        self._current_status = current_status

    @property
    def current_status_update(self):
        """Gets the current_status_update of this ProjectResponse.  # noqa: E501


        :return: The current_status_update of this ProjectResponse.  # noqa: E501
        :rtype: ProjectBaseCurrentStatusUpdate
        """
        return self._current_status_update

    @current_status_update.setter
    def current_status_update(self, current_status_update):
        """Sets the current_status_update of this ProjectResponse.


        :param current_status_update: The current_status_update of this ProjectResponse.  # noqa: E501
        :type: ProjectBaseCurrentStatusUpdate
        """

        self._current_status_update = current_status_update

    @property
    def custom_field_settings(self):
        """Gets the custom_field_settings of this ProjectResponse.  # noqa: E501

        Array of Custom Field Settings (in compact form).  # noqa: E501

        :return: The custom_field_settings of this ProjectResponse.  # noqa: E501
        :rtype: list[PortfolioResponseCustomFieldSettings]
        """
        return self._custom_field_settings

    @custom_field_settings.setter
    def custom_field_settings(self, custom_field_settings):
        """Sets the custom_field_settings of this ProjectResponse.

        Array of Custom Field Settings (in compact form).  # noqa: E501

        :param custom_field_settings: The custom_field_settings of this ProjectResponse.  # noqa: E501
        :type: list[PortfolioResponseCustomFieldSettings]
        """

        self._custom_field_settings = custom_field_settings

    @property
    def default_view(self):
        """Gets the default_view of this ProjectResponse.  # noqa: E501

        The default view (list, board, calendar, or timeline) of a project.  # noqa: E501

        :return: The default_view of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._default_view

    @default_view.setter
    def default_view(self, default_view):
        """Sets the default_view of this ProjectResponse.

        The default view (list, board, calendar, or timeline) of a project.  # noqa: E501

        :param default_view: The default_view of this ProjectResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["list", "board", "calendar", "timeline"]  # noqa: E501
        if default_view not in allowed_values:
            raise ValueError(
                "Invalid value for `default_view` ({0}), must be one of {1}"  # noqa: E501
                .format(default_view, allowed_values)
            )

        self._default_view = default_view

    @property
    def due_date(self):
        """Gets the due_date of this ProjectResponse.  # noqa: E501

        *Deprecated: new integrations should prefer the `due_on` field.*  # noqa: E501

        :return: The due_date of this ProjectResponse.  # noqa: E501
        :rtype: date
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this ProjectResponse.

        *Deprecated: new integrations should prefer the `due_on` field.*  # noqa: E501

        :param due_date: The due_date of this ProjectResponse.  # noqa: E501
        :type: date
        """

        self._due_date = due_date

    @property
    def due_on(self):
        """Gets the due_on of this ProjectResponse.  # noqa: E501

        The day on which this project is due. This takes a date with format YYYY-MM-DD.  # noqa: E501

        :return: The due_on of this ProjectResponse.  # noqa: E501
        :rtype: date
        """
        return self._due_on

    @due_on.setter
    def due_on(self, due_on):
        """Sets the due_on of this ProjectResponse.

        The day on which this project is due. This takes a date with format YYYY-MM-DD.  # noqa: E501

        :param due_on: The due_on of this ProjectResponse.  # noqa: E501
        :type: date
        """

        self._due_on = due_on

    @property
    def html_notes(self):
        """Gets the html_notes of this ProjectResponse.  # noqa: E501

        [Opt In](/docs/inputoutput-options). The notes of the project with formatting as HTML.  # noqa: E501

        :return: The html_notes of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._html_notes

    @html_notes.setter
    def html_notes(self, html_notes):
        """Sets the html_notes of this ProjectResponse.

        [Opt In](/docs/inputoutput-options). The notes of the project with formatting as HTML.  # noqa: E501

        :param html_notes: The html_notes of this ProjectResponse.  # noqa: E501
        :type: str
        """

        self._html_notes = html_notes

    @property
    def members(self):
        """Gets the members of this ProjectResponse.  # noqa: E501

        Array of users who are members of this project.  # noqa: E501

        :return: The members of this ProjectResponse.  # noqa: E501
        :rtype: list[CustomFieldResponsePeopleValue]
        """
        return self._members

    @members.setter
    def members(self, members):
        """Sets the members of this ProjectResponse.

        Array of users who are members of this project.  # noqa: E501

        :param members: The members of this ProjectResponse.  # noqa: E501
        :type: list[CustomFieldResponsePeopleValue]
        """

        self._members = members

    @property
    def modified_at(self):
        """Gets the modified_at of this ProjectResponse.  # noqa: E501

        The time at which this project was last modified. *Note: This does not currently reflect any changes in associations such as tasks or comments that may have been added or removed from the project.*  # noqa: E501

        :return: The modified_at of this ProjectResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this ProjectResponse.

        The time at which this project was last modified. *Note: This does not currently reflect any changes in associations such as tasks or comments that may have been added or removed from the project.*  # noqa: E501

        :param modified_at: The modified_at of this ProjectResponse.  # noqa: E501
        :type: datetime
        """

        self._modified_at = modified_at

    @property
    def notes(self):
        """Gets the notes of this ProjectResponse.  # noqa: E501

        Free-form textual information associated with the project (ie., its description).  # noqa: E501

        :return: The notes of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this ProjectResponse.

        Free-form textual information associated with the project (ie., its description).  # noqa: E501

        :param notes: The notes of this ProjectResponse.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def public(self):
        """Gets the public of this ProjectResponse.  # noqa: E501

        True if the project is public to its team.  # noqa: E501

        :return: The public of this ProjectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._public

    @public.setter
    def public(self, public):
        """Sets the public of this ProjectResponse.

        True if the project is public to its team.  # noqa: E501

        :param public: The public of this ProjectResponse.  # noqa: E501
        :type: bool
        """

        self._public = public

    @property
    def start_on(self):
        """Gets the start_on of this ProjectResponse.  # noqa: E501

        The day on which work for this project begins, or null if the project has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` or `due_at` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*  # noqa: E501

        :return: The start_on of this ProjectResponse.  # noqa: E501
        :rtype: date
        """
        return self._start_on

    @start_on.setter
    def start_on(self, start_on):
        """Sets the start_on of this ProjectResponse.

        The day on which work for this project begins, or null if the project has no start date. This takes a date with `YYYY-MM-DD` format. *Note: `due_on` or `due_at` must be present in the request when setting or unsetting the `start_on` parameter. Additionally, `start_on` and `due_on` cannot be the same date.*  # noqa: E501

        :param start_on: The start_on of this ProjectResponse.  # noqa: E501
        :type: date
        """

        self._start_on = start_on

    @property
    def default_access_level(self):
        """Gets the default_access_level of this ProjectResponse.  # noqa: E501

        The default access for users or teams who join or are added as members to the project.  # noqa: E501

        :return: The default_access_level of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._default_access_level

    @default_access_level.setter
    def default_access_level(self, default_access_level):
        """Sets the default_access_level of this ProjectResponse.

        The default access for users or teams who join or are added as members to the project.  # noqa: E501

        :param default_access_level: The default_access_level of this ProjectResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["admin", "editor", "commenter", "viewer"]  # noqa: E501
        if default_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `default_access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(default_access_level, allowed_values)
            )

        self._default_access_level = default_access_level

    @property
    def minimum_access_level_for_customization(self):
        """Gets the minimum_access_level_for_customization of this ProjectResponse.  # noqa: E501

        The minimum access level needed for project members to modify this project's workflow and appearance.  # noqa: E501

        :return: The minimum_access_level_for_customization of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._minimum_access_level_for_customization

    @minimum_access_level_for_customization.setter
    def minimum_access_level_for_customization(self, minimum_access_level_for_customization):
        """Sets the minimum_access_level_for_customization of this ProjectResponse.

        The minimum access level needed for project members to modify this project's workflow and appearance.  # noqa: E501

        :param minimum_access_level_for_customization: The minimum_access_level_for_customization of this ProjectResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["admin", "editor"]  # noqa: E501
        if minimum_access_level_for_customization not in allowed_values:
            raise ValueError(
                "Invalid value for `minimum_access_level_for_customization` ({0}), must be one of {1}"  # noqa: E501
                .format(minimum_access_level_for_customization, allowed_values)
            )

        self._minimum_access_level_for_customization = minimum_access_level_for_customization

    @property
    def minimum_access_level_for_sharing(self):
        """Gets the minimum_access_level_for_sharing of this ProjectResponse.  # noqa: E501

        The minimum access level needed for project members to share the project and manage project memberships.  # noqa: E501

        :return: The minimum_access_level_for_sharing of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._minimum_access_level_for_sharing

    @minimum_access_level_for_sharing.setter
    def minimum_access_level_for_sharing(self, minimum_access_level_for_sharing):
        """Sets the minimum_access_level_for_sharing of this ProjectResponse.

        The minimum access level needed for project members to share the project and manage project memberships.  # noqa: E501

        :param minimum_access_level_for_sharing: The minimum_access_level_for_sharing of this ProjectResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["admin", "editor"]  # noqa: E501
        if minimum_access_level_for_sharing not in allowed_values:
            raise ValueError(
                "Invalid value for `minimum_access_level_for_sharing` ({0}), must be one of {1}"  # noqa: E501
                .format(minimum_access_level_for_sharing, allowed_values)
            )

        self._minimum_access_level_for_sharing = minimum_access_level_for_sharing

    @property
    def custom_fields(self):
        """Gets the custom_fields of this ProjectResponse.  # noqa: E501

        Array of Custom Fields.  # noqa: E501

        :return: The custom_fields of this ProjectResponse.  # noqa: E501
        :rtype: list[PortfolioResponseCustomFields]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this ProjectResponse.

        Array of Custom Fields.  # noqa: E501

        :param custom_fields: The custom_fields of this ProjectResponse.  # noqa: E501
        :type: list[PortfolioResponseCustomFields]
        """

        self._custom_fields = custom_fields

    @property
    def completed(self):
        """Gets the completed of this ProjectResponse.  # noqa: E501

        True if the project is currently marked complete, false if not.  # noqa: E501

        :return: The completed of this ProjectResponse.  # noqa: E501
        :rtype: bool
        """
        return self._completed

    @completed.setter
    def completed(self, completed):
        """Sets the completed of this ProjectResponse.

        True if the project is currently marked complete, false if not.  # noqa: E501

        :param completed: The completed of this ProjectResponse.  # noqa: E501
        :type: bool
        """

        self._completed = completed

    @property
    def completed_at(self):
        """Gets the completed_at of this ProjectResponse.  # noqa: E501

        The time at which this project was completed, or null if the project is not completed.  # noqa: E501

        :return: The completed_at of this ProjectResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._completed_at

    @completed_at.setter
    def completed_at(self, completed_at):
        """Sets the completed_at of this ProjectResponse.

        The time at which this project was completed, or null if the project is not completed.  # noqa: E501

        :param completed_at: The completed_at of this ProjectResponse.  # noqa: E501
        :type: datetime
        """

        self._completed_at = completed_at

    @property
    def completed_by(self):
        """Gets the completed_by of this ProjectResponse.  # noqa: E501


        :return: The completed_by of this ProjectResponse.  # noqa: E501
        :rtype: ProjectResponseCompletedBy
        """
        return self._completed_by

    @completed_by.setter
    def completed_by(self, completed_by):
        """Sets the completed_by of this ProjectResponse.


        :param completed_by: The completed_by of this ProjectResponse.  # noqa: E501
        :type: ProjectResponseCompletedBy
        """

        self._completed_by = completed_by

    @property
    def followers(self):
        """Gets the followers of this ProjectResponse.  # noqa: E501

        Array of users following this project. Followers are a subset of members who have opted in to receive \"tasks added\" notifications for a project.  # noqa: E501

        :return: The followers of this ProjectResponse.  # noqa: E501
        :rtype: list[CustomFieldResponsePeopleValue]
        """
        return self._followers

    @followers.setter
    def followers(self, followers):
        """Sets the followers of this ProjectResponse.

        Array of users following this project. Followers are a subset of members who have opted in to receive \"tasks added\" notifications for a project.  # noqa: E501

        :param followers: The followers of this ProjectResponse.  # noqa: E501
        :type: list[CustomFieldResponsePeopleValue]
        """

        self._followers = followers

    @property
    def owner(self):
        """Gets the owner of this ProjectResponse.  # noqa: E501

        The current owner of the project, may be null.  # noqa: E501

        :return: The owner of this ProjectResponse.  # noqa: E501
        :rtype: AllOfProjectResponseOwner
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this ProjectResponse.

        The current owner of the project, may be null.  # noqa: E501

        :param owner: The owner of this ProjectResponse.  # noqa: E501
        :type: AllOfProjectResponseOwner
        """

        self._owner = owner

    @property
    def team(self):
        """Gets the team of this ProjectResponse.  # noqa: E501


        :return: The team of this ProjectResponse.  # noqa: E501
        :rtype: ProjectResponseTeam
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this ProjectResponse.


        :param team: The team of this ProjectResponse.  # noqa: E501
        :type: ProjectResponseTeam
        """

        self._team = team

    @property
    def icon(self):
        """Gets the icon of this ProjectResponse.  # noqa: E501

        The icon for a project.  # noqa: E501

        :return: The icon of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """Sets the icon of this ProjectResponse.

        The icon for a project.  # noqa: E501

        :param icon: The icon of this ProjectResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["list", "board", "timeline", "calendar", "rocket", "people", "graph", "star", "bug", "light_bulb", "globe", "gear", "notebook", "computer", "check", "target", "html", "megaphone", "chat_bubbles", "briefcase", "page_layout", "mountain_flag", "puzzle", "presentation", "line_and_symbols", "speed_dial", "ribbon", "shoe", "shopping_basket", "map", "ticket", "coins"]  # noqa: E501
        if icon not in allowed_values:
            raise ValueError(
                "Invalid value for `icon` ({0}), must be one of {1}"  # noqa: E501
                .format(icon, allowed_values)
            )

        self._icon = icon

    @property
    def permalink_url(self):
        """Gets the permalink_url of this ProjectResponse.  # noqa: E501

        A url that points directly to the object within Asana.  # noqa: E501

        :return: The permalink_url of this ProjectResponse.  # noqa: E501
        :rtype: str
        """
        return self._permalink_url

    @permalink_url.setter
    def permalink_url(self, permalink_url):
        """Sets the permalink_url of this ProjectResponse.

        A url that points directly to the object within Asana.  # noqa: E501

        :param permalink_url: The permalink_url of this ProjectResponse.  # noqa: E501
        :type: str
        """

        self._permalink_url = permalink_url

    @property
    def project_brief(self):
        """Gets the project_brief of this ProjectResponse.  # noqa: E501


        :return: The project_brief of this ProjectResponse.  # noqa: E501
        :rtype: ProjectResponseProjectBrief
        """
        return self._project_brief

    @project_brief.setter
    def project_brief(self, project_brief):
        """Sets the project_brief of this ProjectResponse.


        :param project_brief: The project_brief of this ProjectResponse.  # noqa: E501
        :type: ProjectResponseProjectBrief
        """

        self._project_brief = project_brief

    @property
    def created_from_template(self):
        """Gets the created_from_template of this ProjectResponse.  # noqa: E501


        :return: The created_from_template of this ProjectResponse.  # noqa: E501
        :rtype: ProjectResponseCreatedFromTemplate
        """
        return self._created_from_template

    @created_from_template.setter
    def created_from_template(self, created_from_template):
        """Sets the created_from_template of this ProjectResponse.


        :param created_from_template: The created_from_template of this ProjectResponse.  # noqa: E501
        :type: ProjectResponseCreatedFromTemplate
        """

        self._created_from_template = created_from_template

    @property
    def workspace(self):
        """Gets the workspace of this ProjectResponse.  # noqa: E501


        :return: The workspace of this ProjectResponse.  # noqa: E501
        :rtype: ProjectResponseWorkspace
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this ProjectResponse.


        :param workspace: The workspace of this ProjectResponse.  # noqa: E501
        :type: ProjectResponseWorkspace
        """

        self._workspace = workspace

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
