# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectSaveAsTemplateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'team': 'str',
        'workspace': 'str',
        'public': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'team': 'team',
        'workspace': 'workspace',
        'public': 'public'
    }

    def __init__(self, name=None, team=None, workspace=None, public=None):  # noqa: E501
        """ProjectSaveAsTemplateRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._team = None
        self._workspace = None
        self._public = None
        self.discriminator = None
        self.name = name
        if team is not None:
            self.team = team
        if workspace is not None:
            self.workspace = workspace
        self.public = public

    @property
    def name(self):
        """Gets the name of this ProjectSaveAsTemplateRequest.  # noqa: E501

        The name of the new project template.  # noqa: E501

        :return: The name of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectSaveAsTemplateRequest.

        The name of the new project template.  # noqa: E501

        :param name: The name of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def team(self):
        """Gets the team of this ProjectSaveAsTemplateRequest.  # noqa: E501

        Sets the team of the new project template. If the project exists in an organization, specify team and not workspace.  # noqa: E501

        :return: The team of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :rtype: str
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this ProjectSaveAsTemplateRequest.

        Sets the team of the new project template. If the project exists in an organization, specify team and not workspace.  # noqa: E501

        :param team: The team of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :type: str
        """

        self._team = team

    @property
    def workspace(self):
        """Gets the workspace of this ProjectSaveAsTemplateRequest.  # noqa: E501

        Sets the workspace of the new project template. Only specify workspace if the project exists in a workspace.  # noqa: E501

        :return: The workspace of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :rtype: str
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this ProjectSaveAsTemplateRequest.

        Sets the workspace of the new project template. Only specify workspace if the project exists in a workspace.  # noqa: E501

        :param workspace: The workspace of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :type: str
        """

        self._workspace = workspace

    @property
    def public(self):
        """Gets the public of this ProjectSaveAsTemplateRequest.  # noqa: E501

        Sets the project template to public to its team.  # noqa: E501

        :return: The public of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._public

    @public.setter
    def public(self, public):
        """Sets the public of this ProjectSaveAsTemplateRequest.

        Sets the project template to public to its team.  # noqa: E501

        :param public: The public of this ProjectSaveAsTemplateRequest.  # noqa: E501
        :type: bool
        """
        if public is None:
            raise ValueError("Invalid value for `public`, must not be `None`")  # noqa: E501

        self._public = public

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectSaveAsTemplateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectSaveAsTemplateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
