# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectTemplateInstantiateProjectRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'team': 'str',
        'public': 'bool',
        'is_strict': 'bool',
        'requested_dates': 'list[ProjectTemplateInstantiateProjectRequestRequestedDates]',
        'requested_roles': 'list[ProjectTemplateInstantiateProjectRequestRequestedRoles]'
    }

    attribute_map = {
        'name': 'name',
        'team': 'team',
        'public': 'public',
        'is_strict': 'is_strict',
        'requested_dates': 'requested_dates',
        'requested_roles': 'requested_roles'
    }

    def __init__(self, name=None, team=None, public=None, is_strict=None, requested_dates=None, requested_roles=None):  # noqa: E501
        """ProjectTemplateInstantiateProjectRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._team = None
        self._public = None
        self._is_strict = None
        self._requested_dates = None
        self._requested_roles = None
        self.discriminator = None
        self.name = name
        if team is not None:
            self.team = team
        if public is not None:
            self.public = public
        if is_strict is not None:
            self.is_strict = is_strict
        if requested_dates is not None:
            self.requested_dates = requested_dates
        if requested_roles is not None:
            self.requested_roles = requested_roles

    @property
    def name(self):
        """Gets the name of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501

        The name of the new project.  # noqa: E501

        :return: The name of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectTemplateInstantiateProjectRequest.

        The name of the new project.  # noqa: E501

        :param name: The name of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def team(self):
        """Gets the team of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501

        *Optional*. Sets the team of the new project. If the project template exists in an _organization_, you may specify a value for `team`. If no value is provided then it defaults to the same team as the project template.  # noqa: E501

        :return: The team of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :rtype: str
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this ProjectTemplateInstantiateProjectRequest.

        *Optional*. Sets the team of the new project. If the project template exists in an _organization_, you may specify a value for `team`. If no value is provided then it defaults to the same team as the project template.  # noqa: E501

        :param team: The team of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :type: str
        """

        self._team = team

    @property
    def public(self):
        """Gets the public of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501

        Sets the project to public to its team.  # noqa: E501

        :return: The public of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :rtype: bool
        """
        return self._public

    @public.setter
    def public(self, public):
        """Sets the public of this ProjectTemplateInstantiateProjectRequest.

        Sets the project to public to its team.  # noqa: E501

        :param public: The public of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :type: bool
        """

        self._public = public

    @property
    def is_strict(self):
        """Gets the is_strict of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501

        *Optional*. If set to `true`, the endpoint returns an \"Unprocessable Entity\" error if you fail to provide a calendar date value for any date variable. If set to `false`, a default date is used for each unfulfilled date variable (e.g., the current date is used as the Start Date of a project).  # noqa: E501

        :return: The is_strict of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_strict

    @is_strict.setter
    def is_strict(self, is_strict):
        """Sets the is_strict of this ProjectTemplateInstantiateProjectRequest.

        *Optional*. If set to `true`, the endpoint returns an \"Unprocessable Entity\" error if you fail to provide a calendar date value for any date variable. If set to `false`, a default date is used for each unfulfilled date variable (e.g., the current date is used as the Start Date of a project).  # noqa: E501

        :param is_strict: The is_strict of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :type: bool
        """

        self._is_strict = is_strict

    @property
    def requested_dates(self):
        """Gets the requested_dates of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501

        Array of mappings of date variables to calendar dates.  # noqa: E501

        :return: The requested_dates of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :rtype: list[ProjectTemplateInstantiateProjectRequestRequestedDates]
        """
        return self._requested_dates

    @requested_dates.setter
    def requested_dates(self, requested_dates):
        """Sets the requested_dates of this ProjectTemplateInstantiateProjectRequest.

        Array of mappings of date variables to calendar dates.  # noqa: E501

        :param requested_dates: The requested_dates of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :type: list[ProjectTemplateInstantiateProjectRequestRequestedDates]
        """

        self._requested_dates = requested_dates

    @property
    def requested_roles(self):
        """Gets the requested_roles of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501

        Array of mappings of template roles to user ids  # noqa: E501

        :return: The requested_roles of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :rtype: list[ProjectTemplateInstantiateProjectRequestRequestedRoles]
        """
        return self._requested_roles

    @requested_roles.setter
    def requested_roles(self, requested_roles):
        """Sets the requested_roles of this ProjectTemplateInstantiateProjectRequest.

        Array of mappings of template roles to user ids  # noqa: E501

        :param requested_roles: The requested_roles of this ProjectTemplateInstantiateProjectRequest.  # noqa: E501
        :type: list[ProjectTemplateInstantiateProjectRequestRequestedRoles]
        """

        self._requested_roles = requested_roles

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectTemplateInstantiateProjectRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectTemplateInstantiateProjectRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
