# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RuleTriggerRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource': 'str',
        'action_data': 'dict(str, object)'
    }

    attribute_map = {
        'resource': 'resource',
        'action_data': 'action_data'
    }

    def __init__(self, resource=None, action_data=None):  # noqa: E501
        """RuleTriggerRequest - a model defined in Swagger"""  # noqa: E501
        self._resource = None
        self._action_data = None
        self.discriminator = None
        self.resource = resource
        self.action_data = action_data

    @property
    def resource(self):
        """Gets the resource of this RuleTriggerRequest.  # noqa: E501

        The ID of the resource. For the duration of the beta, this resource is always a task, and this task must exist in the project in which the rule is created.  # noqa: E501

        :return: The resource of this RuleTriggerRequest.  # noqa: E501
        :rtype: str
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this RuleTriggerRequest.

        The ID of the resource. For the duration of the beta, this resource is always a task, and this task must exist in the project in which the rule is created.  # noqa: E501

        :param resource: The resource of this RuleTriggerRequest.  # noqa: E501
        :type: str
        """
        if resource is None:
            raise ValueError("Invalid value for `resource`, must not be `None`")  # noqa: E501

        self._resource = resource

    @property
    def action_data(self):
        """Gets the action_data of this RuleTriggerRequest.  # noqa: E501

        The dynamic keys and values of the request. These fields are intended to be used in the action for the rule associated with this trigger.  # noqa: E501

        :return: The action_data of this RuleTriggerRequest.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._action_data

    @action_data.setter
    def action_data(self, action_data):
        """Sets the action_data of this RuleTriggerRequest.

        The dynamic keys and values of the request. These fields are intended to be used in the action for the rule associated with this trigger.  # noqa: E501

        :param action_data: The action_data of this RuleTriggerRequest.  # noqa: E501
        :type: dict(str, object)
        """
        if action_data is None:
            raise ValueError("Invalid value for `action_data`, must not be `None`")  # noqa: E501

        self._action_data = action_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RuleTriggerRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RuleTriggerRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
