# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SectionRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'insert_before': 'str',
        'insert_after': 'str'
    }

    attribute_map = {
        'name': 'name',
        'insert_before': 'insert_before',
        'insert_after': 'insert_after'
    }

    def __init__(self, name=None, insert_before=None, insert_after=None):  # noqa: E501
        """SectionRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._insert_before = None
        self._insert_after = None
        self.discriminator = None
        self.name = name
        if insert_before is not None:
            self.insert_before = insert_before
        if insert_after is not None:
            self.insert_after = insert_after

    @property
    def name(self):
        """Gets the name of this SectionRequest.  # noqa: E501

        The text to be displayed as the section name. This cannot be an empty string.  # noqa: E501

        :return: The name of this SectionRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SectionRequest.

        The text to be displayed as the section name. This cannot be an empty string.  # noqa: E501

        :param name: The name of this SectionRequest.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def insert_before(self):
        """Gets the insert_before of this SectionRequest.  # noqa: E501

        An existing section within this project before which the added section should be inserted. Cannot be provided together with insert_after.  # noqa: E501

        :return: The insert_before of this SectionRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_before

    @insert_before.setter
    def insert_before(self, insert_before):
        """Sets the insert_before of this SectionRequest.

        An existing section within this project before which the added section should be inserted. Cannot be provided together with insert_after.  # noqa: E501

        :param insert_before: The insert_before of this SectionRequest.  # noqa: E501
        :type: str
        """

        self._insert_before = insert_before

    @property
    def insert_after(self):
        """Gets the insert_after of this SectionRequest.  # noqa: E501

        An existing section within this project after which the added section should be inserted. Cannot be provided together with insert_before.  # noqa: E501

        :return: The insert_after of this SectionRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_after

    @insert_after.setter
    def insert_after(self, insert_after):
        """Sets the insert_after of this SectionRequest.

        An existing section within this project after which the added section should be inserted. Cannot be provided together with insert_before.  # noqa: E501

        :param insert_after: The insert_after of this SectionRequest.  # noqa: E501
        :type: str
        """

        self._insert_after = insert_after

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SectionRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SectionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
