# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SectionResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'created_at': 'datetime',
        'project': 'JobBaseNewProject',
        'projects': 'list[JobBaseNewProject]'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'created_at': 'created_at',
        'project': 'project',
        'projects': 'projects'
    }

    def __init__(self, gid=None, resource_type=None, name=None, created_at=None, project=None, projects=None):  # noqa: E501
        """SectionResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._created_at = None
        self._project = None
        self._projects = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if created_at is not None:
            self.created_at = created_at
        if project is not None:
            self.project = project
        if projects is not None:
            self.projects = projects

    @property
    def gid(self):
        """Gets the gid of this SectionResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this SectionResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this SectionResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this SectionResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this SectionResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this SectionResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this SectionResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this SectionResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this SectionResponse.  # noqa: E501

        The name of the section (i.e. the text displayed as the section header).  # noqa: E501

        :return: The name of this SectionResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SectionResponse.

        The name of the section (i.e. the text displayed as the section header).  # noqa: E501

        :param name: The name of this SectionResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def created_at(self):
        """Gets the created_at of this SectionResponse.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this SectionResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this SectionResponse.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this SectionResponse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def project(self):
        """Gets the project of this SectionResponse.  # noqa: E501


        :return: The project of this SectionResponse.  # noqa: E501
        :rtype: JobBaseNewProject
        """
        return self._project

    @project.setter
    def project(self, project):
        """Sets the project of this SectionResponse.


        :param project: The project of this SectionResponse.  # noqa: E501
        :type: JobBaseNewProject
        """

        self._project = project

    @property
    def projects(self):
        """Gets the projects of this SectionResponse.  # noqa: E501

        *Deprecated - please use project instead*  # noqa: E501

        :return: The projects of this SectionResponse.  # noqa: E501
        :rtype: list[JobBaseNewProject]
        """
        return self._projects

    @projects.setter
    def projects(self, projects):
        """Sets the projects of this SectionResponse.

        *Deprecated - please use project instead*  # noqa: E501

        :param projects: The projects of this SectionResponse.  # noqa: E501
        :type: list[JobBaseNewProject]
        """

        self._projects = projects

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SectionResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SectionResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
