# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class StatusUpdateResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'title': 'str',
        'resource_subtype': 'str',
        'text': 'str',
        'html_text': 'str',
        'status_type': 'str',
        'author': 'CustomFieldResponsePeopleValue',
        'created_at': 'datetime',
        'created_by': 'CustomFieldResponsePeopleValue',
        'hearted': 'bool',
        'hearts': 'list[GoalResponseLikes]',
        'liked': 'bool',
        'likes': 'list[GoalResponseLikes]',
        'modified_at': 'datetime',
        'num_hearts': 'int',
        'num_likes': 'int',
        'parent': 'StatusUpdateResponseParent'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'title': 'title',
        'resource_subtype': 'resource_subtype',
        'text': 'text',
        'html_text': 'html_text',
        'status_type': 'status_type',
        'author': 'author',
        'created_at': 'created_at',
        'created_by': 'created_by',
        'hearted': 'hearted',
        'hearts': 'hearts',
        'liked': 'liked',
        'likes': 'likes',
        'modified_at': 'modified_at',
        'num_hearts': 'num_hearts',
        'num_likes': 'num_likes',
        'parent': 'parent'
    }

    def __init__(self, gid=None, resource_type=None, title=None, resource_subtype=None, text=None, html_text=None, status_type=None, author=None, created_at=None, created_by=None, hearted=None, hearts=None, liked=None, likes=None, modified_at=None, num_hearts=None, num_likes=None, parent=None):  # noqa: E501
        """StatusUpdateResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._title = None
        self._resource_subtype = None
        self._text = None
        self._html_text = None
        self._status_type = None
        self._author = None
        self._created_at = None
        self._created_by = None
        self._hearted = None
        self._hearts = None
        self._liked = None
        self._likes = None
        self._modified_at = None
        self._num_hearts = None
        self._num_likes = None
        self._parent = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if title is not None:
            self.title = title
        if resource_subtype is not None:
            self.resource_subtype = resource_subtype
        self.text = text
        if html_text is not None:
            self.html_text = html_text
        self.status_type = status_type
        if author is not None:
            self.author = author
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if hearted is not None:
            self.hearted = hearted
        if hearts is not None:
            self.hearts = hearts
        if liked is not None:
            self.liked = liked
        if likes is not None:
            self.likes = likes
        if modified_at is not None:
            self.modified_at = modified_at
        if num_hearts is not None:
            self.num_hearts = num_hearts
        if num_likes is not None:
            self.num_likes = num_likes
        if parent is not None:
            self.parent = parent

    @property
    def gid(self):
        """Gets the gid of this StatusUpdateResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this StatusUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this StatusUpdateResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this StatusUpdateResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this StatusUpdateResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this StatusUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this StatusUpdateResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this StatusUpdateResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def title(self):
        """Gets the title of this StatusUpdateResponse.  # noqa: E501

        The title of the status update.  # noqa: E501

        :return: The title of this StatusUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this StatusUpdateResponse.

        The title of the status update.  # noqa: E501

        :param title: The title of this StatusUpdateResponse.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def resource_subtype(self):
        """Gets the resource_subtype of this StatusUpdateResponse.  # noqa: E501

        The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning. The `resource_subtype`s for `status` objects represent the type of their parent.  # noqa: E501

        :return: The resource_subtype of this StatusUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_subtype

    @resource_subtype.setter
    def resource_subtype(self, resource_subtype):
        """Sets the resource_subtype of this StatusUpdateResponse.

        The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning. The `resource_subtype`s for `status` objects represent the type of their parent.  # noqa: E501

        :param resource_subtype: The resource_subtype of this StatusUpdateResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["project_status_update", "portfolio_status_update", "goal_status_update"]  # noqa: E501
        if resource_subtype not in allowed_values:
            raise ValueError(
                "Invalid value for `resource_subtype` ({0}), must be one of {1}"  # noqa: E501
                .format(resource_subtype, allowed_values)
            )

        self._resource_subtype = resource_subtype

    @property
    def text(self):
        """Gets the text of this StatusUpdateResponse.  # noqa: E501

        The text content of the status update.  # noqa: E501

        :return: The text of this StatusUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this StatusUpdateResponse.

        The text content of the status update.  # noqa: E501

        :param text: The text of this StatusUpdateResponse.  # noqa: E501
        :type: str
        """
        if text is None:
            raise ValueError("Invalid value for `text`, must not be `None`")  # noqa: E501

        self._text = text

    @property
    def html_text(self):
        """Gets the html_text of this StatusUpdateResponse.  # noqa: E501

        [Opt In](/docs/inputoutput-options). The text content of the status update with formatting as HTML.  # noqa: E501

        :return: The html_text of this StatusUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._html_text

    @html_text.setter
    def html_text(self, html_text):
        """Sets the html_text of this StatusUpdateResponse.

        [Opt In](/docs/inputoutput-options). The text content of the status update with formatting as HTML.  # noqa: E501

        :param html_text: The html_text of this StatusUpdateResponse.  # noqa: E501
        :type: str
        """

        self._html_text = html_text

    @property
    def status_type(self):
        """Gets the status_type of this StatusUpdateResponse.  # noqa: E501

        The type associated with the status update. This represents the current state of the object this object is on.  # noqa: E501

        :return: The status_type of this StatusUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._status_type

    @status_type.setter
    def status_type(self, status_type):
        """Sets the status_type of this StatusUpdateResponse.

        The type associated with the status update. This represents the current state of the object this object is on.  # noqa: E501

        :param status_type: The status_type of this StatusUpdateResponse.  # noqa: E501
        :type: str
        """
        if status_type is None:
            raise ValueError("Invalid value for `status_type`, must not be `None`")  # noqa: E501
        allowed_values = ["on_track", "at_risk", "off_track", "on_hold", "complete", "achieved", "partial", "missed", "dropped"]  # noqa: E501
        if status_type not in allowed_values:
            raise ValueError(
                "Invalid value for `status_type` ({0}), must be one of {1}"  # noqa: E501
                .format(status_type, allowed_values)
            )

        self._status_type = status_type

    @property
    def author(self):
        """Gets the author of this StatusUpdateResponse.  # noqa: E501


        :return: The author of this StatusUpdateResponse.  # noqa: E501
        :rtype: CustomFieldResponsePeopleValue
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this StatusUpdateResponse.


        :param author: The author of this StatusUpdateResponse.  # noqa: E501
        :type: CustomFieldResponsePeopleValue
        """

        self._author = author

    @property
    def created_at(self):
        """Gets the created_at of this StatusUpdateResponse.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this StatusUpdateResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this StatusUpdateResponse.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this StatusUpdateResponse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this StatusUpdateResponse.  # noqa: E501


        :return: The created_by of this StatusUpdateResponse.  # noqa: E501
        :rtype: CustomFieldResponsePeopleValue
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this StatusUpdateResponse.


        :param created_by: The created_by of this StatusUpdateResponse.  # noqa: E501
        :type: CustomFieldResponsePeopleValue
        """

        self._created_by = created_by

    @property
    def hearted(self):
        """Gets the hearted of this StatusUpdateResponse.  # noqa: E501

        *Deprecated - please use liked instead* True if the status is hearted by the authorized user, false if not.  # noqa: E501

        :return: The hearted of this StatusUpdateResponse.  # noqa: E501
        :rtype: bool
        """
        return self._hearted

    @hearted.setter
    def hearted(self, hearted):
        """Sets the hearted of this StatusUpdateResponse.

        *Deprecated - please use liked instead* True if the status is hearted by the authorized user, false if not.  # noqa: E501

        :param hearted: The hearted of this StatusUpdateResponse.  # noqa: E501
        :type: bool
        """

        self._hearted = hearted

    @property
    def hearts(self):
        """Gets the hearts of this StatusUpdateResponse.  # noqa: E501

        *Deprecated - please use likes instead* Array of likes for users who have hearted this status.  # noqa: E501

        :return: The hearts of this StatusUpdateResponse.  # noqa: E501
        :rtype: list[GoalResponseLikes]
        """
        return self._hearts

    @hearts.setter
    def hearts(self, hearts):
        """Sets the hearts of this StatusUpdateResponse.

        *Deprecated - please use likes instead* Array of likes for users who have hearted this status.  # noqa: E501

        :param hearts: The hearts of this StatusUpdateResponse.  # noqa: E501
        :type: list[GoalResponseLikes]
        """

        self._hearts = hearts

    @property
    def liked(self):
        """Gets the liked of this StatusUpdateResponse.  # noqa: E501

        True if the status is liked by the authorized user, false if not.  # noqa: E501

        :return: The liked of this StatusUpdateResponse.  # noqa: E501
        :rtype: bool
        """
        return self._liked

    @liked.setter
    def liked(self, liked):
        """Sets the liked of this StatusUpdateResponse.

        True if the status is liked by the authorized user, false if not.  # noqa: E501

        :param liked: The liked of this StatusUpdateResponse.  # noqa: E501
        :type: bool
        """

        self._liked = liked

    @property
    def likes(self):
        """Gets the likes of this StatusUpdateResponse.  # noqa: E501

        Array of likes for users who have liked this status.  # noqa: E501

        :return: The likes of this StatusUpdateResponse.  # noqa: E501
        :rtype: list[GoalResponseLikes]
        """
        return self._likes

    @likes.setter
    def likes(self, likes):
        """Sets the likes of this StatusUpdateResponse.

        Array of likes for users who have liked this status.  # noqa: E501

        :param likes: The likes of this StatusUpdateResponse.  # noqa: E501
        :type: list[GoalResponseLikes]
        """

        self._likes = likes

    @property
    def modified_at(self):
        """Gets the modified_at of this StatusUpdateResponse.  # noqa: E501

        The time at which this project status was last modified. *Note: This does not currently reflect any changes in associations such as comments that may have been added or removed from the status.*  # noqa: E501

        :return: The modified_at of this StatusUpdateResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this StatusUpdateResponse.

        The time at which this project status was last modified. *Note: This does not currently reflect any changes in associations such as comments that may have been added or removed from the status.*  # noqa: E501

        :param modified_at: The modified_at of this StatusUpdateResponse.  # noqa: E501
        :type: datetime
        """

        self._modified_at = modified_at

    @property
    def num_hearts(self):
        """Gets the num_hearts of this StatusUpdateResponse.  # noqa: E501

        *Deprecated - please use likes instead* The number of users who have hearted this status.  # noqa: E501

        :return: The num_hearts of this StatusUpdateResponse.  # noqa: E501
        :rtype: int
        """
        return self._num_hearts

    @num_hearts.setter
    def num_hearts(self, num_hearts):
        """Sets the num_hearts of this StatusUpdateResponse.

        *Deprecated - please use likes instead* The number of users who have hearted this status.  # noqa: E501

        :param num_hearts: The num_hearts of this StatusUpdateResponse.  # noqa: E501
        :type: int
        """

        self._num_hearts = num_hearts

    @property
    def num_likes(self):
        """Gets the num_likes of this StatusUpdateResponse.  # noqa: E501

        The number of users who have liked this status.  # noqa: E501

        :return: The num_likes of this StatusUpdateResponse.  # noqa: E501
        :rtype: int
        """
        return self._num_likes

    @num_likes.setter
    def num_likes(self, num_likes):
        """Sets the num_likes of this StatusUpdateResponse.

        The number of users who have liked this status.  # noqa: E501

        :param num_likes: The num_likes of this StatusUpdateResponse.  # noqa: E501
        :type: int
        """

        self._num_likes = num_likes

    @property
    def parent(self):
        """Gets the parent of this StatusUpdateResponse.  # noqa: E501


        :return: The parent of this StatusUpdateResponse.  # noqa: E501
        :rtype: StatusUpdateResponseParent
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this StatusUpdateResponse.


        :param parent: The parent of this StatusUpdateResponse.  # noqa: E501
        :type: StatusUpdateResponseParent
        """

        self._parent = parent

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StatusUpdateResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatusUpdateResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
