# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class StoryResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'created_at': 'datetime',
        'resource_subtype': 'str',
        'text': 'str',
        'html_text': 'str',
        'is_pinned': 'bool',
        'sticker_name': 'str',
        'created_by': 'CustomFieldResponsePeopleValue',
        'type': 'str',
        'is_editable': 'bool',
        'is_edited': 'bool',
        'hearted': 'bool',
        'hearts': 'list[GoalResponseLikes]',
        'num_hearts': 'int',
        'liked': 'bool',
        'likes': 'list[GoalResponseLikes]',
        'num_likes': 'int',
        'previews': 'list[StoryResponsePreviews]',
        'old_name': 'str',
        'new_name': 'str',
        'old_dates': 'StoryResponseOldDates',
        'new_dates': 'StoryResponseOldDates',
        'old_resource_subtype': 'str',
        'new_resource_subtype': 'str',
        'story': 'StoryResponseStory',
        'assignee': 'StoryResponseAssignee',
        'follower': 'StoryResponseAssignee',
        'old_section': 'StoryResponseOldSection',
        'new_section': 'StoryResponseOldSection',
        'task': 'StoryResponseTask',
        'project': 'StoryResponseProject',
        'tag': 'StoryResponseTag',
        'custom_field': 'StoryResponseCustomField',
        'old_text_value': 'str',
        'new_text_value': 'str',
        'old_number_value': 'int',
        'new_number_value': 'int',
        'old_enum_value': 'StoryResponseOldEnumValue',
        'new_enum_value': 'StoryResponseOldEnumValue',
        'old_date_value': 'AllOfStoryResponseOldDateValue',
        'new_date_value': 'AllOfStoryResponseNewDateValue',
        'old_people_value': 'list[CustomFieldResponsePeopleValue]',
        'new_people_value': 'list[CustomFieldResponsePeopleValue]',
        'old_multi_enum_values': 'list[CustomFieldBaseEnumOptions]',
        'new_multi_enum_values': 'list[CustomFieldBaseEnumOptions]',
        'new_approval_status': 'str',
        'old_approval_status': 'str',
        'duplicate_of': 'StoryResponseTask',
        'duplicated_from': 'StoryResponseTask',
        'dependency': 'StoryResponseTask',
        'source': 'str',
        'target': 'StoryResponseTarget'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'created_at': 'created_at',
        'resource_subtype': 'resource_subtype',
        'text': 'text',
        'html_text': 'html_text',
        'is_pinned': 'is_pinned',
        'sticker_name': 'sticker_name',
        'created_by': 'created_by',
        'type': 'type',
        'is_editable': 'is_editable',
        'is_edited': 'is_edited',
        'hearted': 'hearted',
        'hearts': 'hearts',
        'num_hearts': 'num_hearts',
        'liked': 'liked',
        'likes': 'likes',
        'num_likes': 'num_likes',
        'previews': 'previews',
        'old_name': 'old_name',
        'new_name': 'new_name',
        'old_dates': 'old_dates',
        'new_dates': 'new_dates',
        'old_resource_subtype': 'old_resource_subtype',
        'new_resource_subtype': 'new_resource_subtype',
        'story': 'story',
        'assignee': 'assignee',
        'follower': 'follower',
        'old_section': 'old_section',
        'new_section': 'new_section',
        'task': 'task',
        'project': 'project',
        'tag': 'tag',
        'custom_field': 'custom_field',
        'old_text_value': 'old_text_value',
        'new_text_value': 'new_text_value',
        'old_number_value': 'old_number_value',
        'new_number_value': 'new_number_value',
        'old_enum_value': 'old_enum_value',
        'new_enum_value': 'new_enum_value',
        'old_date_value': 'old_date_value',
        'new_date_value': 'new_date_value',
        'old_people_value': 'old_people_value',
        'new_people_value': 'new_people_value',
        'old_multi_enum_values': 'old_multi_enum_values',
        'new_multi_enum_values': 'new_multi_enum_values',
        'new_approval_status': 'new_approval_status',
        'old_approval_status': 'old_approval_status',
        'duplicate_of': 'duplicate_of',
        'duplicated_from': 'duplicated_from',
        'dependency': 'dependency',
        'source': 'source',
        'target': 'target'
    }

    def __init__(self, gid=None, resource_type=None, created_at=None, resource_subtype=None, text=None, html_text=None, is_pinned=None, sticker_name=None, created_by=None, type=None, is_editable=None, is_edited=None, hearted=None, hearts=None, num_hearts=None, liked=None, likes=None, num_likes=None, previews=None, old_name=None, new_name=None, old_dates=None, new_dates=None, old_resource_subtype=None, new_resource_subtype=None, story=None, assignee=None, follower=None, old_section=None, new_section=None, task=None, project=None, tag=None, custom_field=None, old_text_value=None, new_text_value=None, old_number_value=None, new_number_value=None, old_enum_value=None, new_enum_value=None, old_date_value=None, new_date_value=None, old_people_value=None, new_people_value=None, old_multi_enum_values=None, new_multi_enum_values=None, new_approval_status=None, old_approval_status=None, duplicate_of=None, duplicated_from=None, dependency=None, source=None, target=None):  # noqa: E501
        """StoryResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._created_at = None
        self._resource_subtype = None
        self._text = None
        self._html_text = None
        self._is_pinned = None
        self._sticker_name = None
        self._created_by = None
        self._type = None
        self._is_editable = None
        self._is_edited = None
        self._hearted = None
        self._hearts = None
        self._num_hearts = None
        self._liked = None
        self._likes = None
        self._num_likes = None
        self._previews = None
        self._old_name = None
        self._new_name = None
        self._old_dates = None
        self._new_dates = None
        self._old_resource_subtype = None
        self._new_resource_subtype = None
        self._story = None
        self._assignee = None
        self._follower = None
        self._old_section = None
        self._new_section = None
        self._task = None
        self._project = None
        self._tag = None
        self._custom_field = None
        self._old_text_value = None
        self._new_text_value = None
        self._old_number_value = None
        self._new_number_value = None
        self._old_enum_value = None
        self._new_enum_value = None
        self._old_date_value = None
        self._new_date_value = None
        self._old_people_value = None
        self._new_people_value = None
        self._old_multi_enum_values = None
        self._new_multi_enum_values = None
        self._new_approval_status = None
        self._old_approval_status = None
        self._duplicate_of = None
        self._duplicated_from = None
        self._dependency = None
        self._source = None
        self._target = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if created_at is not None:
            self.created_at = created_at
        if resource_subtype is not None:
            self.resource_subtype = resource_subtype
        if text is not None:
            self.text = text
        if html_text is not None:
            self.html_text = html_text
        if is_pinned is not None:
            self.is_pinned = is_pinned
        if sticker_name is not None:
            self.sticker_name = sticker_name
        if created_by is not None:
            self.created_by = created_by
        if type is not None:
            self.type = type
        if is_editable is not None:
            self.is_editable = is_editable
        if is_edited is not None:
            self.is_edited = is_edited
        if hearted is not None:
            self.hearted = hearted
        if hearts is not None:
            self.hearts = hearts
        if num_hearts is not None:
            self.num_hearts = num_hearts
        if liked is not None:
            self.liked = liked
        if likes is not None:
            self.likes = likes
        if num_likes is not None:
            self.num_likes = num_likes
        if previews is not None:
            self.previews = previews
        if old_name is not None:
            self.old_name = old_name
        if new_name is not None:
            self.new_name = new_name
        if old_dates is not None:
            self.old_dates = old_dates
        if new_dates is not None:
            self.new_dates = new_dates
        if old_resource_subtype is not None:
            self.old_resource_subtype = old_resource_subtype
        if new_resource_subtype is not None:
            self.new_resource_subtype = new_resource_subtype
        if story is not None:
            self.story = story
        if assignee is not None:
            self.assignee = assignee
        if follower is not None:
            self.follower = follower
        if old_section is not None:
            self.old_section = old_section
        if new_section is not None:
            self.new_section = new_section
        if task is not None:
            self.task = task
        if project is not None:
            self.project = project
        if tag is not None:
            self.tag = tag
        if custom_field is not None:
            self.custom_field = custom_field
        if old_text_value is not None:
            self.old_text_value = old_text_value
        if new_text_value is not None:
            self.new_text_value = new_text_value
        if old_number_value is not None:
            self.old_number_value = old_number_value
        if new_number_value is not None:
            self.new_number_value = new_number_value
        if old_enum_value is not None:
            self.old_enum_value = old_enum_value
        if new_enum_value is not None:
            self.new_enum_value = new_enum_value
        if old_date_value is not None:
            self.old_date_value = old_date_value
        if new_date_value is not None:
            self.new_date_value = new_date_value
        if old_people_value is not None:
            self.old_people_value = old_people_value
        if new_people_value is not None:
            self.new_people_value = new_people_value
        if old_multi_enum_values is not None:
            self.old_multi_enum_values = old_multi_enum_values
        if new_multi_enum_values is not None:
            self.new_multi_enum_values = new_multi_enum_values
        if new_approval_status is not None:
            self.new_approval_status = new_approval_status
        if old_approval_status is not None:
            self.old_approval_status = old_approval_status
        if duplicate_of is not None:
            self.duplicate_of = duplicate_of
        if duplicated_from is not None:
            self.duplicated_from = duplicated_from
        if dependency is not None:
            self.dependency = dependency
        if source is not None:
            self.source = source
        if target is not None:
            self.target = target

    @property
    def gid(self):
        """Gets the gid of this StoryResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this StoryResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this StoryResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this StoryResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def created_at(self):
        """Gets the created_at of this StoryResponse.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this StoryResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this StoryResponse.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this StoryResponse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def resource_subtype(self):
        """Gets the resource_subtype of this StoryResponse.  # noqa: E501

        The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.  # noqa: E501

        :return: The resource_subtype of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_subtype

    @resource_subtype.setter
    def resource_subtype(self, resource_subtype):
        """Sets the resource_subtype of this StoryResponse.

        The subtype of this resource. Different subtypes retain many of the same fields and behavior, but may render differently in Asana or represent resources with different semantic meaning.  # noqa: E501

        :param resource_subtype: The resource_subtype of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._resource_subtype = resource_subtype

    @property
    def text(self):
        """Gets the text of this StoryResponse.  # noqa: E501

        The plain text of the comment to add. Cannot be used with html_text.  # noqa: E501

        :return: The text of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this StoryResponse.

        The plain text of the comment to add. Cannot be used with html_text.  # noqa: E501

        :param text: The text of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def html_text(self):
        """Gets the html_text of this StoryResponse.  # noqa: E501

        [Opt In](/docs/inputoutput-options). HTML formatted text for a comment. This will not include the name of the creator.  # noqa: E501

        :return: The html_text of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._html_text

    @html_text.setter
    def html_text(self, html_text):
        """Sets the html_text of this StoryResponse.

        [Opt In](/docs/inputoutput-options). HTML formatted text for a comment. This will not include the name of the creator.  # noqa: E501

        :param html_text: The html_text of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._html_text = html_text

    @property
    def is_pinned(self):
        """Gets the is_pinned of this StoryResponse.  # noqa: E501

        *Conditional*. Whether the story should be pinned on the resource.  # noqa: E501

        :return: The is_pinned of this StoryResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_pinned

    @is_pinned.setter
    def is_pinned(self, is_pinned):
        """Sets the is_pinned of this StoryResponse.

        *Conditional*. Whether the story should be pinned on the resource.  # noqa: E501

        :param is_pinned: The is_pinned of this StoryResponse.  # noqa: E501
        :type: bool
        """

        self._is_pinned = is_pinned

    @property
    def sticker_name(self):
        """Gets the sticker_name of this StoryResponse.  # noqa: E501

        The name of the sticker in this story. `null` if there is no sticker.  # noqa: E501

        :return: The sticker_name of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._sticker_name

    @sticker_name.setter
    def sticker_name(self, sticker_name):
        """Sets the sticker_name of this StoryResponse.

        The name of the sticker in this story. `null` if there is no sticker.  # noqa: E501

        :param sticker_name: The sticker_name of this StoryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["green_checkmark", "people_dancing", "dancing_unicorn", "heart", "party_popper", "people_waving_flags", "splashing_narwhal", "trophy", "yeti_riding_unicorn", "celebrating_people", "determined_climbers", "phoenix_spreading_love"]  # noqa: E501
        if sticker_name not in allowed_values:
            raise ValueError(
                "Invalid value for `sticker_name` ({0}), must be one of {1}"  # noqa: E501
                .format(sticker_name, allowed_values)
            )

        self._sticker_name = sticker_name

    @property
    def created_by(self):
        """Gets the created_by of this StoryResponse.  # noqa: E501


        :return: The created_by of this StoryResponse.  # noqa: E501
        :rtype: CustomFieldResponsePeopleValue
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this StoryResponse.


        :param created_by: The created_by of this StoryResponse.  # noqa: E501
        :type: CustomFieldResponsePeopleValue
        """

        self._created_by = created_by

    @property
    def type(self):
        """Gets the type of this StoryResponse.  # noqa: E501


        :return: The type of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this StoryResponse.


        :param type: The type of this StoryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["comment", "system"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def is_editable(self):
        """Gets the is_editable of this StoryResponse.  # noqa: E501

        *Conditional*. Whether the text of the story can be edited after creation.  # noqa: E501

        :return: The is_editable of this StoryResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_editable

    @is_editable.setter
    def is_editable(self, is_editable):
        """Sets the is_editable of this StoryResponse.

        *Conditional*. Whether the text of the story can be edited after creation.  # noqa: E501

        :param is_editable: The is_editable of this StoryResponse.  # noqa: E501
        :type: bool
        """

        self._is_editable = is_editable

    @property
    def is_edited(self):
        """Gets the is_edited of this StoryResponse.  # noqa: E501

        *Conditional*. Whether the text of the story has been edited after creation.  # noqa: E501

        :return: The is_edited of this StoryResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_edited

    @is_edited.setter
    def is_edited(self, is_edited):
        """Sets the is_edited of this StoryResponse.

        *Conditional*. Whether the text of the story has been edited after creation.  # noqa: E501

        :param is_edited: The is_edited of this StoryResponse.  # noqa: E501
        :type: bool
        """

        self._is_edited = is_edited

    @property
    def hearted(self):
        """Gets the hearted of this StoryResponse.  # noqa: E501

        *Deprecated - please use likes instead* *Conditional*. True if the story is hearted by the authorized user, false if not.  # noqa: E501

        :return: The hearted of this StoryResponse.  # noqa: E501
        :rtype: bool
        """
        return self._hearted

    @hearted.setter
    def hearted(self, hearted):
        """Sets the hearted of this StoryResponse.

        *Deprecated - please use likes instead* *Conditional*. True if the story is hearted by the authorized user, false if not.  # noqa: E501

        :param hearted: The hearted of this StoryResponse.  # noqa: E501
        :type: bool
        """

        self._hearted = hearted

    @property
    def hearts(self):
        """Gets the hearts of this StoryResponse.  # noqa: E501

        *Deprecated - please use likes instead*  *Conditional*. Array of likes for users who have hearted this story.  # noqa: E501

        :return: The hearts of this StoryResponse.  # noqa: E501
        :rtype: list[GoalResponseLikes]
        """
        return self._hearts

    @hearts.setter
    def hearts(self, hearts):
        """Sets the hearts of this StoryResponse.

        *Deprecated - please use likes instead*  *Conditional*. Array of likes for users who have hearted this story.  # noqa: E501

        :param hearts: The hearts of this StoryResponse.  # noqa: E501
        :type: list[GoalResponseLikes]
        """

        self._hearts = hearts

    @property
    def num_hearts(self):
        """Gets the num_hearts of this StoryResponse.  # noqa: E501

        *Deprecated - please use likes instead*  *Conditional*. The number of users who have hearted this story.  # noqa: E501

        :return: The num_hearts of this StoryResponse.  # noqa: E501
        :rtype: int
        """
        return self._num_hearts

    @num_hearts.setter
    def num_hearts(self, num_hearts):
        """Sets the num_hearts of this StoryResponse.

        *Deprecated - please use likes instead*  *Conditional*. The number of users who have hearted this story.  # noqa: E501

        :param num_hearts: The num_hearts of this StoryResponse.  # noqa: E501
        :type: int
        """

        self._num_hearts = num_hearts

    @property
    def liked(self):
        """Gets the liked of this StoryResponse.  # noqa: E501

        *Conditional*. True if the story is liked by the authorized user, false if not.  # noqa: E501

        :return: The liked of this StoryResponse.  # noqa: E501
        :rtype: bool
        """
        return self._liked

    @liked.setter
    def liked(self, liked):
        """Sets the liked of this StoryResponse.

        *Conditional*. True if the story is liked by the authorized user, false if not.  # noqa: E501

        :param liked: The liked of this StoryResponse.  # noqa: E501
        :type: bool
        """

        self._liked = liked

    @property
    def likes(self):
        """Gets the likes of this StoryResponse.  # noqa: E501

        *Conditional*. Array of likes for users who have liked this story.  # noqa: E501

        :return: The likes of this StoryResponse.  # noqa: E501
        :rtype: list[GoalResponseLikes]
        """
        return self._likes

    @likes.setter
    def likes(self, likes):
        """Sets the likes of this StoryResponse.

        *Conditional*. Array of likes for users who have liked this story.  # noqa: E501

        :param likes: The likes of this StoryResponse.  # noqa: E501
        :type: list[GoalResponseLikes]
        """

        self._likes = likes

    @property
    def num_likes(self):
        """Gets the num_likes of this StoryResponse.  # noqa: E501

        *Conditional*. The number of users who have liked this story.  # noqa: E501

        :return: The num_likes of this StoryResponse.  # noqa: E501
        :rtype: int
        """
        return self._num_likes

    @num_likes.setter
    def num_likes(self, num_likes):
        """Sets the num_likes of this StoryResponse.

        *Conditional*. The number of users who have liked this story.  # noqa: E501

        :param num_likes: The num_likes of this StoryResponse.  # noqa: E501
        :type: int
        """

        self._num_likes = num_likes

    @property
    def previews(self):
        """Gets the previews of this StoryResponse.  # noqa: E501

        *Conditional*. A collection of previews to be displayed in the story.  *Note: This property only exists for comment stories.*  # noqa: E501

        :return: The previews of this StoryResponse.  # noqa: E501
        :rtype: list[StoryResponsePreviews]
        """
        return self._previews

    @previews.setter
    def previews(self, previews):
        """Sets the previews of this StoryResponse.

        *Conditional*. A collection of previews to be displayed in the story.  *Note: This property only exists for comment stories.*  # noqa: E501

        :param previews: The previews of this StoryResponse.  # noqa: E501
        :type: list[StoryResponsePreviews]
        """

        self._previews = previews

    @property
    def old_name(self):
        """Gets the old_name of this StoryResponse.  # noqa: E501

        *Conditional*'  # noqa: E501

        :return: The old_name of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._old_name

    @old_name.setter
    def old_name(self, old_name):
        """Sets the old_name of this StoryResponse.

        *Conditional*'  # noqa: E501

        :param old_name: The old_name of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._old_name = old_name

    @property
    def new_name(self):
        """Gets the new_name of this StoryResponse.  # noqa: E501

        *Conditional*  # noqa: E501

        :return: The new_name of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._new_name

    @new_name.setter
    def new_name(self, new_name):
        """Sets the new_name of this StoryResponse.

        *Conditional*  # noqa: E501

        :param new_name: The new_name of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._new_name = new_name

    @property
    def old_dates(self):
        """Gets the old_dates of this StoryResponse.  # noqa: E501


        :return: The old_dates of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseOldDates
        """
        return self._old_dates

    @old_dates.setter
    def old_dates(self, old_dates):
        """Sets the old_dates of this StoryResponse.


        :param old_dates: The old_dates of this StoryResponse.  # noqa: E501
        :type: StoryResponseOldDates
        """

        self._old_dates = old_dates

    @property
    def new_dates(self):
        """Gets the new_dates of this StoryResponse.  # noqa: E501


        :return: The new_dates of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseOldDates
        """
        return self._new_dates

    @new_dates.setter
    def new_dates(self, new_dates):
        """Sets the new_dates of this StoryResponse.


        :param new_dates: The new_dates of this StoryResponse.  # noqa: E501
        :type: StoryResponseOldDates
        """

        self._new_dates = new_dates

    @property
    def old_resource_subtype(self):
        """Gets the old_resource_subtype of this StoryResponse.  # noqa: E501

        *Conditional*  # noqa: E501

        :return: The old_resource_subtype of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._old_resource_subtype

    @old_resource_subtype.setter
    def old_resource_subtype(self, old_resource_subtype):
        """Sets the old_resource_subtype of this StoryResponse.

        *Conditional*  # noqa: E501

        :param old_resource_subtype: The old_resource_subtype of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._old_resource_subtype = old_resource_subtype

    @property
    def new_resource_subtype(self):
        """Gets the new_resource_subtype of this StoryResponse.  # noqa: E501

        *Conditional*  # noqa: E501

        :return: The new_resource_subtype of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._new_resource_subtype

    @new_resource_subtype.setter
    def new_resource_subtype(self, new_resource_subtype):
        """Sets the new_resource_subtype of this StoryResponse.

        *Conditional*  # noqa: E501

        :param new_resource_subtype: The new_resource_subtype of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._new_resource_subtype = new_resource_subtype

    @property
    def story(self):
        """Gets the story of this StoryResponse.  # noqa: E501


        :return: The story of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseStory
        """
        return self._story

    @story.setter
    def story(self, story):
        """Sets the story of this StoryResponse.


        :param story: The story of this StoryResponse.  # noqa: E501
        :type: StoryResponseStory
        """

        self._story = story

    @property
    def assignee(self):
        """Gets the assignee of this StoryResponse.  # noqa: E501


        :return: The assignee of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseAssignee
        """
        return self._assignee

    @assignee.setter
    def assignee(self, assignee):
        """Sets the assignee of this StoryResponse.


        :param assignee: The assignee of this StoryResponse.  # noqa: E501
        :type: StoryResponseAssignee
        """

        self._assignee = assignee

    @property
    def follower(self):
        """Gets the follower of this StoryResponse.  # noqa: E501


        :return: The follower of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseAssignee
        """
        return self._follower

    @follower.setter
    def follower(self, follower):
        """Sets the follower of this StoryResponse.


        :param follower: The follower of this StoryResponse.  # noqa: E501
        :type: StoryResponseAssignee
        """

        self._follower = follower

    @property
    def old_section(self):
        """Gets the old_section of this StoryResponse.  # noqa: E501


        :return: The old_section of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseOldSection
        """
        return self._old_section

    @old_section.setter
    def old_section(self, old_section):
        """Sets the old_section of this StoryResponse.


        :param old_section: The old_section of this StoryResponse.  # noqa: E501
        :type: StoryResponseOldSection
        """

        self._old_section = old_section

    @property
    def new_section(self):
        """Gets the new_section of this StoryResponse.  # noqa: E501


        :return: The new_section of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseOldSection
        """
        return self._new_section

    @new_section.setter
    def new_section(self, new_section):
        """Sets the new_section of this StoryResponse.


        :param new_section: The new_section of this StoryResponse.  # noqa: E501
        :type: StoryResponseOldSection
        """

        self._new_section = new_section

    @property
    def task(self):
        """Gets the task of this StoryResponse.  # noqa: E501


        :return: The task of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseTask
        """
        return self._task

    @task.setter
    def task(self, task):
        """Sets the task of this StoryResponse.


        :param task: The task of this StoryResponse.  # noqa: E501
        :type: StoryResponseTask
        """

        self._task = task

    @property
    def project(self):
        """Gets the project of this StoryResponse.  # noqa: E501


        :return: The project of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseProject
        """
        return self._project

    @project.setter
    def project(self, project):
        """Sets the project of this StoryResponse.


        :param project: The project of this StoryResponse.  # noqa: E501
        :type: StoryResponseProject
        """

        self._project = project

    @property
    def tag(self):
        """Gets the tag of this StoryResponse.  # noqa: E501


        :return: The tag of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseTag
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this StoryResponse.


        :param tag: The tag of this StoryResponse.  # noqa: E501
        :type: StoryResponseTag
        """

        self._tag = tag

    @property
    def custom_field(self):
        """Gets the custom_field of this StoryResponse.  # noqa: E501


        :return: The custom_field of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseCustomField
        """
        return self._custom_field

    @custom_field.setter
    def custom_field(self, custom_field):
        """Sets the custom_field of this StoryResponse.


        :param custom_field: The custom_field of this StoryResponse.  # noqa: E501
        :type: StoryResponseCustomField
        """

        self._custom_field = custom_field

    @property
    def old_text_value(self):
        """Gets the old_text_value of this StoryResponse.  # noqa: E501

        *Conditional*  # noqa: E501

        :return: The old_text_value of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._old_text_value

    @old_text_value.setter
    def old_text_value(self, old_text_value):
        """Sets the old_text_value of this StoryResponse.

        *Conditional*  # noqa: E501

        :param old_text_value: The old_text_value of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._old_text_value = old_text_value

    @property
    def new_text_value(self):
        """Gets the new_text_value of this StoryResponse.  # noqa: E501

        *Conditional*  # noqa: E501

        :return: The new_text_value of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._new_text_value

    @new_text_value.setter
    def new_text_value(self, new_text_value):
        """Sets the new_text_value of this StoryResponse.

        *Conditional*  # noqa: E501

        :param new_text_value: The new_text_value of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._new_text_value = new_text_value

    @property
    def old_number_value(self):
        """Gets the old_number_value of this StoryResponse.  # noqa: E501

        *Conditional*  # noqa: E501

        :return: The old_number_value of this StoryResponse.  # noqa: E501
        :rtype: int
        """
        return self._old_number_value

    @old_number_value.setter
    def old_number_value(self, old_number_value):
        """Sets the old_number_value of this StoryResponse.

        *Conditional*  # noqa: E501

        :param old_number_value: The old_number_value of this StoryResponse.  # noqa: E501
        :type: int
        """

        self._old_number_value = old_number_value

    @property
    def new_number_value(self):
        """Gets the new_number_value of this StoryResponse.  # noqa: E501

        *Conditional*  # noqa: E501

        :return: The new_number_value of this StoryResponse.  # noqa: E501
        :rtype: int
        """
        return self._new_number_value

    @new_number_value.setter
    def new_number_value(self, new_number_value):
        """Sets the new_number_value of this StoryResponse.

        *Conditional*  # noqa: E501

        :param new_number_value: The new_number_value of this StoryResponse.  # noqa: E501
        :type: int
        """

        self._new_number_value = new_number_value

    @property
    def old_enum_value(self):
        """Gets the old_enum_value of this StoryResponse.  # noqa: E501


        :return: The old_enum_value of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseOldEnumValue
        """
        return self._old_enum_value

    @old_enum_value.setter
    def old_enum_value(self, old_enum_value):
        """Sets the old_enum_value of this StoryResponse.


        :param old_enum_value: The old_enum_value of this StoryResponse.  # noqa: E501
        :type: StoryResponseOldEnumValue
        """

        self._old_enum_value = old_enum_value

    @property
    def new_enum_value(self):
        """Gets the new_enum_value of this StoryResponse.  # noqa: E501


        :return: The new_enum_value of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseOldEnumValue
        """
        return self._new_enum_value

    @new_enum_value.setter
    def new_enum_value(self, new_enum_value):
        """Sets the new_enum_value of this StoryResponse.


        :param new_enum_value: The new_enum_value of this StoryResponse.  # noqa: E501
        :type: StoryResponseOldEnumValue
        """

        self._new_enum_value = new_enum_value

    @property
    def old_date_value(self):
        """Gets the old_date_value of this StoryResponse.  # noqa: E501


        :return: The old_date_value of this StoryResponse.  # noqa: E501
        :rtype: AllOfStoryResponseOldDateValue
        """
        return self._old_date_value

    @old_date_value.setter
    def old_date_value(self, old_date_value):
        """Sets the old_date_value of this StoryResponse.


        :param old_date_value: The old_date_value of this StoryResponse.  # noqa: E501
        :type: AllOfStoryResponseOldDateValue
        """

        self._old_date_value = old_date_value

    @property
    def new_date_value(self):
        """Gets the new_date_value of this StoryResponse.  # noqa: E501


        :return: The new_date_value of this StoryResponse.  # noqa: E501
        :rtype: AllOfStoryResponseNewDateValue
        """
        return self._new_date_value

    @new_date_value.setter
    def new_date_value(self, new_date_value):
        """Sets the new_date_value of this StoryResponse.


        :param new_date_value: The new_date_value of this StoryResponse.  # noqa: E501
        :type: AllOfStoryResponseNewDateValue
        """

        self._new_date_value = new_date_value

    @property
    def old_people_value(self):
        """Gets the old_people_value of this StoryResponse.  # noqa: E501

        *Conditional*. The old value of a people custom field story.  # noqa: E501

        :return: The old_people_value of this StoryResponse.  # noqa: E501
        :rtype: list[CustomFieldResponsePeopleValue]
        """
        return self._old_people_value

    @old_people_value.setter
    def old_people_value(self, old_people_value):
        """Sets the old_people_value of this StoryResponse.

        *Conditional*. The old value of a people custom field story.  # noqa: E501

        :param old_people_value: The old_people_value of this StoryResponse.  # noqa: E501
        :type: list[CustomFieldResponsePeopleValue]
        """

        self._old_people_value = old_people_value

    @property
    def new_people_value(self):
        """Gets the new_people_value of this StoryResponse.  # noqa: E501

        *Conditional*. The new value of a people custom field story.  # noqa: E501

        :return: The new_people_value of this StoryResponse.  # noqa: E501
        :rtype: list[CustomFieldResponsePeopleValue]
        """
        return self._new_people_value

    @new_people_value.setter
    def new_people_value(self, new_people_value):
        """Sets the new_people_value of this StoryResponse.

        *Conditional*. The new value of a people custom field story.  # noqa: E501

        :param new_people_value: The new_people_value of this StoryResponse.  # noqa: E501
        :type: list[CustomFieldResponsePeopleValue]
        """

        self._new_people_value = new_people_value

    @property
    def old_multi_enum_values(self):
        """Gets the old_multi_enum_values of this StoryResponse.  # noqa: E501

        *Conditional*. The old value of a multi-enum custom field story.  # noqa: E501

        :return: The old_multi_enum_values of this StoryResponse.  # noqa: E501
        :rtype: list[CustomFieldBaseEnumOptions]
        """
        return self._old_multi_enum_values

    @old_multi_enum_values.setter
    def old_multi_enum_values(self, old_multi_enum_values):
        """Sets the old_multi_enum_values of this StoryResponse.

        *Conditional*. The old value of a multi-enum custom field story.  # noqa: E501

        :param old_multi_enum_values: The old_multi_enum_values of this StoryResponse.  # noqa: E501
        :type: list[CustomFieldBaseEnumOptions]
        """

        self._old_multi_enum_values = old_multi_enum_values

    @property
    def new_multi_enum_values(self):
        """Gets the new_multi_enum_values of this StoryResponse.  # noqa: E501

        *Conditional*. The new value of a multi-enum custom field story.  # noqa: E501

        :return: The new_multi_enum_values of this StoryResponse.  # noqa: E501
        :rtype: list[CustomFieldBaseEnumOptions]
        """
        return self._new_multi_enum_values

    @new_multi_enum_values.setter
    def new_multi_enum_values(self, new_multi_enum_values):
        """Sets the new_multi_enum_values of this StoryResponse.

        *Conditional*. The new value of a multi-enum custom field story.  # noqa: E501

        :param new_multi_enum_values: The new_multi_enum_values of this StoryResponse.  # noqa: E501
        :type: list[CustomFieldBaseEnumOptions]
        """

        self._new_multi_enum_values = new_multi_enum_values

    @property
    def new_approval_status(self):
        """Gets the new_approval_status of this StoryResponse.  # noqa: E501

        *Conditional*. The new value of approval status.  # noqa: E501

        :return: The new_approval_status of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._new_approval_status

    @new_approval_status.setter
    def new_approval_status(self, new_approval_status):
        """Sets the new_approval_status of this StoryResponse.

        *Conditional*. The new value of approval status.  # noqa: E501

        :param new_approval_status: The new_approval_status of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._new_approval_status = new_approval_status

    @property
    def old_approval_status(self):
        """Gets the old_approval_status of this StoryResponse.  # noqa: E501

        *Conditional*. The old value of approval status.  # noqa: E501

        :return: The old_approval_status of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._old_approval_status

    @old_approval_status.setter
    def old_approval_status(self, old_approval_status):
        """Sets the old_approval_status of this StoryResponse.

        *Conditional*. The old value of approval status.  # noqa: E501

        :param old_approval_status: The old_approval_status of this StoryResponse.  # noqa: E501
        :type: str
        """

        self._old_approval_status = old_approval_status

    @property
    def duplicate_of(self):
        """Gets the duplicate_of of this StoryResponse.  # noqa: E501


        :return: The duplicate_of of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseTask
        """
        return self._duplicate_of

    @duplicate_of.setter
    def duplicate_of(self, duplicate_of):
        """Sets the duplicate_of of this StoryResponse.


        :param duplicate_of: The duplicate_of of this StoryResponse.  # noqa: E501
        :type: StoryResponseTask
        """

        self._duplicate_of = duplicate_of

    @property
    def duplicated_from(self):
        """Gets the duplicated_from of this StoryResponse.  # noqa: E501


        :return: The duplicated_from of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseTask
        """
        return self._duplicated_from

    @duplicated_from.setter
    def duplicated_from(self, duplicated_from):
        """Sets the duplicated_from of this StoryResponse.


        :param duplicated_from: The duplicated_from of this StoryResponse.  # noqa: E501
        :type: StoryResponseTask
        """

        self._duplicated_from = duplicated_from

    @property
    def dependency(self):
        """Gets the dependency of this StoryResponse.  # noqa: E501


        :return: The dependency of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseTask
        """
        return self._dependency

    @dependency.setter
    def dependency(self, dependency):
        """Sets the dependency of this StoryResponse.


        :param dependency: The dependency of this StoryResponse.  # noqa: E501
        :type: StoryResponseTask
        """

        self._dependency = dependency

    @property
    def source(self):
        """Gets the source of this StoryResponse.  # noqa: E501

        The component of the Asana product the user used to trigger the story.  # noqa: E501

        :return: The source of this StoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this StoryResponse.

        The component of the Asana product the user used to trigger the story.  # noqa: E501

        :param source: The source of this StoryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["web", "email", "mobile", "api", "unknown"]  # noqa: E501
        if source not in allowed_values:
            raise ValueError(
                "Invalid value for `source` ({0}), must be one of {1}"  # noqa: E501
                .format(source, allowed_values)
            )

        self._source = source

    @property
    def target(self):
        """Gets the target of this StoryResponse.  # noqa: E501


        :return: The target of this StoryResponse.  # noqa: E501
        :rtype: StoryResponseTarget
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this StoryResponse.


        :param target: The target of this StoryResponse.  # noqa: E501
        :type: StoryResponseTarget
        """

        self._target = target

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StoryResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StoryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
