# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class StoryResponseDates(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'start_on': 'date',
        'due_at': 'datetime',
        'due_on': 'date'
    }

    attribute_map = {
        'start_on': 'start_on',
        'due_at': 'due_at',
        'due_on': 'due_on'
    }

    def __init__(self, start_on=None, due_at=None, due_on=None):  # noqa: E501
        """StoryResponseDates - a model defined in Swagger"""  # noqa: E501
        self._start_on = None
        self._due_at = None
        self._due_on = None
        self.discriminator = None
        if start_on is not None:
            self.start_on = start_on
        if due_at is not None:
            self.due_at = due_at
        if due_on is not None:
            self.due_on = due_on

    @property
    def start_on(self):
        """Gets the start_on of this StoryResponseDates.  # noqa: E501

        The day on which work for this goal begins, or null if the goal has no start date. This takes a date with `YYYY-MM-DD` format, and cannot be set unless there is an accompanying due date.  # noqa: E501

        :return: The start_on of this StoryResponseDates.  # noqa: E501
        :rtype: date
        """
        return self._start_on

    @start_on.setter
    def start_on(self, start_on):
        """Sets the start_on of this StoryResponseDates.

        The day on which work for this goal begins, or null if the goal has no start date. This takes a date with `YYYY-MM-DD` format, and cannot be set unless there is an accompanying due date.  # noqa: E501

        :param start_on: The start_on of this StoryResponseDates.  # noqa: E501
        :type: date
        """

        self._start_on = start_on

    @property
    def due_at(self):
        """Gets the due_at of this StoryResponseDates.  # noqa: E501

        The UTC date and time on which this task is due, or null if the task has no due time. This takes an ISO 8601 date string in UTC and should not be used together with `due_on`.  # noqa: E501

        :return: The due_at of this StoryResponseDates.  # noqa: E501
        :rtype: datetime
        """
        return self._due_at

    @due_at.setter
    def due_at(self, due_at):
        """Sets the due_at of this StoryResponseDates.

        The UTC date and time on which this task is due, or null if the task has no due time. This takes an ISO 8601 date string in UTC and should not be used together with `due_on`.  # noqa: E501

        :param due_at: The due_at of this StoryResponseDates.  # noqa: E501
        :type: datetime
        """

        self._due_at = due_at

    @property
    def due_on(self):
        """Gets the due_on of this StoryResponseDates.  # noqa: E501

        The localized day on which this goal is due. This takes a date with format `YYYY-MM-DD`.  # noqa: E501

        :return: The due_on of this StoryResponseDates.  # noqa: E501
        :rtype: date
        """
        return self._due_on

    @due_on.setter
    def due_on(self, due_on):
        """Sets the due_on of this StoryResponseDates.

        The localized day on which this goal is due. This takes a date with format `YYYY-MM-DD`.  # noqa: E501

        :param due_on: The due_on of this StoryResponseDates.  # noqa: E501
        :type: date
        """

        self._due_on = due_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StoryResponseDates, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StoryResponseDates):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
