# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TagRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'color': 'str',
        'notes': 'str',
        'followers': 'list[str]',
        'workspace': 'str'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'color': 'color',
        'notes': 'notes',
        'followers': 'followers',
        'workspace': 'workspace'
    }

    def __init__(self, gid=None, resource_type=None, name=None, color=None, notes=None, followers=None, workspace=None):  # noqa: E501
        """TagRequest - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._color = None
        self._notes = None
        self._followers = None
        self._workspace = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if color is not None:
            self.color = color
        if notes is not None:
            self.notes = notes
        if followers is not None:
            self.followers = followers
        if workspace is not None:
            self.workspace = workspace

    @property
    def gid(self):
        """Gets the gid of this TagRequest.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this TagRequest.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this TagRequest.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this TagRequest.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this TagRequest.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this TagRequest.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this TagRequest.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this TagRequest.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this TagRequest.  # noqa: E501

        Name of the tag. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.  # noqa: E501

        :return: The name of this TagRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TagRequest.

        Name of the tag. This is generally a short sentence fragment that fits on a line in the UI for maximum readability. However, it can be longer.  # noqa: E501

        :param name: The name of this TagRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def color(self):
        """Gets the color of this TagRequest.  # noqa: E501

        Color of the tag.  # noqa: E501

        :return: The color of this TagRequest.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this TagRequest.

        Color of the tag.  # noqa: E501

        :param color: The color of this TagRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["dark-pink", "dark-green", "dark-blue", "dark-red", "dark-teal", "dark-brown", "dark-orange", "dark-purple", "dark-warm-gray", "light-pink", "light-green", "light-blue", "light-red", "light-teal", "light-brown", "light-orange", "light-purple", "light-warm-gray", ""]  # noqa: E501
        if color not in allowed_values:
            raise ValueError(
                "Invalid value for `color` ({0}), must be one of {1}"  # noqa: E501
                .format(color, allowed_values)
            )

        self._color = color

    @property
    def notes(self):
        """Gets the notes of this TagRequest.  # noqa: E501

        Free-form textual information associated with the tag (i.e. its description).  # noqa: E501

        :return: The notes of this TagRequest.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this TagRequest.

        Free-form textual information associated with the tag (i.e. its description).  # noqa: E501

        :param notes: The notes of this TagRequest.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def followers(self):
        """Gets the followers of this TagRequest.  # noqa: E501

        An array of strings identifying users. These can either be the string \"me\", an email, or the gid of a user.  # noqa: E501

        :return: The followers of this TagRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._followers

    @followers.setter
    def followers(self, followers):
        """Sets the followers of this TagRequest.

        An array of strings identifying users. These can either be the string \"me\", an email, or the gid of a user.  # noqa: E501

        :param followers: The followers of this TagRequest.  # noqa: E501
        :type: list[str]
        """

        self._followers = followers

    @property
    def workspace(self):
        """Gets the workspace of this TagRequest.  # noqa: E501

        Gid of an object.  # noqa: E501

        :return: The workspace of this TagRequest.  # noqa: E501
        :rtype: str
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this TagRequest.

        Gid of an object.  # noqa: E501

        :param workspace: The workspace of this TagRequest.  # noqa: E501
        :type: str
        """

        self._workspace = workspace

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TagRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TagRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
