# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TaskAddProjectRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'project': 'str',
        'insert_after': 'str',
        'insert_before': 'str',
        'section': 'str'
    }

    attribute_map = {
        'project': 'project',
        'insert_after': 'insert_after',
        'insert_before': 'insert_before',
        'section': 'section'
    }

    def __init__(self, project=None, insert_after=None, insert_before=None, section=None):  # noqa: E501
        """TaskAddProjectRequest - a model defined in Swagger"""  # noqa: E501
        self._project = None
        self._insert_after = None
        self._insert_before = None
        self._section = None
        self.discriminator = None
        self.project = project
        if insert_after is not None:
            self.insert_after = insert_after
        if insert_before is not None:
            self.insert_before = insert_before
        if section is not None:
            self.section = section

    @property
    def project(self):
        """Gets the project of this TaskAddProjectRequest.  # noqa: E501

        The project to add the task to.  # noqa: E501

        :return: The project of this TaskAddProjectRequest.  # noqa: E501
        :rtype: str
        """
        return self._project

    @project.setter
    def project(self, project):
        """Sets the project of this TaskAddProjectRequest.

        The project to add the task to.  # noqa: E501

        :param project: The project of this TaskAddProjectRequest.  # noqa: E501
        :type: str
        """
        if project is None:
            raise ValueError("Invalid value for `project`, must not be `None`")  # noqa: E501

        self._project = project

    @property
    def insert_after(self):
        """Gets the insert_after of this TaskAddProjectRequest.  # noqa: E501

        A task in the project to insert the task after, or `null` to insert at the beginning of the list.  # noqa: E501

        :return: The insert_after of this TaskAddProjectRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_after

    @insert_after.setter
    def insert_after(self, insert_after):
        """Sets the insert_after of this TaskAddProjectRequest.

        A task in the project to insert the task after, or `null` to insert at the beginning of the list.  # noqa: E501

        :param insert_after: The insert_after of this TaskAddProjectRequest.  # noqa: E501
        :type: str
        """

        self._insert_after = insert_after

    @property
    def insert_before(self):
        """Gets the insert_before of this TaskAddProjectRequest.  # noqa: E501

        A task in the project to insert the task before, or `null` to insert at the end of the list.  # noqa: E501

        :return: The insert_before of this TaskAddProjectRequest.  # noqa: E501
        :rtype: str
        """
        return self._insert_before

    @insert_before.setter
    def insert_before(self, insert_before):
        """Sets the insert_before of this TaskAddProjectRequest.

        A task in the project to insert the task before, or `null` to insert at the end of the list.  # noqa: E501

        :param insert_before: The insert_before of this TaskAddProjectRequest.  # noqa: E501
        :type: str
        """

        self._insert_before = insert_before

    @property
    def section(self):
        """Gets the section of this TaskAddProjectRequest.  # noqa: E501

        A section in the project to insert the task into. The task will be inserted at the bottom of the section.  # noqa: E501

        :return: The section of this TaskAddProjectRequest.  # noqa: E501
        :rtype: str
        """
        return self._section

    @section.setter
    def section(self, section):
        """Sets the section of this TaskAddProjectRequest.

        A section in the project to insert the task into. The task will be inserted at the bottom of the section.  # noqa: E501

        :param section: The section of this TaskAddProjectRequest.  # noqa: E501
        :type: str
        """

        self._section = section

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaskAddProjectRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskAddProjectRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
