# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TeamMembershipBase(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'user': 'CustomFieldResponsePeopleValue',
        'team': 'ProjectTemplateBaseTeam',
        'is_guest': 'bool',
        'is_limited_access': 'bool',
        'is_admin': 'bool'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'user': 'user',
        'team': 'team',
        'is_guest': 'is_guest',
        'is_limited_access': 'is_limited_access',
        'is_admin': 'is_admin'
    }

    def __init__(self, gid=None, resource_type=None, user=None, team=None, is_guest=None, is_limited_access=None, is_admin=None):  # noqa: E501
        """TeamMembershipBase - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._user = None
        self._team = None
        self._is_guest = None
        self._is_limited_access = None
        self._is_admin = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if user is not None:
            self.user = user
        if team is not None:
            self.team = team
        if is_guest is not None:
            self.is_guest = is_guest
        if is_limited_access is not None:
            self.is_limited_access = is_limited_access
        if is_admin is not None:
            self.is_admin = is_admin

    @property
    def gid(self):
        """Gets the gid of this TeamMembershipBase.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this TeamMembershipBase.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this TeamMembershipBase.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this TeamMembershipBase.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this TeamMembershipBase.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this TeamMembershipBase.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this TeamMembershipBase.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this TeamMembershipBase.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def user(self):
        """Gets the user of this TeamMembershipBase.  # noqa: E501


        :return: The user of this TeamMembershipBase.  # noqa: E501
        :rtype: CustomFieldResponsePeopleValue
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this TeamMembershipBase.


        :param user: The user of this TeamMembershipBase.  # noqa: E501
        :type: CustomFieldResponsePeopleValue
        """

        self._user = user

    @property
    def team(self):
        """Gets the team of this TeamMembershipBase.  # noqa: E501


        :return: The team of this TeamMembershipBase.  # noqa: E501
        :rtype: ProjectTemplateBaseTeam
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this TeamMembershipBase.


        :param team: The team of this TeamMembershipBase.  # noqa: E501
        :type: ProjectTemplateBaseTeam
        """

        self._team = team

    @property
    def is_guest(self):
        """Gets the is_guest of this TeamMembershipBase.  # noqa: E501

        Describes if the user is a guest in the team.  # noqa: E501

        :return: The is_guest of this TeamMembershipBase.  # noqa: E501
        :rtype: bool
        """
        return self._is_guest

    @is_guest.setter
    def is_guest(self, is_guest):
        """Sets the is_guest of this TeamMembershipBase.

        Describes if the user is a guest in the team.  # noqa: E501

        :param is_guest: The is_guest of this TeamMembershipBase.  # noqa: E501
        :type: bool
        """

        self._is_guest = is_guest

    @property
    def is_limited_access(self):
        """Gets the is_limited_access of this TeamMembershipBase.  # noqa: E501

        Describes if the user has limited access to the team.  # noqa: E501

        :return: The is_limited_access of this TeamMembershipBase.  # noqa: E501
        :rtype: bool
        """
        return self._is_limited_access

    @is_limited_access.setter
    def is_limited_access(self, is_limited_access):
        """Sets the is_limited_access of this TeamMembershipBase.

        Describes if the user has limited access to the team.  # noqa: E501

        :param is_limited_access: The is_limited_access of this TeamMembershipBase.  # noqa: E501
        :type: bool
        """

        self._is_limited_access = is_limited_access

    @property
    def is_admin(self):
        """Gets the is_admin of this TeamMembershipBase.  # noqa: E501

        Describes if the user is a team admin.  # noqa: E501

        :return: The is_admin of this TeamMembershipBase.  # noqa: E501
        :rtype: bool
        """
        return self._is_admin

    @is_admin.setter
    def is_admin(self, is_admin):
        """Sets the is_admin of this TeamMembershipBase.

        Describes if the user is a team admin.  # noqa: E501

        :param is_admin: The is_admin of this TeamMembershipBase.  # noqa: E501
        :type: bool
        """

        self._is_admin = is_admin

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TeamMembershipBase, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TeamMembershipBase):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
