# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TeamResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'description': 'str',
        'html_description': 'str',
        'organization': 'TeamResponseOrganization',
        'permalink_url': 'str',
        'visibility': 'str',
        'edit_team_name_or_description_access_level': 'str',
        'edit_team_visibility_or_trash_team_access_level': 'str',
        'member_invite_management_access_level': 'str',
        'guest_invite_management_access_level': 'str',
        'join_request_management_access_level': 'str',
        'team_member_removal_access_level': 'str'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'description': 'description',
        'html_description': 'html_description',
        'organization': 'organization',
        'permalink_url': 'permalink_url',
        'visibility': 'visibility',
        'edit_team_name_or_description_access_level': 'edit_team_name_or_description_access_level',
        'edit_team_visibility_or_trash_team_access_level': 'edit_team_visibility_or_trash_team_access_level',
        'member_invite_management_access_level': 'member_invite_management_access_level',
        'guest_invite_management_access_level': 'guest_invite_management_access_level',
        'join_request_management_access_level': 'join_request_management_access_level',
        'team_member_removal_access_level': 'team_member_removal_access_level'
    }

    def __init__(self, gid=None, resource_type=None, name=None, description=None, html_description=None, organization=None, permalink_url=None, visibility=None, edit_team_name_or_description_access_level=None, edit_team_visibility_or_trash_team_access_level=None, member_invite_management_access_level=None, guest_invite_management_access_level=None, join_request_management_access_level=None, team_member_removal_access_level=None):  # noqa: E501
        """TeamResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._description = None
        self._html_description = None
        self._organization = None
        self._permalink_url = None
        self._visibility = None
        self._edit_team_name_or_description_access_level = None
        self._edit_team_visibility_or_trash_team_access_level = None
        self._member_invite_management_access_level = None
        self._guest_invite_management_access_level = None
        self._join_request_management_access_level = None
        self._team_member_removal_access_level = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if html_description is not None:
            self.html_description = html_description
        if organization is not None:
            self.organization = organization
        if permalink_url is not None:
            self.permalink_url = permalink_url
        if visibility is not None:
            self.visibility = visibility
        if edit_team_name_or_description_access_level is not None:
            self.edit_team_name_or_description_access_level = edit_team_name_or_description_access_level
        if edit_team_visibility_or_trash_team_access_level is not None:
            self.edit_team_visibility_or_trash_team_access_level = edit_team_visibility_or_trash_team_access_level
        if member_invite_management_access_level is not None:
            self.member_invite_management_access_level = member_invite_management_access_level
        if guest_invite_management_access_level is not None:
            self.guest_invite_management_access_level = guest_invite_management_access_level
        if join_request_management_access_level is not None:
            self.join_request_management_access_level = join_request_management_access_level
        if team_member_removal_access_level is not None:
            self.team_member_removal_access_level = team_member_removal_access_level

    @property
    def gid(self):
        """Gets the gid of this TeamResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this TeamResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this TeamResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this TeamResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this TeamResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this TeamResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this TeamResponse.  # noqa: E501

        The name of the team.  # noqa: E501

        :return: The name of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TeamResponse.

        The name of the team.  # noqa: E501

        :param name: The name of this TeamResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this TeamResponse.  # noqa: E501

        [Opt In](/docs/inputoutput-options). The description of the team.   # noqa: E501

        :return: The description of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TeamResponse.

        [Opt In](/docs/inputoutput-options). The description of the team.   # noqa: E501

        :param description: The description of this TeamResponse.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def html_description(self):
        """Gets the html_description of this TeamResponse.  # noqa: E501

        [Opt In](/docs/inputoutput-options). The description of the team with formatting as HTML.   # noqa: E501

        :return: The html_description of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._html_description

    @html_description.setter
    def html_description(self, html_description):
        """Sets the html_description of this TeamResponse.

        [Opt In](/docs/inputoutput-options). The description of the team with formatting as HTML.   # noqa: E501

        :param html_description: The html_description of this TeamResponse.  # noqa: E501
        :type: str
        """

        self._html_description = html_description

    @property
    def organization(self):
        """Gets the organization of this TeamResponse.  # noqa: E501


        :return: The organization of this TeamResponse.  # noqa: E501
        :rtype: TeamResponseOrganization
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this TeamResponse.


        :param organization: The organization of this TeamResponse.  # noqa: E501
        :type: TeamResponseOrganization
        """

        self._organization = organization

    @property
    def permalink_url(self):
        """Gets the permalink_url of this TeamResponse.  # noqa: E501

        A url that points directly to the object within Asana.  # noqa: E501

        :return: The permalink_url of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._permalink_url

    @permalink_url.setter
    def permalink_url(self, permalink_url):
        """Sets the permalink_url of this TeamResponse.

        A url that points directly to the object within Asana.  # noqa: E501

        :param permalink_url: The permalink_url of this TeamResponse.  # noqa: E501
        :type: str
        """

        self._permalink_url = permalink_url

    @property
    def visibility(self):
        """Gets the visibility of this TeamResponse.  # noqa: E501

        The visibility of the team to users in the same organization   # noqa: E501

        :return: The visibility of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility):
        """Sets the visibility of this TeamResponse.

        The visibility of the team to users in the same organization   # noqa: E501

        :param visibility: The visibility of this TeamResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["secret", "request_to_join", "public"]  # noqa: E501
        if visibility not in allowed_values:
            raise ValueError(
                "Invalid value for `visibility` ({0}), must be one of {1}"  # noqa: E501
                .format(visibility, allowed_values)
            )

        self._visibility = visibility

    @property
    def edit_team_name_or_description_access_level(self):
        """Gets the edit_team_name_or_description_access_level of this TeamResponse.  # noqa: E501

        Controls who can edit team name and description   # noqa: E501

        :return: The edit_team_name_or_description_access_level of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._edit_team_name_or_description_access_level

    @edit_team_name_or_description_access_level.setter
    def edit_team_name_or_description_access_level(self, edit_team_name_or_description_access_level):
        """Sets the edit_team_name_or_description_access_level of this TeamResponse.

        Controls who can edit team name and description   # noqa: E501

        :param edit_team_name_or_description_access_level: The edit_team_name_or_description_access_level of this TeamResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["all_team_members", "only_team_admins"]  # noqa: E501
        if edit_team_name_or_description_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `edit_team_name_or_description_access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(edit_team_name_or_description_access_level, allowed_values)
            )

        self._edit_team_name_or_description_access_level = edit_team_name_or_description_access_level

    @property
    def edit_team_visibility_or_trash_team_access_level(self):
        """Gets the edit_team_visibility_or_trash_team_access_level of this TeamResponse.  # noqa: E501

        Controls who can edit team visibility and trash teams   # noqa: E501

        :return: The edit_team_visibility_or_trash_team_access_level of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._edit_team_visibility_or_trash_team_access_level

    @edit_team_visibility_or_trash_team_access_level.setter
    def edit_team_visibility_or_trash_team_access_level(self, edit_team_visibility_or_trash_team_access_level):
        """Sets the edit_team_visibility_or_trash_team_access_level of this TeamResponse.

        Controls who can edit team visibility and trash teams   # noqa: E501

        :param edit_team_visibility_or_trash_team_access_level: The edit_team_visibility_or_trash_team_access_level of this TeamResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["all_team_members", "only_team_admins"]  # noqa: E501
        if edit_team_visibility_or_trash_team_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `edit_team_visibility_or_trash_team_access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(edit_team_visibility_or_trash_team_access_level, allowed_values)
            )

        self._edit_team_visibility_or_trash_team_access_level = edit_team_visibility_or_trash_team_access_level

    @property
    def member_invite_management_access_level(self):
        """Gets the member_invite_management_access_level of this TeamResponse.  # noqa: E501

        Controls who can accept or deny member invites for a given team   # noqa: E501

        :return: The member_invite_management_access_level of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._member_invite_management_access_level

    @member_invite_management_access_level.setter
    def member_invite_management_access_level(self, member_invite_management_access_level):
        """Sets the member_invite_management_access_level of this TeamResponse.

        Controls who can accept or deny member invites for a given team   # noqa: E501

        :param member_invite_management_access_level: The member_invite_management_access_level of this TeamResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["all_team_members", "only_team_admins"]  # noqa: E501
        if member_invite_management_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `member_invite_management_access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(member_invite_management_access_level, allowed_values)
            )

        self._member_invite_management_access_level = member_invite_management_access_level

    @property
    def guest_invite_management_access_level(self):
        """Gets the guest_invite_management_access_level of this TeamResponse.  # noqa: E501

        Controls who can accept or deny guest invites for a given team   # noqa: E501

        :return: The guest_invite_management_access_level of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._guest_invite_management_access_level

    @guest_invite_management_access_level.setter
    def guest_invite_management_access_level(self, guest_invite_management_access_level):
        """Sets the guest_invite_management_access_level of this TeamResponse.

        Controls who can accept or deny guest invites for a given team   # noqa: E501

        :param guest_invite_management_access_level: The guest_invite_management_access_level of this TeamResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["all_team_members", "only_team_admins"]  # noqa: E501
        if guest_invite_management_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `guest_invite_management_access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(guest_invite_management_access_level, allowed_values)
            )

        self._guest_invite_management_access_level = guest_invite_management_access_level

    @property
    def join_request_management_access_level(self):
        """Gets the join_request_management_access_level of this TeamResponse.  # noqa: E501

        Controls who can accept or deny join team requests for a Membership by Request team   # noqa: E501

        :return: The join_request_management_access_level of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._join_request_management_access_level

    @join_request_management_access_level.setter
    def join_request_management_access_level(self, join_request_management_access_level):
        """Sets the join_request_management_access_level of this TeamResponse.

        Controls who can accept or deny join team requests for a Membership by Request team   # noqa: E501

        :param join_request_management_access_level: The join_request_management_access_level of this TeamResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["all_team_members", "only_team_admins"]  # noqa: E501
        if join_request_management_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `join_request_management_access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(join_request_management_access_level, allowed_values)
            )

        self._join_request_management_access_level = join_request_management_access_level

    @property
    def team_member_removal_access_level(self):
        """Gets the team_member_removal_access_level of this TeamResponse.  # noqa: E501

        Controls who can remove team members   # noqa: E501

        :return: The team_member_removal_access_level of this TeamResponse.  # noqa: E501
        :rtype: str
        """
        return self._team_member_removal_access_level

    @team_member_removal_access_level.setter
    def team_member_removal_access_level(self, team_member_removal_access_level):
        """Sets the team_member_removal_access_level of this TeamResponse.

        Controls who can remove team members   # noqa: E501

        :param team_member_removal_access_level: The team_member_removal_access_level of this TeamResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["all_team_members", "only_team_admins"]  # noqa: E501
        if team_member_removal_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `team_member_removal_access_level` ({0}), must be one of {1}"  # noqa: E501
                .format(team_member_removal_access_level, allowed_values)
            )

        self._team_member_removal_access_level = team_member_removal_access_level

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TeamResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TeamResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
