# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TimePeriodCompact(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'end_on': 'str',
        'start_on': 'str',
        'period': 'str',
        'display_name': 'str'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'end_on': 'end_on',
        'start_on': 'start_on',
        'period': 'period',
        'display_name': 'display_name'
    }

    def __init__(self, gid=None, resource_type=None, end_on=None, start_on=None, period=None, display_name=None):  # noqa: E501
        """TimePeriodCompact - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._end_on = None
        self._start_on = None
        self._period = None
        self._display_name = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if end_on is not None:
            self.end_on = end_on
        if start_on is not None:
            self.start_on = start_on
        if period is not None:
            self.period = period
        if display_name is not None:
            self.display_name = display_name

    @property
    def gid(self):
        """Gets the gid of this TimePeriodCompact.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this TimePeriodCompact.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this TimePeriodCompact.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this TimePeriodCompact.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this TimePeriodCompact.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this TimePeriodCompact.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this TimePeriodCompact.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this TimePeriodCompact.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def end_on(self):
        """Gets the end_on of this TimePeriodCompact.  # noqa: E501

        The localized end date of the time period in `YYYY-MM-DD` format.  # noqa: E501

        :return: The end_on of this TimePeriodCompact.  # noqa: E501
        :rtype: str
        """
        return self._end_on

    @end_on.setter
    def end_on(self, end_on):
        """Sets the end_on of this TimePeriodCompact.

        The localized end date of the time period in `YYYY-MM-DD` format.  # noqa: E501

        :param end_on: The end_on of this TimePeriodCompact.  # noqa: E501
        :type: str
        """

        self._end_on = end_on

    @property
    def start_on(self):
        """Gets the start_on of this TimePeriodCompact.  # noqa: E501

        The localized start date of the time period in `YYYY-MM-DD` format.  # noqa: E501

        :return: The start_on of this TimePeriodCompact.  # noqa: E501
        :rtype: str
        """
        return self._start_on

    @start_on.setter
    def start_on(self, start_on):
        """Sets the start_on of this TimePeriodCompact.

        The localized start date of the time period in `YYYY-MM-DD` format.  # noqa: E501

        :param start_on: The start_on of this TimePeriodCompact.  # noqa: E501
        :type: str
        """

        self._start_on = start_on

    @property
    def period(self):
        """Gets the period of this TimePeriodCompact.  # noqa: E501

        The cadence and index of the time period. The value is one of: `FY`, `H1`, `H2`, `Q1`, `Q2`, `Q3`, or `Q4`.  # noqa: E501

        :return: The period of this TimePeriodCompact.  # noqa: E501
        :rtype: str
        """
        return self._period

    @period.setter
    def period(self, period):
        """Sets the period of this TimePeriodCompact.

        The cadence and index of the time period. The value is one of: `FY`, `H1`, `H2`, `Q1`, `Q2`, `Q3`, or `Q4`.  # noqa: E501

        :param period: The period of this TimePeriodCompact.  # noqa: E501
        :type: str
        """
        allowed_values = ["FY", "H1", "H2", "Q1", "Q2", "Q3", "Q4"]  # noqa: E501
        if period not in allowed_values:
            raise ValueError(
                "Invalid value for `period` ({0}), must be one of {1}"  # noqa: E501
                .format(period, allowed_values)
            )

        self._period = period

    @property
    def display_name(self):
        """Gets the display_name of this TimePeriodCompact.  # noqa: E501

        A string representing the cadence code and the fiscal year.  # noqa: E501

        :return: The display_name of this TimePeriodCompact.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this TimePeriodCompact.

        A string representing the cadence code and the fiscal year.  # noqa: E501

        :param display_name: The display_name of this TimePeriodCompact.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TimePeriodCompact, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TimePeriodCompact):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
