# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UserResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'email': 'str',
        'photo': 'UserBaseResponsePhoto',
        'workspaces': 'list[GoalResponseWorkspace]'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'email': 'email',
        'photo': 'photo',
        'workspaces': 'workspaces'
    }

    def __init__(self, gid=None, resource_type=None, name=None, email=None, photo=None, workspaces=None):  # noqa: E501
        """UserResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._email = None
        self._photo = None
        self._workspaces = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if email is not None:
            self.email = email
        if photo is not None:
            self.photo = photo
        if workspaces is not None:
            self.workspaces = workspaces

    @property
    def gid(self):
        """Gets the gid of this UserResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this UserResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this UserResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this UserResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this UserResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this UserResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this UserResponse.  # noqa: E501

        *Read-only except when same user as requester*. The user’s name.  # noqa: E501

        :return: The name of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UserResponse.

        *Read-only except when same user as requester*. The user’s name.  # noqa: E501

        :param name: The name of this UserResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def email(self):
        """Gets the email of this UserResponse.  # noqa: E501

        The user's email address.  # noqa: E501

        :return: The email of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserResponse.

        The user's email address.  # noqa: E501

        :param email: The email of this UserResponse.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def photo(self):
        """Gets the photo of this UserResponse.  # noqa: E501


        :return: The photo of this UserResponse.  # noqa: E501
        :rtype: UserBaseResponsePhoto
        """
        return self._photo

    @photo.setter
    def photo(self, photo):
        """Sets the photo of this UserResponse.


        :param photo: The photo of this UserResponse.  # noqa: E501
        :type: UserBaseResponsePhoto
        """

        self._photo = photo

    @property
    def workspaces(self):
        """Gets the workspaces of this UserResponse.  # noqa: E501

        Workspaces and organizations this user may access. Note\\: The API will only return workspaces and organizations that also contain the authenticated user.  # noqa: E501

        :return: The workspaces of this UserResponse.  # noqa: E501
        :rtype: list[GoalResponseWorkspace]
        """
        return self._workspaces

    @workspaces.setter
    def workspaces(self, workspaces):
        """Sets the workspaces of this UserResponse.

        Workspaces and organizations this user may access. Note\\: The API will only return workspaces and organizations that also contain the authenticated user.  # noqa: E501

        :param workspaces: The workspaces of this UserResponse.  # noqa: E501
        :type: list[GoalResponseWorkspace]
        """

        self._workspaces = workspaces

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
