# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UserTaskListCompact(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'owner': 'AllOfUserTaskListCompactOwner',
        'workspace': 'AllOfUserTaskListCompactWorkspace'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'owner': 'owner',
        'workspace': 'workspace'
    }

    def __init__(self, gid=None, resource_type=None, name=None, owner=None, workspace=None):  # noqa: E501
        """UserTaskListCompact - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._owner = None
        self._workspace = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if owner is not None:
            self.owner = owner
        if workspace is not None:
            self.workspace = workspace

    @property
    def gid(self):
        """Gets the gid of this UserTaskListCompact.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this UserTaskListCompact.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this UserTaskListCompact.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this UserTaskListCompact.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this UserTaskListCompact.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this UserTaskListCompact.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this UserTaskListCompact.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this UserTaskListCompact.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this UserTaskListCompact.  # noqa: E501

        The name of the user task list.  # noqa: E501

        :return: The name of this UserTaskListCompact.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UserTaskListCompact.

        The name of the user task list.  # noqa: E501

        :param name: The name of this UserTaskListCompact.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def owner(self):
        """Gets the owner of this UserTaskListCompact.  # noqa: E501

        The owner of the user task list, i.e. the person whose My Tasks is represented by this resource.  # noqa: E501

        :return: The owner of this UserTaskListCompact.  # noqa: E501
        :rtype: AllOfUserTaskListCompactOwner
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this UserTaskListCompact.

        The owner of the user task list, i.e. the person whose My Tasks is represented by this resource.  # noqa: E501

        :param owner: The owner of this UserTaskListCompact.  # noqa: E501
        :type: AllOfUserTaskListCompactOwner
        """

        self._owner = owner

    @property
    def workspace(self):
        """Gets the workspace of this UserTaskListCompact.  # noqa: E501

        The workspace in which the user task list is located.  # noqa: E501

        :return: The workspace of this UserTaskListCompact.  # noqa: E501
        :rtype: AllOfUserTaskListCompactWorkspace
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this UserTaskListCompact.

        The workspace in which the user task list is located.  # noqa: E501

        :param workspace: The workspace of this UserTaskListCompact.  # noqa: E501
        :type: AllOfUserTaskListCompactWorkspace
        """

        self._workspace = workspace

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserTaskListCompact, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserTaskListCompact):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
