# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WebhookCompact(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'active': 'bool',
        'resource': 'WebhookCompactResource',
        'target': 'str'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'active': 'active',
        'resource': 'resource',
        'target': 'target'
    }

    def __init__(self, gid=None, resource_type=None, active=None, resource=None, target=None):  # noqa: E501
        """WebhookCompact - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._active = None
        self._resource = None
        self._target = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if active is not None:
            self.active = active
        if resource is not None:
            self.resource = resource
        if target is not None:
            self.target = target

    @property
    def gid(self):
        """Gets the gid of this WebhookCompact.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this WebhookCompact.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this WebhookCompact.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this WebhookCompact.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this WebhookCompact.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this WebhookCompact.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this WebhookCompact.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this WebhookCompact.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def active(self):
        """Gets the active of this WebhookCompact.  # noqa: E501

        If true, the webhook will send events - if false it is considered inactive and will not generate events.  # noqa: E501

        :return: The active of this WebhookCompact.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this WebhookCompact.

        If true, the webhook will send events - if false it is considered inactive and will not generate events.  # noqa: E501

        :param active: The active of this WebhookCompact.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def resource(self):
        """Gets the resource of this WebhookCompact.  # noqa: E501


        :return: The resource of this WebhookCompact.  # noqa: E501
        :rtype: WebhookCompactResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this WebhookCompact.


        :param resource: The resource of this WebhookCompact.  # noqa: E501
        :type: WebhookCompactResource
        """

        self._resource = resource

    @property
    def target(self):
        """Gets the target of this WebhookCompact.  # noqa: E501

        The URL to receive the HTTP POST.  # noqa: E501

        :return: The target of this WebhookCompact.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this WebhookCompact.

        The URL to receive the HTTP POST.  # noqa: E501

        :param target: The target of this WebhookCompact.  # noqa: E501
        :type: str
        """

        self._target = target

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebhookCompact, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebhookCompact):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
