# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WebhookRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource': 'str',
        'target': 'str',
        'filters': 'list[WebhookRequestFilters]'
    }

    attribute_map = {
        'resource': 'resource',
        'target': 'target',
        'filters': 'filters'
    }

    def __init__(self, resource=None, target=None, filters=None):  # noqa: E501
        """WebhookRequest - a model defined in Swagger"""  # noqa: E501
        self._resource = None
        self._target = None
        self._filters = None
        self.discriminator = None
        self.resource = resource
        self.target = target
        if filters is not None:
            self.filters = filters

    @property
    def resource(self):
        """Gets the resource of this WebhookRequest.  # noqa: E501

        A resource ID to subscribe to. Many Asana resources are valid to create webhooks on, but higher-level resources require filters.  # noqa: E501

        :return: The resource of this WebhookRequest.  # noqa: E501
        :rtype: str
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this WebhookRequest.

        A resource ID to subscribe to. Many Asana resources are valid to create webhooks on, but higher-level resources require filters.  # noqa: E501

        :param resource: The resource of this WebhookRequest.  # noqa: E501
        :type: str
        """
        if resource is None:
            raise ValueError("Invalid value for `resource`, must not be `None`")  # noqa: E501

        self._resource = resource

    @property
    def target(self):
        """Gets the target of this WebhookRequest.  # noqa: E501

        The URL to receive the HTTP POST. The full URL will be used to deliver events from this webhook (including parameters) which allows encoding of application-specific state when the webhook is created.  # noqa: E501

        :return: The target of this WebhookRequest.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this WebhookRequest.

        The URL to receive the HTTP POST. The full URL will be used to deliver events from this webhook (including parameters) which allows encoding of application-specific state when the webhook is created.  # noqa: E501

        :param target: The target of this WebhookRequest.  # noqa: E501
        :type: str
        """
        if target is None:
            raise ValueError("Invalid value for `target`, must not be `None`")  # noqa: E501

        self._target = target

    @property
    def filters(self):
        """Gets the filters of this WebhookRequest.  # noqa: E501

        An array of WebhookFilter objects to specify a whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.  # noqa: E501

        :return: The filters of this WebhookRequest.  # noqa: E501
        :rtype: list[WebhookRequestFilters]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this WebhookRequest.

        An array of WebhookFilter objects to specify a whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.  # noqa: E501

        :param filters: The filters of this WebhookRequest.  # noqa: E501
        :type: list[WebhookRequestFilters]
        """

        self._filters = filters

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebhookRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebhookRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
