# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WebhookRequestFilters(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource_type': 'str',
        'resource_subtype': 'str',
        'action': 'str',
        'fields': 'list[str]'
    }

    attribute_map = {
        'resource_type': 'resource_type',
        'resource_subtype': 'resource_subtype',
        'action': 'action',
        'fields': 'fields'
    }

    def __init__(self, resource_type=None, resource_subtype=None, action=None, fields=None):  # noqa: E501
        """WebhookRequestFilters - a model defined in Swagger"""  # noqa: E501
        self._resource_type = None
        self._resource_subtype = None
        self._action = None
        self._fields = None
        self.discriminator = None
        if resource_type is not None:
            self.resource_type = resource_type
        if resource_subtype is not None:
            self.resource_subtype = resource_subtype
        if action is not None:
            self.action = action
        if fields is not None:
            self.fields = fields

    @property
    def resource_type(self):
        """Gets the resource_type of this WebhookRequestFilters.  # noqa: E501

        The type of the resource which created the event when modified; for example, to filter to changes on regular tasks this field should be set to `task`.  # noqa: E501

        :return: The resource_type of this WebhookRequestFilters.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this WebhookRequestFilters.

        The type of the resource which created the event when modified; for example, to filter to changes on regular tasks this field should be set to `task`.  # noqa: E501

        :param resource_type: The resource_type of this WebhookRequestFilters.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def resource_subtype(self):
        """Gets the resource_subtype of this WebhookRequestFilters.  # noqa: E501

        The resource subtype of the resource that the filter applies to. This should be set to the same value as is returned on the `resource_subtype` field on the resources themselves.  # noqa: E501

        :return: The resource_subtype of this WebhookRequestFilters.  # noqa: E501
        :rtype: str
        """
        return self._resource_subtype

    @resource_subtype.setter
    def resource_subtype(self, resource_subtype):
        """Sets the resource_subtype of this WebhookRequestFilters.

        The resource subtype of the resource that the filter applies to. This should be set to the same value as is returned on the `resource_subtype` field on the resources themselves.  # noqa: E501

        :param resource_subtype: The resource_subtype of this WebhookRequestFilters.  # noqa: E501
        :type: str
        """

        self._resource_subtype = resource_subtype

    @property
    def action(self):
        """Gets the action of this WebhookRequestFilters.  # noqa: E501

        The type of change on the **resource** to pass through the filter. For more information refer to `Event.action` in the [event](/reference/events) schema. This can be one of `changed`, `added`, `removed`, `deleted`, and `undeleted` depending on the nature of what has occurred on the resource.  # noqa: E501

        :return: The action of this WebhookRequestFilters.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this WebhookRequestFilters.

        The type of change on the **resource** to pass through the filter. For more information refer to `Event.action` in the [event](/reference/events) schema. This can be one of `changed`, `added`, `removed`, `deleted`, and `undeleted` depending on the nature of what has occurred on the resource.  # noqa: E501

        :param action: The action of this WebhookRequestFilters.  # noqa: E501
        :type: str
        """

        self._action = action

    @property
    def fields(self):
        """Gets the fields of this WebhookRequestFilters.  # noqa: E501

        *Conditional.* A whitelist of fields for events which will pass the filter when the resource is changed. These can be any combination of the fields on the resources themselves. This field is only valid for `action` of type `changed`  # noqa: E501

        :return: The fields of this WebhookRequestFilters.  # noqa: E501
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """Sets the fields of this WebhookRequestFilters.

        *Conditional.* A whitelist of fields for events which will pass the filter when the resource is changed. These can be any combination of the fields on the resources themselves. This field is only valid for `action` of type `changed`  # noqa: E501

        :param fields: The fields of this WebhookRequestFilters.  # noqa: E501
        :type: list[str]
        """

        self._fields = fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebhookRequestFilters, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebhookRequestFilters):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
